/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.openflashchart.outputs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import ofc4j.OFCException;
import ofc4j.model.Chart;
import org.jfree.chart.ChartRenderingInfo;
import org.pentaho.chart.plugin.api.IOutput;
import org.pentaho.chart.plugin.api.PersistenceException;

public class OpenFlashChartOutput
implements IOutput {
    private Chart chart;
    private ChartRenderingInfo info;
    private static final String OPEN_FLASHCHART_JSON = "{\"bg_colour\":\"#FFFFFF\",\"inner_bg_colour\":\"#EEEEEE\",\"title\":{\"text\":\"Bar Chart\",\"style\":\"font-family: Arial; font-size: 14px; font-weight: bold; font-style: normal;\"},\"y_legend\":{\"text\":\"Sales\",\"style\":\"font-family: Arial; font-size: 12px; font-weight: normal; font-style: normal;\"},\"x_legend\":{\"text\":\"Years\",\"style\":\"font-family: Arial; font-size: 12px; font-weight: normal; font-style: normal;\"},\"y_axis\":{\"min\":0,\"steps\":204252,\"stroke\":1,\"grid-colour\":\"#aaaaaa\",\"colour\":\"#000000\",\"max\":2246772},\"x_axis\":{\"stroke\":1,\"grid-colour\":\"#aaaaaa\",\"colour\":\"#000000\",\"labels\":{\"labels\":[\"2003\",\"2004\",\"2005\"]},\"offset\":1},\"elements\":[{\"text\":\"Classic Cars\",\"type\":\"bar\",\"values\":[{\"top\":1514407.42},{\"top\":1838274.85},{\"top\":738737.6}],\"colour\":\"#387179\"},{\"text\":\"Vintage Cars\",\"type\":\"bar\",\"values\":[{\"top\":679948.55},{\"top\":997559.65},{\"top\":388718.19}],\"colour\":\"#626638\"},{\"text\":\"Trucks and Buses\",\"type\":\"bar\",\"values\":[{\"top\":420429.93},{\"top\":531975.89},{\"top\":201874.75}],\"colour\":\"#A8979A\"},{\"text\":\"Motorcycles\",\"type\":\"bar\",\"values\":[{\"top\":397219.71},{\"top\":590580.25},{\"top\":286325.23}],\"colour\":\"#B09A6B\"},{\"text\":\"Planes\",\"type\":\"bar\",\"values\":[{\"top\":347755.01},{\"top\":528927.94},{\"top\":200074.17}],\"colour\":\"#772200\"},{\"text\":\"Ships\",\"type\":\"bar\",\"values\":[{\"top\":244821.09},{\"top\":375671.69},{\"top\":128178.07}],\"colour\":\"#C52F0D\"},{\"text\":\"Trains\",\"type\":\"bar\",\"values\":[{\"top\":72802.29},{\"top\":124749.57},{\"top\":36917.33}],\"colour\":\"#123D82\"}]}";

    public OpenFlashChartOutput(Chart chart) {
        this.chart = chart;
    }

    @Override
    public OutputStream persistChart(OutputStream outputStream, IOutput.OutputTypes fileType, int width, int height) throws PersistenceException {
        if (outputStream == null) {
            outputStream = new ByteArrayOutputStream();
        }
        try {
            outputStream.flush();
        }
        catch (IOException e1) {
            throw new PersistenceException(e1);
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "utf-8");
            outputStreamWriter.write(this.chart.toString());
            outputStreamWriter.flush();
        }
        catch (UnsupportedEncodingException e) {
            throw new PersistenceException(e);
        }
        catch (OFCException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        return outputStream;
    }

    @Override
    public Writer persistMap(Writer outputStream, String mapName) throws PersistenceException {
        throw new UnsupportedOperationException();
    }

    private String getMap(String mapName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getDrawable() {
        return this.chart;
    }
}

