/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.datastorage;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;

public class ConfigurationUtil {
    public static Configuration toConfiguration(Properties properties) {
        assert (properties != null);
        Configuration config = new Configuration(false);
        Enumeration<Object> iter = properties.keys();
        while (iter.hasMoreElements()) {
            String key = (String)iter.nextElement();
            String val = properties.getProperty(key);
            config.set(key, val);
        }
        return config;
    }

    public static Properties toProperties(Configuration configuration) {
        Properties properties = new Properties();
        assert (configuration != null);
        for (Map.Entry entry : configuration) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public static void mergeConf(Configuration origConf, Configuration replaceConf) {
        for (Map.Entry entry : replaceConf) {
            origConf.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static Properties getLocalFSProperties() {
        Configuration localConf = new Configuration(false);
        localConf.addResource("core-default.xml");
        Properties props = ConfigurationUtil.toProperties(localConf);
        props.setProperty("fs.default.name", "file:///");
        return props;
    }
}

