/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.ColumnInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnChainInfo
implements Cloneable {
    private List<ColumnInfo> columnInfos = new ArrayList<ColumnInfo>();

    public boolean equals(Object o2) {
        if (!(o2 instanceof ColumnChainInfo)) {
            return false;
        }
        ColumnChainInfo c2 = (ColumnChainInfo)o2;
        if (this.columnInfos.size() != c2.columnInfos.size()) {
            return false;
        }
        for (int i = 0; i < this.columnInfos.size(); ++i) {
            if (this.columnInfos.get(i).equals(c2.columnInfos.get(i))) continue;
            return false;
        }
        return true;
    }

    public void insert(boolean star, List<Integer> columns, byte type) {
        ColumnInfo newColumnInfo = new ColumnInfo(star, columns, type);
        this.columnInfos.add(newColumnInfo);
    }

    public void insertInReduce(boolean star, List<Integer> columns, byte type) {
        if (this.size() == 0) {
            ArrayList<Integer> newColumns = new ArrayList<Integer>();
            newColumns.add(columns.get(0) - 1);
            ColumnInfo newColumnInfo = new ColumnInfo(star, newColumns, type);
            this.columnInfos.add(newColumnInfo);
        } else {
            this.insert(star, columns, type);
        }
    }

    public void insertColumnChainInfo(ColumnChainInfo columnChainInfo) {
        this.columnInfos.addAll(columnChainInfo.columnInfos);
    }

    public List<ColumnInfo> getColumnInfos() {
        return this.columnInfos;
    }

    public String toString() {
        return this.columnInfos.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        ColumnChainInfo result = new ColumnChainInfo();
        for (ColumnInfo columnInfo : this.columnInfos) {
            ColumnInfo newColumnInfo = new ColumnInfo(columnInfo.star, columnInfo.columns, columnInfo.resultType);
            result.columnInfos.add(newColumnInfo);
        }
        return result;
    }

    public int size() {
        return this.columnInfos.size();
    }

    public ColumnInfo getColumnInfo(int i) {
        return this.columnInfos.get(i);
    }

    public int hashCode() {
        int result = 0;
        for (ColumnInfo columnInfo : this.columnInfos) {
            result += columnInfo.hashCode();
        }
        return result;
    }
}

