/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;

public abstract class ExpressionOperator
extends LogicalOperator {
    private static final long serialVersionUID = 2L;
    private static Log log = LogFactory.getLog(ExpressionOperator.class);
    protected boolean mIsFieldSchemaComputed = false;
    protected Schema.FieldSchema mFieldSchema = null;

    public ExpressionOperator(LogicalPlan plan, OperatorKey k, int rp) {
        super(plan, k, rp);
    }

    public ExpressionOperator(LogicalPlan plan, OperatorKey k) {
        super(plan, k);
    }

    public boolean supportsMultipleOutputs() {
        return true;
    }

    public Schema getSchema() throws FrontendException {
        return this.mSchema;
    }

    public Schema.FieldSchema getFieldSchema() throws FrontendException {
        Schema.FieldSchema fs = new Schema.FieldSchema(null, this.mType);
        return fs;
    }

    public void setFieldSchema(Schema.FieldSchema fs) throws FrontendException {
        this.mFieldSchema = fs;
        this.setAlias(fs.alias);
        this.setType(fs.type);
        this.mIsFieldSchemaComputed = true;
    }

    public void unsetFieldSchema() {
        this.mIsFieldSchemaComputed = false;
        this.mFieldSchema = null;
    }

    public Schema.FieldSchema regenerateFieldSchema() throws FrontendException {
        this.unsetFieldSchema();
        return this.getFieldSchema();
    }

    void setFieldSchemaComputed(boolean b) {
        this.mIsFieldSchemaComputed = b;
    }

    boolean getFieldSchemaComputed() {
        return this.mIsFieldSchemaComputed;
    }

    public byte getType() {
        try {
            this.getFieldSchema();
        }
        catch (FrontendException fe) {
            return 0;
        }
        if (this.mFieldSchema != null) {
            return this.mFieldSchema.type;
        }
        return 0;
    }

    protected Object clone() throws CloneNotSupportedException {
        ExpressionOperator exOpClone = (ExpressionOperator)super.clone();
        if (this.mFieldSchema != null) {
            exOpClone.mFieldSchema = this.mFieldSchema.clone();
        }
        return exOpClone;
    }
}

