/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectStarTranslator
extends LOVisitor {
    public ProjectStarTranslator(LogicalPlan plan) {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new DependencyOrderWalker<LogicalOperator, LogicalPlan>(plan));
    }

    @Override
    protected void visit(LOCogroup cg) throws VisitorException {
        MultiMap<LogicalOperator, LogicalPlan> mapGByPlans = cg.getGroupByPlans();
        for (LogicalOperator op : cg.getInputs()) {
            ArrayList<LogicalPlan> newGByPlans = new ArrayList<LogicalPlan>();
            for (LogicalPlan lp : mapGByPlans.get(op)) {
                if (this.checkPlanForProjectStar(lp)) {
                    ArrayList<LogicalPlan> translatedPlans = this.translateProjectStarInPlan(lp);
                    for (int j = 0; j < translatedPlans.size(); ++j) {
                        newGByPlans.add(translatedPlans.get(j));
                    }
                    continue;
                }
                newGByPlans.add(lp);
            }
            mapGByPlans.removeKey(op);
            mapGByPlans.put(op, newGByPlans);
        }
        if (cg.getInputs().size() > 1) {
            for (LogicalOperator op : cg.getInputs()) {
                for (LogicalPlan lp : mapGByPlans.get(op)) {
                    if (!this.checkPlanForProjectStar(lp)) continue;
                    throw new VisitorException("Cogroup/Group by * is only allowed if the input has a schema");
                }
            }
            int arity = mapGByPlans.get(cg.getInputs().get(0)).size();
            for (LogicalOperator op : cg.getInputs()) {
                if (arity == mapGByPlans.get(op).size()) continue;
                throw new VisitorException("The arity of cogroup/group by columns do not match");
            }
        }
    }

    @Override
    protected void visit(LOJoin join) throws VisitorException {
        MultiMap<LogicalOperator, LogicalPlan> joinColPlans = join.getJoinPlans();
        for (LogicalOperator op : join.getInputs()) {
            ArrayList<LogicalPlan> newPlansAfterTranslation = new ArrayList<LogicalPlan>();
            for (LogicalPlan lp : joinColPlans.get(op)) {
                if (this.checkPlanForProjectStar(lp)) {
                    ArrayList<LogicalPlan> translatedPlans = this.translateProjectStarInPlan(lp);
                    for (int j = 0; j < translatedPlans.size(); ++j) {
                        newPlansAfterTranslation.add(translatedPlans.get(j));
                    }
                    continue;
                }
                newPlansAfterTranslation.add(lp);
            }
            joinColPlans.removeKey(op);
            joinColPlans.put(op, newPlansAfterTranslation);
        }
    }

    @Override
    protected void visit(LOForEach forEach) throws VisitorException {
        super.visit(forEach);
        ArrayList<LogicalPlan> foreachPlans = forEach.getForEachPlans();
        ArrayList<LogicalPlan> newForeachPlans = new ArrayList<LogicalPlan>();
        List<Boolean> flattenList = forEach.getFlatten();
        ArrayList<Boolean> newFlattenList = new ArrayList<Boolean>();
        List<Schema> userDefinedSchemaList = forEach.getUserDefinedSchema();
        ArrayList<Schema> newUserDefinedSchemaList = new ArrayList<Schema>();
        for (int i = 0; i < foreachPlans.size(); ++i) {
            LogicalPlan lp = foreachPlans.get(i);
            if (this.checkPlanForProjectStar(lp)) {
                ArrayList<LogicalPlan> translatedPlans = this.translateProjectStarInPlan(lp);
                Schema s = userDefinedSchemaList.get(i);
                for (int j = 0; j < translatedPlans.size(); ++j) {
                    LogicalPlan translatedPlan = translatedPlans.get(j);
                    newForeachPlans.add(translatedPlan);
                    newFlattenList.add(flattenList.get(i));
                    if (null != s) {
                        try {
                            if (j < s.size()) {
                                newUserDefinedSchemaList.add(new Schema(s.getField(j)));
                                continue;
                            }
                            newUserDefinedSchemaList.add(null);
                            continue;
                        }
                        catch (FrontendException fee) {
                            throw new VisitorException(fee.getMessage(), fee);
                        }
                    }
                    newUserDefinedSchemaList.add(null);
                }
                continue;
            }
            newForeachPlans.add(lp);
            newFlattenList.add(flattenList.get(i));
            if (null != userDefinedSchemaList) {
                newUserDefinedSchemaList.add(userDefinedSchemaList.get(i));
                continue;
            }
            newUserDefinedSchemaList.add(null);
        }
        forEach.setForEachPlans(newForeachPlans);
        forEach.setFlatten(newFlattenList);
        forEach.setUserDefinedSchema(newUserDefinedSchemaList);
    }

    @Override
    protected void visit(LOSort s) throws VisitorException {
        List<LogicalPlan> sortPlans = s.getSortColPlans();
        ArrayList<LogicalPlan> newSortPlans = new ArrayList<LogicalPlan>();
        List<Boolean> sortOrder = s.getAscendingCols();
        ArrayList<Boolean> newSortOrder = new ArrayList<Boolean>();
        for (int i = 0; i < sortPlans.size(); ++i) {
            LogicalPlan lp = sortPlans.get(i);
            if (this.checkPlanForProjectStar(lp)) {
                ArrayList<LogicalPlan> translatedPlans = this.translateProjectStarInPlan(lp);
                for (int j = 0; j < translatedPlans.size(); ++j) {
                    newSortPlans.add(translatedPlans.get(j));
                    newSortOrder.add(sortOrder.get(i));
                }
                continue;
            }
            newSortPlans.add(lp);
            newSortOrder.add(sortOrder.get(i));
        }
        s.setSortColPlans(newSortPlans);
        s.setAscendingCols(newSortOrder);
    }

    private boolean checkPlanForProjectStar(LogicalPlan lp) {
        List leaves = lp.getLeaves();
        for (LogicalOperator op : leaves) {
            if (!(op instanceof LOProject) || !((LOProject)op).isStar() || ((LOProject)op).getType() == 120) continue;
            return true;
        }
        return false;
    }

    private LOProject getProjectStarFromPlan(LogicalPlan lp) {
        List leaves = lp.getLeaves();
        for (LogicalOperator op : leaves) {
            if (!(op instanceof LOProject) || !((LOProject)op).isStar()) continue;
            return (LOProject)op;
        }
        return null;
    }

    private ArrayList<LogicalPlan> translateProjectStarInPlan(LogicalPlan lp) throws VisitorException {
        LOProject projectStar = this.getProjectStarFromPlan(lp);
        LogicalOperator projectInput = projectStar.getExpression();
        ArrayList<LogicalPlan> translatedPlans = new ArrayList<LogicalPlan>();
        Schema s = null;
        try {
            if (!(projectInput instanceof ExpressionOperator)) {
                s = projectInput.getSchema();
            } else {
                Schema.FieldSchema fs = ((ExpressionOperator)projectInput).getFieldSchema();
                if (null != fs) {
                    s = fs.schema;
                }
            }
        }
        catch (FrontendException fee) {
            throw new VisitorException(fee.getMessage(), fee);
        }
        if (null != s) {
            for (int i = 0; i < s.size(); ++i) {
                LogicalPlan replicatedPlan = this.replicatePlan(lp);
                this.replaceProjectStar(replicatedPlan, projectStar, i);
                translatedPlans.add(replicatedPlan);
            }
        } else {
            translatedPlans.add(this.replicatePlan(lp));
        }
        return translatedPlans;
    }

    private LogicalPlan replicatePlan(LogicalPlan lp) throws VisitorException {
        LogicalPlan replicatedPlan = new LogicalPlan();
        for (LogicalOperator root : lp.getRoots()) {
            replicatedPlan.add(root);
            this.addSuccessors(lp, replicatedPlan, root);
        }
        return replicatedPlan;
    }

    private void addSuccessors(LogicalPlan lp, LogicalPlan replicatedPlan, LogicalOperator root) throws VisitorException {
        List<LogicalOperator> successors = lp.getSuccessors(root);
        if (null == successors) {
            return;
        }
        for (LogicalOperator succ : successors) {
            replicatedPlan.add(succ);
            try {
                replicatedPlan.connect(root, succ);
            }
            catch (PlanException pe) {
                throw new VisitorException(pe.getMessage(), pe);
            }
            this.addSuccessors(lp, replicatedPlan, succ);
        }
    }

    private void replaceProjectStar(LogicalPlan lp, LOProject projectStar, int column) throws VisitorException {
        String scope = projectStar.getOperatorKey().getScope();
        LogicalOperator projectInput = projectStar.getExpression();
        LogicalPlan projectPlan = projectStar.getPlan();
        LOProject replacementProject = new LOProject(projectPlan, OperatorKey.genOpKey(scope), projectInput, column);
        try {
            lp.replace(projectStar, replacementProject);
        }
        catch (PlanException pe) {
            throw new VisitorException(pe.getMessage(), pe);
        }
    }
}

