/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan.optimizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.RulePlanVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleOperator
extends Operator<RulePlanVisitor> {
    private static final long serialVersionUID = 2L;
    private static Log log = LogFactory.getLog(RuleOperator.class);
    private Class mNodeClass;
    private NodeType mNodeType = NodeType.SIMPLE_NODE;

    public RuleOperator(Class clazz, OperatorKey k) {
        super(k);
        this.mNodeClass = clazz;
    }

    public RuleOperator(Class clazz, NodeType nodeType, OperatorKey k) {
        super(k);
        this.mNodeType = nodeType;
        this.mNodeClass = clazz;
    }

    public final void setNodeType(NodeType type) {
        this.mNodeType = type;
    }

    public NodeType getNodeType() {
        return this.mNodeType;
    }

    public Class getNodeClass() {
        return this.mNodeClass;
    }

    @Override
    public String toString() {
        return this.name();
    }

    @Override
    public void visit(RulePlanVisitor v) throws VisitorException {
        v.visit(this);
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return true;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        RuleOperator ruleOpClone = (RuleOperator)super.clone();
        return ruleOpClone;
    }

    @Override
    public String name() {
        StringBuffer msg = new StringBuffer();
        msg.append("(Name: " + this.mNodeClass.getSimpleName() + " Node Type: " + (Object)((Object)this.mNodeType) + "[" + this.mKey + "]" + ")");
        return msg.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeType {
        ANY_NODE,
        SIMPLE_NODE,
        MULTI_NODE,
        COMMON_NODE;

    }
}

