/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.util.IdentityHashSet;
import org.apache.pig.pen.util.ExampleTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricEvaluation {
    public static float getRealness(LogicalOperator op, Map<LogicalOperator, DataBag> exampleData, boolean overallRealness) {
        int noTuples = 0;
        int noSynthetic = 0;
        for (Map.Entry<LogicalOperator, DataBag> e : exampleData.entrySet()) {
            if (e.getKey().getAlias() == null) continue;
            DataBag bag = overallRealness ? exampleData.get(e.getKey()) : exampleData.get(op);
            noTuples = (int)((long)noTuples + bag.size());
            Iterator<Tuple> it = bag.iterator();
            while (it.hasNext()) {
                if (!((ExampleTuple)it.next()).synthetic) continue;
                ++noSynthetic;
            }
            if (overallRealness) continue;
            break;
        }
        if (noTuples == 0) {
            if (noSynthetic == 0) {
                return 0.0f;
            }
            return 100.0f;
        }
        return 100.0f * (1.0f - (float)noSynthetic / (float)noTuples);
    }

    public static float getConciseness(LogicalOperator op, Map<LogicalOperator, DataBag> exampleData, Map<LogicalOperator, Collection<IdentityHashSet<Tuple>>> OperatorToEqClasses, boolean overallConciseness) {
        DataBag bag = exampleData.get(op);
        int noEqCl = OperatorToEqClasses.get(op).size();
        long noTuples = bag.size();
        float conciseness = 100.0f * ((float)noEqCl / (float)noTuples);
        if (!overallConciseness) {
            return (double)conciseness > 100.0 ? 100.0f : conciseness;
        }
        noEqCl = 0;
        noTuples = 0L;
        conciseness = 0.0f;
        int noOperators = 0;
        for (Map.Entry<LogicalOperator, Collection<IdentityHashSet<Tuple>>> e : OperatorToEqClasses.entrySet()) {
            if (e.getKey().getAlias() == null) continue;
            ++noOperators;
            bag = exampleData.get(e.getKey());
            noTuples = bag.size();
            noEqCl = e.getValue().size();
            float concise = 100.0f * ((float)noEqCl / (float)noTuples);
            concise = concise > 100.0f ? 100.0f : concise;
            conciseness += concise;
        }
        return conciseness /= (float)noOperators;
    }

    public static float getCompleteness(LogicalOperator op, Map<LogicalOperator, DataBag> exampleData, Map<LogicalOperator, Collection<IdentityHashSet<Tuple>>> OperatorToEqClasses, boolean overallCompleteness) {
        int noClasses = 0;
        int noCoveredClasses = 0;
        int noOperators = 0;
        float completeness = 0.0f;
        if (!overallCompleteness) {
            Collection<IdentityHashSet<Tuple>> eqClasses = OperatorToEqClasses.get(op);
            DataBag bag = op instanceof LOFilter ? exampleData.get(((LOFilter)op).getInput()) : exampleData.get(op);
            Map<Integer, Boolean> coveredClasses = MetricEvaluation.getCompletenessLogic(bag, eqClasses);
            noClasses = eqClasses.size();
            for (Map.Entry<Integer, Boolean> e : coveredClasses.entrySet()) {
                if (!e.getValue().booleanValue()) continue;
                ++noCoveredClasses;
            }
            return 100.0f * (float)noCoveredClasses / (float)noClasses;
        }
        for (Map.Entry<LogicalOperator, Collection<IdentityHashSet<Tuple>>> e : OperatorToEqClasses.entrySet()) {
            noCoveredClasses = 0;
            noClasses = 0;
            if (e.getKey().getAlias() == null) continue;
            ++noOperators;
            Collection<IdentityHashSet<Tuple>> eqClasses = e.getValue();
            LogicalOperator lop = e.getKey();
            DataBag bag = lop instanceof LOFilter ? exampleData.get(((LOFilter)lop).getInput()) : exampleData.get(lop);
            Map<Integer, Boolean> coveredClasses = MetricEvaluation.getCompletenessLogic(bag, eqClasses);
            noClasses += eqClasses.size();
            for (Map.Entry<Integer, Boolean> e_result : coveredClasses.entrySet()) {
                if (!e_result.getValue().booleanValue()) continue;
                ++noCoveredClasses;
            }
            completeness += 100.0f * ((float)noCoveredClasses / (float)noClasses);
        }
        return completeness /= (float)noOperators;
    }

    private static Map<Integer, Boolean> getCompletenessLogic(DataBag bag, Collection<IdentityHashSet<Tuple>> eqClasses) {
        HashMap<Integer, Boolean> coveredClasses = new HashMap<Integer, Boolean>();
        for (Tuple t : bag) {
            int classId = 0;
            for (IdentityHashSet<Tuple> eqClass : eqClasses) {
                if (eqClass.contains(t) || eqClass.size() == 0) {
                    coveredClasses.put(classId, true);
                }
                ++classId;
            }
        }
        return coveredClasses;
    }
}

