/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class OutputStats {
    private String name;
    private String location;
    private long bytes;
    private long records;
    private boolean success;
    private POStore store = null;
    private Configuration conf;

    OutputStats(String location, long bytes, long records, boolean success) {
        this.location = location;
        this.bytes = bytes;
        this.records = records;
        this.success = success;
        try {
            this.name = new Path(location).getName();
        }
        catch (Exception e) {
            this.name = location;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public long getBytes() {
        return this.bytes;
    }

    public long getNumberRecords() {
        return this.records;
    }

    public String getFunctionName() {
        return this.store == null ? null : this.store.getSFile().getFuncSpec().getClassName();
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public String getAlias() {
        return this.store == null ? null : this.store.getAlias();
    }

    public POStore getPOStore() {
        return this.store;
    }

    public Configuration getConf() {
        return this.conf;
    }

    String getDisplayString(boolean local) {
        StringBuilder sb = new StringBuilder();
        if (this.success) {
            sb.append("Successfully stored ");
            if (!local) {
                sb.append(this.records).append(" records ");
            } else {
                sb.append("records ");
            }
            if (this.bytes > 0L) {
                sb.append("(").append(this.bytes).append(" bytes) ");
            }
            sb.append("in: \"").append(this.location).append("\"\n");
        } else {
            sb.append("Failed to produce result in \"").append(this.location).append("\"\n");
        }
        return sb.toString();
    }

    void setPOStore(POStore store) {
        this.store = store;
    }

    void setConf(Configuration conf) {
        this.conf = conf;
    }
}

