/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.environment;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.cdf.environment.ICdfEnvironment;
import org.pentaho.cdf.environment.factory.CoreBeanFactory;
import org.pentaho.cdf.environment.factory.ICdfBeanFactory;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.exceptions.InitializationException;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.repository.api.IUserContentAccess;

public class CdfEngine {
    protected static Log logger = LogFactory.getLog(CdfEngine.class);
    private static CdfEngine instance;
    private ICdfEnvironment environment;

    private CdfEngine() {
        logger.debug((Object)"Starting ElementEngine");
    }

    private CdfEngine(ICdfEnvironment environment) {
        this();
        this.environment = environment;
    }

    public static CdfEngine getInstance() {
        if (instance == null) {
            instance = new CdfEngine();
            try {
                CdfEngine.initialize();
            }
            catch (Exception ex) {
                logger.fatal((Object)("Error initializing CdeEngine: " + Util.getExceptionDescription((Exception)ex)));
            }
        }
        return instance;
    }

    public static ICdfEnvironment getEnvironment() {
        return CdfEngine.getInstance().environment;
    }

    public static IReadAccess getPluginSystemReader(String path) {
        return CdfEngine.getEnvironment().getContentAccessFactory().getPluginSystemReader(path);
    }

    public static IReadAccess getPluginRepositoryReader(String path) {
        return CdfEngine.getEnvironment().getContentAccessFactory().getPluginRepositoryReader(path);
    }

    public static IUserContentAccess getUserContentReader(String path) {
        return CdfEngine.getEnvironment().getContentAccessFactory().getUserContentAccess(path);
    }

    private static void initialize() throws InitializationException {
        if (CdfEngine.instance.environment == null) {
            CoreBeanFactory factory = new CoreBeanFactory();
            ICdfEnvironment env = instance.getConfiguredEnvironment(factory);
            if (env != null) {
                env.init(factory);
            }
            CdfEngine.instance.environment = env;
        }
    }

    protected synchronized ICdfEnvironment getConfiguredEnvironment(ICdfBeanFactory factory) throws InitializationException {
        String simpleName = ICdfEnvironment.class.getSimpleName();
        Object obj = new CoreBeanFactory().getBean(simpleName);
        if (obj != null && obj instanceof ICdfEnvironment) {
            return (ICdfEnvironment)obj;
        }
        String msg = "No bean found for " + simpleName;
        logger.fatal((Object)msg);
        throw new InitializationException(msg, null);
    }
}

