/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.environment.factory;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.cdf.environment.factory.ICdfBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CoreBeanFactory
implements ICdfBeanFactory {
    public static final String CDF_SPRING_BEAN = "cdf.spring.xml";
    private static final Log logger = LogFactory.getLog(CoreBeanFactory.class);
    protected static ConfigurableApplicationContext context;

    public CoreBeanFactory() {
        context = this.getSpringBeanFactory(CDF_SPRING_BEAN);
    }

    public CoreBeanFactory(String config) {
        context = this.getSpringBeanFactory(config);
    }

    @Override
    public Object getBean(String id) {
        if (context.containsBean(id)) {
            return context.getBean(id);
        }
        return null;
    }

    @Override
    public boolean containsBean(String id) {
        if (context != null) {
            return context.containsBean(id);
        }
        return false;
    }

    @Override
    public String[] getBeanNamesForType(Class clazz) {
        return context.getBeanNamesForType(clazz);
    }

    protected ConfigurableApplicationContext getSpringBeanFactory(String config) {
        try {
            final ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource(config);
            if (url != null) {
                logger.debug((Object)("Found spring file @ " + url));
                ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(config){

                    protected void initBeanDefinitionReader(XmlBeanDefinitionReader beanDefinitionReader) {
                        beanDefinitionReader.setBeanClassLoader(cl);
                    }

                    protected void prepareBeanFactory(ConfigurableListableBeanFactory clBeanFactory) {
                        super.prepareBeanFactory(clBeanFactory);
                        clBeanFactory.setBeanClassLoader(cl);
                    }

                    public ClassLoader getClassLoader() {
                        return cl;
                    }
                };
                return context;
            }
        }
        catch (Exception e) {
            logger.fatal((Object)"Error loading cdf.spring.xml", (Throwable)e);
        }
        logger.fatal((Object)"Spring definition file does not exist. There should be a <plugin_name>.spring.xml file on the classpath ");
        return null;
    }
}

