/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.utils;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtil {
    private static final Log logger = LogFactory.getLog(JsonUtil.class);

    public static JSONObject makeJsonErrorResponse(String errorMessage, boolean logErrorMessage) {
        JSONObject json = new JSONObject();
        try {
            json.put("status", (Object)"error");
            if (!StringUtils.isEmpty((String)errorMessage)) {
                json.put("message", (Object)errorMessage);
                if (logErrorMessage) {
                    logger.error((Object)errorMessage);
                }
            }
        }
        catch (JSONException e) {
            logger.error((Object)e);
        }
        return json;
    }

    public static JSONObject makeJsonSuccessResponse(Object payload) throws JSONException {
        if (payload == null) {
            return new JSONObject();
        }
        try {
            if (payload instanceof String) {
                return new JSONObject(payload.toString());
            }
            JSONObject json = new JSONObject();
            json.put("status", (Object)"sucess");
            json.put("result", payload);
            return json;
        }
        catch (JSONException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public static boolean isSuccessResponse(JSONObject json) {
        try {
            return json != null && "sucess".equals(json.get("status"));
        }
        catch (JSONException e) {
            logger.error((Object)e);
            return false;
        }
    }

    public static class JsonResult {
        public static final String SUCCESS = "sucess";
        public static final String ERROR = "error";
    }

    public static class JsonFields {
        public static final String STATUS = "status";
        public static final String MESSAGE = "message";
        public static final String RESULT_PAYLOAD = "result";
    }
}

