/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.pentaho.cdf.PluginHibernateException;
import org.pentaho.cdf.environment.CdfEngine;
import org.pentaho.cdf.environment.ICdfEnvironment;
import pt.webdetails.cpf.Util;

public class PluginHibernateUtil {
    private static final Log logger = LogFactory.getLog(PluginHibernateUtil.class);
    private static Configuration configuration;
    private static SessionFactory sessionFactory;
    private static final byte[] lock;
    private static final ThreadLocal<Session> threadSession;
    private static final ThreadLocal<Transaction> threadTransaction;
    private static boolean initialized;

    public static boolean initialize() {
        if (!initialized) {
            logger.debug((Object)"Initializing PluginHibernate");
            configuration = new Configuration();
            ICdfEnvironment cdfEnvironment = CdfEngine.getEnvironment();
            String hibernateAvailable = cdfEnvironment.getResourceLoader().getPluginSetting(PluginHibernateUtil.class, "settings/hibernate-available");
            if ("true".equalsIgnoreCase(hibernateAvailable)) {
                configuration.setProperties(cdfEnvironment.getHibernateConfigurations().getConfiguration().getProperties());
                sessionFactory = configuration.buildSessionFactory();
            }
            initialized = true;
            return true;
        }
        return false;
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rebuildSessionFactory() throws PluginHibernateException {
        byte[] byArray = lock;
        synchronized (lock) {
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(PluginHibernateUtil.class.getClassLoader());
                sessionFactory = PluginHibernateUtil.getConfiguration().buildSessionFactory();
            }
            catch (Exception ex) {
                logger.warn((Object)("Error building session factory " + Util.getExceptionDescription((Exception)ex)));
                throw new PluginHibernateException("Error building session factory", ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextCL);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static synchronized Session getSession() throws PluginHibernateException {
        Session s = threadSession.get();
        try {
            if (s == null || !s.isOpen()) {
                s = PluginHibernateUtil.getSessionFactory().openSession();
            }
            threadSession.set(s);
        }
        catch (HibernateException ex) {
            logger.warn((Object)("Error creating session " + Util.getExceptionDescription((Exception)((Object)ex))));
            throw new PluginHibernateException("Error creating session", (Exception)((Object)ex));
        }
        return s;
    }

    public static void flushSession() throws PluginHibernateException {
        try {
            Session s = PluginHibernateUtil.getSession();
            s.flush();
        }
        catch (HibernateException ex) {
            logger.warn((Object)("Error flushing session " + Util.getExceptionDescription((Exception)((Object)ex))));
            throw new PluginHibernateException("Error flushing session", (Exception)((Object)ex));
        }
    }

    public static synchronized void closeSession() throws PluginHibernateException {
        try {
            Session s = threadSession.get();
            threadSession.set(null);
            if (s != null && s.isOpen()) {
                s.close();
            }
            threadTransaction.set(null);
        }
        catch (HibernateException ex) {
            threadTransaction.set(null);
            logger.warn((Object)("Error closing session " + Util.getExceptionDescription((Exception)((Object)ex))));
            throw new PluginHibernateException("Error closing session", (Exception)((Object)ex));
        }
    }

    static {
        lock = new byte[0];
        threadSession = new ThreadLocal();
        threadTransaction = new ThreadLocal();
    }
}

