/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.api;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataBodyPart;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.dataaccess.datasource.api.DatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.metadata.MetadataPublisher;
import org.pentaho.platform.plugin.services.importer.IPlatformImportBundle;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.web.http.api.resources.FileResource;

public class MetadataService
extends DatasourceService {
    private static final Log logger = LogFactory.getLog(MetadataService.class);

    public void removeMetadata(String metadataId) throws PentahoAccessControlException {
        if (!this.canAdministerCheck()) {
            throw new PentahoAccessControlException();
        }
        this.metadataDomainRepository.removeDomain(this.fixEncodedSlashParam(metadataId));
    }

    public List<String> getMetadataDatasourceIds() {
        ArrayList<String> metadataIds = new ArrayList<String>();
        try {
            this.sleep(100);
            for (String id : this.metadataDomainRepository.getDomainIds()) {
                if (!this.isMetadataDatasource(id)) continue;
                metadataIds.add(id);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return metadataIds;
    }

    public void importMetadataDatasource(String domainId, InputStream metadataFile, FormDataContentDisposition metadataFileInfo, boolean overwrite, List<FormDataBodyPart> localeFiles, List<FormDataContentDisposition> localeFilesInfo) throws PentahoAccessControlException, PlatformImportException, Exception {
        this.accessValidation();
        FileResource fr = this.createNewFileResource();
        Object reservedCharsObject = fr.doGetReservedChars().getEntity();
        String reservedChars = this.objectToString(reservedCharsObject);
        if (reservedChars != null && domainId.matches(".*[" + reservedChars.replaceAll("/", "") + "]+.*")) {
            String msg = this.prohibitedSymbolMessage(domainId, fr);
            throw new PlatformImportException(msg, 10);
        }
        RepositoryFileImportBundle.Builder bundleBuilder = this.createNewRepositoryFileImportBundleBuilder(metadataFile, overwrite, domainId);
        if (localeFiles != null) {
            for (int i = 0; i < localeFiles.size(); ++i) {
                logger.info((Object)"create language file");
                ByteArrayInputStream bais = this.createNewByteArrayInputStream((byte[])localeFiles.get(i).getValueAs(byte[].class));
                RepositoryFileImportBundle localizationBundle = this.createNewRepositoryFileImportBundle(bais, localeFilesInfo.get(i).getFileName(), domainId);
                bundleBuilder.addChildBundle((IPlatformImportBundle)localizationBundle);
            }
        }
        RepositoryFileImportBundle bundle = bundleBuilder.build();
        IPlatformImporter importer = this.getImporter();
        importer.importFile((IPlatformImportBundle)bundle);
        IPentahoSession pentahoSession = this.getSession();
        this.publish(pentahoSession);
    }

    protected void sleep(int i) throws InterruptedException {
        Thread.sleep(i);
    }

    protected String prohibitedSymbolMessage(String domainId, FileResource fr) throws InterruptedException {
        String illegalCharacterList = (String)fr.doGetReservedCharactersDisplay().getEntity();
        illegalCharacterList = illegalCharacterList.replaceAll("\\,", "");
        return Messages.getString("MetadataDatasourceService.ERROR_003_PROHIBITED_SYMBOLS_ERROR", domainId, illegalCharacterList);
    }

    protected String objectToString(Object o) throws InterruptedException {
        return (String)o;
    }

    protected void publish(IPentahoSession pentahoSession) throws InterruptedException {
        PentahoSystem.publish((IPentahoSession)pentahoSession, (String)MetadataPublisher.class.getName());
    }

    protected IPentahoSession getSession() throws InterruptedException {
        return PentahoSessionHolder.getSession();
    }

    protected IPlatformImporter getImporter() throws InterruptedException {
        return (IPlatformImporter)PentahoSystem.get(IPlatformImporter.class);
    }

    protected void accessValidation() throws PentahoAccessControlException {
        DatasourceService.validateAccess();
    }

    protected boolean canAdministerCheck() {
        return DatasourceService.canAdminister();
    }

    protected FileResource createNewFileResource() {
        return new FileResource();
    }

    protected RepositoryFileImportBundle.Builder createNewRepositoryFileImportBundleBuilder(InputStream metadataFile, boolean overWriteInRepository, String domainId) {
        return new RepositoryFileImportBundle.Builder().input(metadataFile).charSet("UTF-8").hidden(false).overwriteFile(overWriteInRepository).mime("text/xmi+xml").withParam("domain-id", domainId);
    }

    protected RepositoryFileImportBundle createNewRepositoryFileImportBundle(ByteArrayInputStream bais, String fileName, String domainId) {
        return new RepositoryFileImportBundle.Builder().input((InputStream)bais).charSet("UTF-8").hidden(false).name(fileName).withParam("domain-id", domainId).build();
    }

    protected ByteArrayInputStream createNewByteArrayInputStream(byte[] buf) {
        return new ByteArrayInputStream(buf);
    }
}

