/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.api.resources;

import com.sun.jersey.multipart.FormDataParam;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.dataaccess.datasource.api.DataSourceWizardService;
import org.pentaho.platform.dataaccess.datasource.api.resources.ResourceUtil;
import org.pentaho.platform.web.http.api.resources.JaxbList;

public class DataSourceWizardResource {
    protected DataSourceWizardService service = new DataSourceWizardService();
    protected ResourceUtil resourceUtil = new ResourceUtil();

    @GET
    @Path(value="/datasource/dsw/domain/{dswId : .+}")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="DSW datasource export succeeded."), @ResponseCode(code=401, condition="User is not authorized to export DSW datasource."), @ResponseCode(code=500, condition="Failure to export DSW datasource.")})
    public Response downloadDsw(@PathParam(value="dswId") String dswId) {
        try {
            Map<String, InputStream> fileData = this.service.doGetDSWFilesAsDownload(dswId);
            return this.createAttachment(fileData, dswId);
        }
        catch (PentahoAccessControlException e) {
            return this.buildUnauthorizedResponse();
        }
    }

    @DELETE
    @Path(value="/datasource/dsw/domain/{dswId : .+}")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="DSW datasource removed successfully."), @ResponseCode(code=401, condition="User is not authorized to remove DSW datasource.")})
    public Response remove(@PathParam(value="dswId") String dswId) {
        try {
            this.service.removeDSW(dswId);
            return this.buildOkResponse();
        }
        catch (PentahoAccessControlException e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    @GET
    @Path(value="/datasource/dsw/domain")
    @Produces(value={"application/xml", "application/json"})
    public JaxbList<String> getDSWDIds() {
        return this.createNewJaxbList(this.service.getDSWDatasourceIds());
    }

    protected Response buildOkResponse() {
        return Response.ok().build();
    }

    protected Response buildOkResponse(String dswId) {
        return Response.ok((Object)dswId).build();
    }

    protected Response buildServerErrorResponse() {
        return Response.serverError().build();
    }

    protected Response buildUnauthorizedResponse() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    protected Response buildBadRequestResponse(String message) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
    }

    protected Response buildConfilictResponse(String message) {
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)message).build();
    }

    protected Response createAttachment(Map<String, InputStream> fileData, String dswId) {
        return this.resourceUtil.createAttachment(fileData, dswId);
    }

    protected JaxbList<String> createNewJaxbList(List<String> DSWDatasources) {
        return new JaxbList(DSWDatasources);
    }

    @PUT
    @Path(value="/datasource/dsw/import")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @Facet(name="Unsupported")
    public Response publishDsw(@FormDataParam(value="domainId") String domainId, @FormDataParam(value="metadataFile") InputStream metadataFile, @FormDataParam(value="overwrite") @DefaultValue(value="false") boolean overwrite, @FormDataParam(value="checkConnection") @DefaultValue(value="false") boolean checkConnection) {
        try {
            String dswId = this.service.publishDsw(domainId, metadataFile, overwrite, checkConnection);
            return this.buildOkResponse(dswId);
        }
        catch (PentahoAccessControlException e) {
            return this.buildUnauthorizedResponse();
        }
        catch (IllegalArgumentException e) {
            return this.buildBadRequestResponse(e.getMessage());
        }
        catch (DataSourceWizardService.DswPublishValidationException e) {
            return this.buildConfilictResponse(e.getMessage());
        }
        catch (Exception e) {
            return this.buildServerErrorResponse();
        }
    }
}

