/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.ui.admindialog;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.platform.dataaccess.datasource.IDatasourceInfo;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;

public class DatasourceAdminDialogModel
extends XulEventSourceAdapter {
    private List<IDatasourceInfo> datasources = new ArrayList<IDatasourceInfo>();
    private List<String> datasourceTypes;
    private IDatasourceInfo selectedDatasource;
    private int selectedIndex = -1;

    public void addDatasource(IDatasourceInfo datasource) {
        this.datasources.add(datasource);
        this.firePropertyChange("datasources", null, this.datasources);
    }

    public void removeDatasource(IDatasourceInfo datasource) {
        this.datasources.remove(datasource);
        this.firePropertyChange("datasources", null, this.datasources);
    }

    @Bindable
    public List<IDatasourceInfo> getDatasourcesList() {
        return this.datasources;
    }

    @Bindable
    public void setDatasourcesList(List<IDatasourceInfo> datasourceList) {
        List<IDatasourceInfo> previousList = this.getPreviousDatasourceList();
        this.datasources.clear();
        this.firePropertyChange("datasources", previousList, datasourceList);
    }

    private List<IDatasourceInfo> getPreviousDatasourceList() {
        ArrayList<IDatasourceInfo> previous = new ArrayList<IDatasourceInfo>();
        previous.addAll(this.datasources);
        return previous;
    }

    @Bindable
    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
        this.firePropertyChange("selectedIndex", selectedIndex + 1, selectedIndex);
    }

    @Bindable
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Bindable
    public void setDatasourceTypeList(List<String> datasourceTypes) {
        this.datasourceTypes = new ArrayList<String>(datasourceTypes);
        this.firePropertyChange("datasourceTypes", null, datasourceTypes);
    }

    @Bindable
    public List<String> getDatasourceTypeList() {
        return this.datasourceTypes;
    }

    @Bindable
    public void setSelectedDatasource(IDatasourceInfo selectedDatasource) {
        this.selectedDatasource = selectedDatasource;
        this.firePropertyChange("selectedDatasource", null, selectedDatasource);
    }

    @Bindable
    public IDatasourceInfo getSelectedDatasource() {
        return this.selectedDatasource;
    }
}

