/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.ui.importing;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.gwt.widgets.client.utils.NameUtils;
import org.pentaho.gwt.widgets.client.utils.i18n.ResourceBundle;
import org.pentaho.gwt.widgets.client.utils.string.StringUtils;
import org.pentaho.platform.dataaccess.datasource.IDatasourceInfo;
import org.pentaho.platform.dataaccess.datasource.ui.importing.AnalysisImportDialogModel;
import org.pentaho.platform.dataaccess.datasource.ui.importing.IImportPerspective;
import org.pentaho.platform.dataaccess.datasource.ui.importing.IOverwritableController;
import org.pentaho.platform.dataaccess.datasource.ui.importing.ParameterDialogModel;
import org.pentaho.platform.dataaccess.datasource.wizard.DatasourceMessages;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.ui.database.event.IConnectionAutoBeanFactory;
import org.pentaho.ui.database.event.IDatabaseConnectionList;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulConfirmBox;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulRadio;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractXulDialogController;
import org.pentaho.ui.xul.util.XulDialogCallback;

public class AnalysisImportDialogController
extends AbstractXulDialogController<AnalysisImportDialogModel>
implements IImportPerspective,
IOverwritableController {
    private static final String MONDRIAN_POSTANALYSIS_URL = "plugin/data-access/api/mondrian/postAnalysis";
    public static final String ATTRIBUTE_STANDARD_CONNECTION = "STANDARD_CONNECTION";
    private static Logger logger = Logger.getLogger(AnalysisImportDialogController.class.getName());
    private BindingFactory bf;
    private XulMenuList connectionList;
    private XulTree analysisParametersTree;
    private XulDialog importDialog;
    private XulDialog analysisParametersDialog;
    private ResourceBundle resBundle;
    private AnalysisImportDialogModel importDialogModel;
    private XulTextbox paramNameTextBox;
    private XulTextbox paramValueTextBox;
    private XulDeck analysisPreferencesDeck;
    private XulRadio availableRadio;
    private XulRadio manualRadio;
    private XulButton acceptButton;
    private XulButton parametersAcceptButton;
    private FileUpload analysisUpload;
    private XulLabel schemaNameLabel;
    private XulLabel analysisFileLabel;
    private String importURL;
    private boolean overwrite = false;
    private static final Integer PARAMETER_MODE = 1;
    private static final Integer DATASOURCE_MODE = 0;
    protected static final String SUCCESS = "3";
    protected static final int PUBLISH_SCHEMA_EXISTS_ERROR = 8;
    protected static final int PUBLISH_SCHEMA_CATALOG_EXISTS_ERROR = 7;
    private static FormPanel.SubmitCompleteHandler submitHandler = null;
    private DatasourceMessages messages = null;
    private XulVbox hiddenArea;
    private FormPanel formPanel;
    private FlowPanel mainFormPanel;
    private FileUpload analysisFileUpload;
    private XulButton uploadAnalysisButton;
    private IDatasourceInfo datasourceInfo;
    protected IConnectionAutoBeanFactory connectionAutoBeanFactory;

    public void init() {
        try {
            this.connectionAutoBeanFactory = (IConnectionAutoBeanFactory)GWT.create(IConnectionAutoBeanFactory.class);
            this.resBundle = (ResourceBundle)super.getXulDomContainer().getResourceBundles().get(0);
            this.importDialogModel = new AnalysisImportDialogModel();
            this.connectionList = (XulMenuList)this.document.getElementById("connectionList");
            this.analysisParametersTree = (XulTree)this.document.getElementById("analysisParametersTree");
            this.importDialog = (XulDialog)this.document.getElementById("importDialog");
            this.analysisParametersDialog = (XulDialog)this.document.getElementById("analysisParametersDialog");
            this.paramNameTextBox = (XulTextbox)this.document.getElementById("paramNameTextBox");
            this.paramNameTextBox.addPropertyChangeListener((PropertyChangeListener)new ParametersChangeListener());
            this.paramValueTextBox = (XulTextbox)this.document.getElementById("paramValueTextBox");
            this.paramValueTextBox.addPropertyChangeListener((PropertyChangeListener)new ParametersChangeListener());
            this.analysisPreferencesDeck = (XulDeck)this.document.getElementById("analysisPreferencesDeck");
            this.availableRadio = (XulRadio)this.document.getElementById("availableRadio");
            this.manualRadio = (XulRadio)this.document.getElementById("manualRadio");
            this.hiddenArea = (XulVbox)this.document.getElementById("analysisImportCard");
            this.schemaNameLabel = (XulLabel)this.document.getElementById("schemaNameLabel");
            this.analysisFileLabel = (XulLabel)this.document.getElementById("analysisFileLabel");
            this.uploadAnalysisButton = (XulButton)this.document.getElementById("uploadAnalysisButton");
            this.acceptButton = (XulButton)this.document.getElementById("importDialog_accept");
            this.acceptButton.setDisabled(true);
            this.parametersAcceptButton = (XulButton)this.document.getElementById("analysisParametersDialog_accept");
            this.parametersAcceptButton.setDisabled(true);
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            this.bf.createBinding((Object)this.connectionList, "selectedIndex", (Object)this.importDialogModel, "connection", new BindingConvertor[]{new BindingConvertor<Integer, IDatabaseConnection>(){

                public Integer targetToSource(IDatabaseConnection connection) {
                    return -1;
                }

                public IDatabaseConnection sourceToTarget(Integer value) {
                    if (value >= 0) {
                        return AnalysisImportDialogController.this.importDialogModel.getConnectionList().get(value);
                    }
                    return null;
                }
            }});
            this.bf.createBinding((Object)this.manualRadio, "checked", (Object)this, "preference", new BindingConvertor[]{new PreferencesBindingConvertor()});
            this.bf.createBinding((Object)this, "connectionNames", (Object)this.connectionList, "elements", new BindingConvertor[0]);
            Binding domainBinding = this.bf.createBinding((Object)this.importDialogModel, "connectionList", (Object)this, "relationalConnections", new BindingConvertor[0]);
            Binding analysisParametersBinding = this.bf.createBinding((Object)this.importDialogModel, "analysisParameters", (Object)this.analysisParametersTree, "elements", new BindingConvertor[0]);
            domainBinding.fireSourceChanged();
            analysisParametersBinding.fireSourceChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Bindable
    public void setRelationalConnections(List<IDatabaseConnection> connections) {
        ArrayList<String> names = new ArrayList<String>();
        for (IDatabaseConnection conn : connections) {
            names.add(conn.getName());
        }
        this.firePropertyChange("connectionNames", null, names);
    }

    public static String getBaseURL() {
        String moduleUrl = GWT.getModuleBaseURL();
        if (moduleUrl.indexOf("content") > -1) {
            String baseUrl = moduleUrl.substring(0, moduleUrl.indexOf("content"));
            return baseUrl + "plugin/data-access/api/connection/";
        }
        return moduleUrl + "plugin/data-access/api/connection/";
    }

    private void createWorkingForm() {
        if (this.formPanel == null) {
            this.formPanel = new FormPanel();
            this.formPanel.setMethod("post");
            this.formPanel.setEncoding("multipart/form-data");
            this.formPanel.setAction(MONDRIAN_POSTANALYSIS_URL);
            this.formPanel.getElement().getStyle().setProperty("position", "absolute");
            this.formPanel.getElement().getStyle().setProperty("visibility", "hidden");
            this.formPanel.getElement().getStyle().setProperty("overflow", "hidden");
            this.formPanel.getElement().getStyle().setProperty("clip", "rect(0px,0px,0px,0px)");
            this.mainFormPanel = new FlowPanel();
            this.formPanel.add((Widget)this.mainFormPanel);
            this.analysisFileUpload = new FileUpload();
            this.analysisFileUpload.setName("uploadAnalysis");
            this.analysisFileUpload.getElement().setId("analysisFileUpload");
            this.analysisFileUpload.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    AnalysisImportDialogController.this.schemaNameLabel.setValue(((FileUpload)event.getSource()).getFilename());
                    AnalysisImportDialogController.this.importDialogModel.setUploadedFile(((FileUpload)event.getSource()).getFilename());
                    AnalysisImportDialogController.this.acceptButton.setDisabled(!AnalysisImportDialogController.this.isValid());
                }
            });
            this.mainFormPanel.add((Widget)this.analysisFileUpload);
            VerticalPanel vp = (VerticalPanel)this.hiddenArea.getManagedObject();
            vp.add((Widget)this.formPanel);
        }
    }

    private void addSubmitHandler() {
        if (submitHandler == null) {
            this.formPanel.addSubmitHandler(new FormPanel.SubmitHandler(){

                public void onSubmit(FormPanel.SubmitEvent event) {
                }
            });
            submitHandler = new FormPanel.SubmitCompleteHandler(){

                public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                    AnalysisImportDialogController.this.handleFormPanelEvent(event);
                }
            };
            this.formPanel.addSubmitCompleteHandler(submitHandler);
        }
    }

    @Bindable
    public void setAnalysisFile() {
        this.jsClickUpload(this.analysisFileUpload.getElement().getId());
    }

    native void jsClickUpload(String var1);

    @Bindable
    public void setSelectedFile(String name) {
        this.schemaNameLabel.setValue(name);
        this.importDialogModel.setUploadedFile(name);
        this.firePropertyChange("selectedFile", null, name);
    }

    public XulDialog getDialog() {
        return this.importDialog;
    }

    public AnalysisImportDialogModel getDialogResult() {
        return this.importDialogModel;
    }

    private void reset() {
        this.analysisFileLabel.setValue(this.resBundle.getString("importDialog.IMPORT_MONDRIAN", "Browse for analysis file"));
        if (this.formPanel != null && RootPanel.get().getWidgetIndex((Widget)this.formPanel) != -1) {
            RootPanel.get().remove((Widget)this.formPanel);
        }
        this.formPanel = null;
        submitHandler = null;
        this.reloadConnections();
        this.importDialogModel.removeAllParameters();
        this.importDialogModel.setUploadedFile(null);
        this.availableRadio.setSelected(true);
        this.acceptButton.setDisabled(true);
        this.schemaNameLabel.setValue("");
        this.setPreference(DATASOURCE_MODE);
        this.overwrite = false;
        this.removeHiddenPanels();
    }

    @Override
    public void removeHiddenPanels() {
        List<Widget> hiddenPanels = this.findHiddenPanels();
        for (Widget hiddenPanel : hiddenPanels) {
            this.mainFormPanel.remove(hiddenPanel);
        }
    }

    private List<Widget> findHiddenPanels() {
        ArrayList<Widget> hiddenPanels = new ArrayList<Widget>();
        if (this.mainFormPanel != null) {
            int widgetCount = this.mainFormPanel.getWidgetCount();
            for (int i = 0; i < widgetCount; ++i) {
                if (!this.mainFormPanel.getWidget(i).getClass().equals(Hidden.class)) continue;
                hiddenPanels.add(this.mainFormPanel.getWidget(i));
            }
        }
        return hiddenPanels;
    }

    private void reloadConnections() {
        String cacheBuster = "?ts=" + new Date().getTime();
        RequestBuilder listConnectionBuilder = new RequestBuilder(RequestBuilder.GET, AnalysisImportDialogController.getBaseURL() + "list" + cacheBuster);
        listConnectionBuilder.setHeader("Content-Type", "application/json");
        listConnectionBuilder.setHeader("If-Modified-Since", "01 Jan 1970 00:00:00 GMT");
        try {
            listConnectionBuilder.sendRequest(null, new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    exception.printStackTrace();
                    MessageHandler.getInstance().showErrorDialog(exception.getMessage());
                }

                public void onResponseReceived(Request request, Response response) {
                    AutoBean bean = AutoBeanCodex.decode((AutoBeanFactory)AnalysisImportDialogController.this.connectionAutoBeanFactory, IDatabaseConnectionList.class, (String)response.getText());
                    List databaseConnections = ((IDatabaseConnectionList)bean.as()).getDatabaseConnections();
                    ArrayList<IDatabaseConnection> standardDatabaseConnections = new ArrayList<IDatabaseConnection>();
                    for (IDatabaseConnection databaseConnection : databaseConnections) {
                        if (databaseConnection.getAttributes() != null && databaseConnection.getAttributes().get(AnalysisImportDialogController.ATTRIBUTE_STANDARD_CONNECTION) != null && databaseConnection.getAttributes().get(AnalysisImportDialogController.ATTRIBUTE_STANDARD_CONNECTION) != Boolean.TRUE.toString()) continue;
                        standardDatabaseConnections.add(databaseConnection);
                    }
                    AnalysisImportDialogController.this.importDialogModel.setConnectionList(standardDatabaseConnections);
                }
            });
        }
        catch (RequestException e) {
            MessageHandler.getInstance().showErrorDialog(MessageHandler.getString("ERROR"), "DatasourceEditor.ERROR_0004_CONNECTION_SERVICE_NULL");
        }
    }

    @Override
    public boolean isValid() {
        return this.importDialogModel.isValid();
    }

    public void handleFormPanelEvent(FormPanel.SubmitCompleteEvent event) {
        if (event.getResults().contains("SUCCESS") || event.getResults().contains(SUCCESS)) {
            this.showMessagebox(this.messages.getString("Mondrian.SUCCESS"), "Mondrian Analysis File " + this.importDialogModel.getUploadedFile() + " has been uploaded");
            this.overwrite = false;
        } else {
            String message = event.getResults();
            if (message != null && !"".equals(message) && message.length() == 1) {
                int code = new Integer(message);
                if (!this.overwrite) {
                    this.overwriteFileDialog(code);
                } else {
                    this.showMessagebox(this.messages.getString("Mondrian.ERROR"), this.convertToNLSMessage(event.getResults(), this.importDialogModel.getUploadedFile()));
                }
            } else {
                this.showMessagebox(this.messages.getString("Mondrian.SERVER_ERROR"), this.convertToNLSMessage(event.getResults(), this.importDialogModel.getUploadedFile()));
            }
        }
    }

    public String convertToNLSMessage(String results, String fileName) {
        String msg = results;
        int code = new Integer(results);
        switch (code) {
            case 1: {
                msg = this.messages.getString("Mondrian.ERROR_OO1_PUBLISH");
                break;
            }
            case 2: {
                msg = this.messages.getString("Mondrian.ERROR_OO2_PUBLISH");
                break;
            }
            case 5: {
                msg = this.messages.getString("Mondrian.ERROR_OO5_USERNAME_PW");
                break;
            }
            case 6: {
                msg = this.messages.getString("Mondrian.ERROR_OO6_Existing_Datasource");
                break;
            }
            case 7: {
                msg = this.messages.getString("Mondrian.OVERWRITE_EXISTING_CATALOG");
                break;
            }
            case 8: {
                msg = this.messages.getString("Mondrian.OVERWRITE_EXISTING_SCHEMA");
                break;
            }
            default: {
                msg = this.messages.getString("Mondrian.General Error", results);
            }
        }
        return msg + " Mondrian File: " + fileName;
    }

    @Override
    public void buildAndSetParameters() {
        this.buildAndSetParameters(false);
    }

    public void buildAndSetParameters(boolean isEditMode) {
        if (isEditMode) {
            String file = this.importDialogModel.getUploadedFile();
            if (file != null) {
                this.mainFormPanel.add((Widget)new Hidden("catalogName", file));
            }
            if (this.datasourceInfo != null) {
                this.mainFormPanel.add((Widget)new Hidden("origCatalogName", this.datasourceInfo.getId()));
            }
        }
        String parameters = this.importDialogModel.getParameters();
        if (this.availableRadio.isSelected()) {
            parameters = "Datasource=" + this.connectionList.getValue();
        }
        String sep = StringUtils.isEmpty((String)parameters) ? "" : ";";
        parameters = parameters + ";overwrite=" + String.valueOf(isEditMode ? isEditMode : this.overwrite);
        Hidden queryParameters = new Hidden("parameters", parameters);
        this.mainFormPanel.add((Widget)queryParameters);
    }

    @Override
    public void concreteUploadCallback(String fileName, String uploadedFile) {
        this.acceptButton.setDisabled(!this.isValid());
    }

    @Override
    public void genericUploadCallback(String uploadedFile) {
        this.importDialogModel.setUploadedFile(uploadedFile);
        this.acceptButton.setDisabled(!this.isValid());
    }

    @Bindable
    public void setPreference(Integer preference) {
        this.analysisPreferencesDeck.setSelectedIndex(preference.intValue());
        this.importDialogModel.setParameterMode(preference == PARAMETER_MODE);
        this.acceptButton.setDisabled(!this.isValid());
    }

    @Bindable
    public void removeParameter() {
        int[] selectedRows = this.analysisParametersTree.getSelectedRows();
        if (selectedRows.length == 1) {
            this.importDialogModel.removeParameter(selectedRows[0]);
            this.acceptButton.setDisabled(!this.isValid());
        }
    }

    @Bindable
    public void addParameter() {
        String paramName = this.paramNameTextBox.getValue();
        String paramValue = this.paramValueTextBox.getValue();
        if (!StringUtils.isEmpty((String)paramName) && !StringUtils.isEmpty((String)paramValue)) {
            this.importDialogModel.addParameter(paramName, paramValue);
            this.closeParametersDialog();
            this.acceptButton.setDisabled(!this.isValid());
        }
    }

    @Bindable
    public void closeParametersDialog() {
        this.paramNameTextBox.setValue("");
        this.paramValueTextBox.setValue("");
        this.importDialogModel.setSelectedAnalysisParameter(-1);
        this.analysisParametersTree.clearSelection();
        this.analysisParametersDialog.hide();
    }

    @Bindable
    public void editParameter() {
        int[] selectedRows = this.analysisParametersTree.getSelectedRows();
        if (selectedRows.length == 1) {
            this.importDialogModel.setSelectedAnalysisParameter(selectedRows[0]);
            ParameterDialogModel parameter = this.importDialogModel.getSelectedAnalysisParameter();
            this.paramNameTextBox.setValue(parameter.getName());
            this.paramValueTextBox.setValue(parameter.getValue());
            this.analysisParametersDialog.show();
        }
    }

    @Bindable
    public void overwriteFileDialog(int code) {
        if (code != 7 && code != 8) {
            return;
        }
        String msg = this.messages.getString("Mondrian.OVERWRITE_EXISTING_SCHEMA");
        if (7 == code) {
            msg = this.messages.getString("Mondrian.OVERWRITE_EXISTING_CATALOG");
        }
        XulConfirmBox confirm = null;
        try {
            confirm = (XulConfirmBox)this.document.createElement("confirmbox");
        }
        catch (XulException e) {
            Window.alert((String)e.getMessage());
        }
        confirm.setTitle("Confirmation");
        confirm.setMessage(msg);
        confirm.setAcceptLabel("Ok");
        confirm.setCancelLabel("Cancel");
        confirm.addDialogCallback((XulDialogCallback)new XulDialogCallback<String>(){

            public void onClose(XulComponent component, XulDialogCallback.Status status, String value) {
                if (status == XulDialogCallback.Status.ACCEPT) {
                    AnalysisImportDialogController.this.overwrite = true;
                    AnalysisImportDialogController.this.removeHiddenPanels();
                    AnalysisImportDialogController.this.buildAndSetParameters();
                    AnalysisImportDialogController.this.formPanel.submit();
                }
            }

            public void onError(XulComponent component, Throwable err) {
            }
        });
        confirm.open();
    }

    @Bindable
    public void openParametersDialog() {
        this.analysisParametersDialog.show();
    }

    @Override
    public void showDialog() {
        this.reset();
        this.importDialog.setTitle(this.resBundle.getString("importDialog.IMPORT_MONDRIAN", "Import Analysis"));
        this.analysisFileLabel.setValue(this.resBundle.getString("importDialog.MONDRIAN_FILE", "Mondrian File") + ":");
        super.showDialog();
        this.createWorkingForm();
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    public String getName() {
        return "analysisImportDialogController";
    }

    private void showMessagebox(String title, String message) {
        try {
            XulMessageBox messagebox = (XulMessageBox)this.document.createElement("messagebox");
            messagebox.setTitle(title);
            messagebox.setMessage(message);
            int option = messagebox.open();
        }
        catch (XulException e) {
            Window.alert((String)("Show MessabeBox " + e.getMessage()));
        }
    }

    public void setDatasourceMessages(DatasourceMessages datasourceMessages) {
        this.messages = datasourceMessages;
    }

    public FormPanel getFormPanel() {
        return this.formPanel;
    }

    public String getFileName() {
        return this.importDialogModel.getUploadedFile();
    }

    @Override
    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    protected boolean handleParam(StringBuilder name, StringBuilder value) {
        if (name.length() == 0 && value.length() == 0) {
            return false;
        }
        boolean hasParameters = false;
        boolean connectionFound = false;
        String paramName = name.toString();
        String paramValue = value.toString();
        if (paramName.equalsIgnoreCase("Datasource")) {
            for (IDatabaseConnection connection : this.importDialogModel.getConnectionList()) {
                if (!connection.getName().equals(paramValue)) continue;
                this.importDialogModel.setConnection(connection);
                connectionFound = true;
            }
            this.importDialogModel.addParameter(paramName, paramValue);
            hasParameters = !connectionFound;
        } else if (!paramName.equalsIgnoreCase("overwrite") && !paramName.equalsIgnoreCase("Provider")) {
            this.importDialogModel.addParameter(paramName, paramValue);
            hasParameters = !paramName.equalsIgnoreCase("EnableXmla") || !paramValue.equalsIgnoreCase("true");
        }
        name.setLength(0);
        value.setLength(0);
        return hasParameters;
    }

    public void editDatasource(final IDatasourceInfo datasourceInfo) {
        this.datasourceInfo = datasourceInfo;
        boolean isEditMode = datasourceInfo != null;
        this.acceptButton.setLabel(isEditMode ? this.resBundle.getString("importDialog.SAVE") : this.resBundle.getString("importDialog.IMPORT"));
        if (!isEditMode) {
            return;
        }
        String url = GWT.getModuleBaseURL();
        int indexOfContent = url.indexOf("content");
        if (indexOfContent > -1) {
            url = url.substring(0, indexOfContent);
            url = url + "plugin/data-access/api/datasource/" + NameUtils.URLEncode((String)datasourceInfo.getId()) + "/getAnalysisDatasourceInfo";
        }
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url);
        requestBuilder.setHeader("If-Modified-Since", "01 Jan 1970 00:00:00 GMT");
        try {
            requestBuilder.sendRequest(null, new RequestCallback(){

                public void onError(Request request, Throwable e) {
                    logger.log(Level.ALL, e.getMessage());
                }

                public void onResponseReceived(Request request, Response response) {
                    XulRadio radio;
                    int preference;
                    boolean paramHandled;
                    boolean hasParameters = false;
                    String responseValue = response.getText();
                    StringBuilder name = new StringBuilder();
                    StringBuilder value = new StringBuilder();
                    int state = 0;
                    int len = responseValue.length();
                    block23: for (int i = 0; i < len; ++i) {
                        char ch = responseValue.charAt(i);
                        switch (state) {
                            case 0: {
                                paramHandled = AnalysisImportDialogController.this.handleParam(name, value);
                                if (!hasParameters) {
                                    hasParameters = paramHandled;
                                }
                                switch (ch) {
                                    case ';': {
                                        continue block23;
                                    }
                                }
                                state = 1;
                                name.append(ch);
                                continue block23;
                            }
                            case 1: {
                                switch (ch) {
                                    case '=': {
                                        state = 2;
                                        continue block23;
                                    }
                                }
                                name.append(ch);
                                continue block23;
                            }
                            case 2: {
                                switch (ch) {
                                    case '\"': {
                                        state = 3;
                                        continue block23;
                                    }
                                    case ';': {
                                        state = 0;
                                        continue block23;
                                    }
                                }
                                value.append(ch);
                                state = 4;
                                continue block23;
                            }
                            case 3: {
                                switch (ch) {
                                    case '\"': {
                                        state = 0;
                                        continue block23;
                                    }
                                }
                                value.append(ch);
                                continue block23;
                            }
                            case 4: {
                                switch (ch) {
                                    case ';': {
                                        state = 0;
                                        continue block23;
                                    }
                                }
                                value.append(ch);
                                continue block23;
                            }
                        }
                    }
                    paramHandled = AnalysisImportDialogController.this.handleParam(name, value);
                    if (!hasParameters) {
                        hasParameters = paramHandled;
                    }
                    AnalysisImportDialogController.this.schemaNameLabel.setValue(datasourceInfo.getId() + ".mondrian.xml");
                    AnalysisImportDialogController.this.importDialogModel.setUploadedFile(datasourceInfo.getId());
                    if (hasParameters) {
                        preference = PARAMETER_MODE;
                        radio = AnalysisImportDialogController.this.manualRadio;
                    } else {
                        preference = DATASOURCE_MODE;
                        radio = AnalysisImportDialogController.this.availableRadio;
                    }
                    AnalysisImportDialogController.this.setPreference(preference);
                    radio.setSelected(true);
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.ALL, e.getMessage());
        }
    }

    class ParametersChangeListener
    implements PropertyChangeListener {
        ParametersChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean isDisabled = StringUtils.isEmpty((String)AnalysisImportDialogController.this.paramNameTextBox.getValue()) || StringUtils.isEmpty((String)AnalysisImportDialogController.this.paramValueTextBox.getValue());
            AnalysisImportDialogController.this.parametersAcceptButton.setDisabled(isDisabled);
        }
    }

    class PreferencesBindingConvertor
    extends BindingConvertor<Boolean, Integer> {
        PreferencesBindingConvertor() {
        }

        public Integer sourceToTarget(Boolean value) {
            int result = 0;
            if (value.booleanValue()) {
                result = 1;
            }
            return result;
        }

        public Boolean targetToSource(Integer value) {
            return true;
        }
    }
}

