/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.ui.importing;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pentaho.gwt.widgets.client.utils.NameUtils;
import org.pentaho.gwt.widgets.client.utils.i18n.ResourceBundle;
import org.pentaho.platform.dataaccess.datasource.ui.importing.IImportPerspective;
import org.pentaho.platform.dataaccess.datasource.ui.importing.IOverwritableController;
import org.pentaho.platform.dataaccess.datasource.ui.importing.MetadataImportDialogModel;
import org.pentaho.platform.dataaccess.datasource.wizard.DatasourceMessages;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulConfirmBox;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractXulDialogController;
import org.pentaho.ui.xul.util.XulDialogCallback;

public class MetadataImportDialogController
extends AbstractXulDialogController<MetadataImportDialogModel>
implements IImportPerspective,
IOverwritableController {
    private static final String METADATA_IMPORT_URL = "plugin/data-access/api/metadata/postimport";
    private static Integer FILE_UPLOAD_SUFFIX = 0;
    private BindingFactory bf;
    private XulButton acceptButton;
    private XulTree localizedBundlesTree;
    private XulTextbox domainIdText;
    private XulLabel metaFileLocation;
    private XulDialog importDialog;
    private ResourceBundle resBundle;
    private MetadataImportDialogModel importDialogModel;
    private XulLabel fileLabel;
    private FlowPanel mainFormPanel;
    private FlowPanel propertiesFileImportPanel;
    private XulVbox hiddenArea;
    private DatasourceMessages messages = null;
    private boolean overwrite;
    private static FormPanel.SubmitCompleteHandler submitHandler = null;
    private FormPanel formPanel;
    private FileUpload metadataFileUpload;
    private TextBox formDomainIdText;
    protected static final int OVERWRITE_EXISTING_SCHEMA = 8;

    public void init() {
        try {
            this.resBundle = (ResourceBundle)super.getXulDomContainer().getResourceBundles().get(0);
            this.importDialogModel = new MetadataImportDialogModel();
            this.localizedBundlesTree = (XulTree)this.document.getElementById("localizedBundlesTree");
            this.domainIdText = (XulTextbox)this.document.getElementById("domainIdText");
            this.domainIdText.addPropertyChangeListener((PropertyChangeListener)new DomainIdChangeListener());
            this.importDialog = (XulDialog)this.document.getElementById("importDialog");
            this.fileLabel = (XulLabel)this.document.getElementById("fileLabel");
            this.metaFileLocation = (XulLabel)this.document.getElementById("uploadFileLabel");
            this.acceptButton = (XulButton)this.document.getElementById("importDialog_accept");
            this.hiddenArea = (XulVbox)this.document.getElementById("metadataImportCard");
            this.acceptButton.setDisabled(true);
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            Binding localizedBundlesBinding = this.bf.createBinding((Object)this.importDialogModel, "localizedBundles", (Object)this.localizedBundlesTree, "elements", new BindingConvertor[0]);
            localizedBundlesBinding.fireSourceChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createWorkingForm() {
        if (this.formPanel == null) {
            this.formPanel = new FormPanel();
            this.formPanel.setMethod("post");
            this.formPanel.setEncoding("multipart/form-data");
            this.formPanel.setAction(METADATA_IMPORT_URL);
            this.formPanel.getElement().getStyle().setProperty("position", "absolute");
            this.formPanel.getElement().getStyle().setProperty("visibility", "hidden");
            this.formPanel.getElement().getStyle().setProperty("overflow", "hidden");
            this.formPanel.getElement().getStyle().setProperty("clip", "rect(0px,0px,0px,0px)");
            this.mainFormPanel = new FlowPanel();
            this.formPanel.add((Widget)this.mainFormPanel);
            this.propertiesFileImportPanel = new FlowPanel();
            this.mainFormPanel.add((Widget)this.propertiesFileImportPanel);
            this.formDomainIdText = new TextBox();
            this.formDomainIdText.setName("domainId");
            this.mainFormPanel.add((Widget)this.formDomainIdText);
            this.metadataFileUpload = new FileUpload();
            this.metadataFileUpload.setName("metadataFile");
            this.metadataFileUpload.getElement().setId("metaFileUpload");
            this.metadataFileUpload.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    String filename = ((FileUpload)event.getSource()).getFilename();
                    if (filename != null && filename.trim().length() > 0) {
                        MetadataImportDialogController.this.metaFileLocation.setValue(filename);
                        MetadataImportDialogController.this.importDialogModel.setUploadedFile(filename);
                        MetadataImportDialogController.this.acceptButton.setDisabled(!MetadataImportDialogController.this.isValid());
                    } else {
                        MetadataImportDialogController.this.metaFileLocation.setValue(MetadataImportDialogController.this.resBundle.getString("importDialog.SELECT_METAFILE_LABEL", "browse for metadata file"));
                        MetadataImportDialogController.this.importDialogModel.setUploadedFile(null);
                        MetadataImportDialogController.this.acceptButton.setDisabled(!MetadataImportDialogController.this.isValid());
                    }
                }
            });
            this.mainFormPanel.add((Widget)this.metadataFileUpload);
            VerticalPanel vp = (VerticalPanel)this.hiddenArea.getManagedObject();
            vp.add((Widget)this.formPanel);
        }
    }

    public XulDialog getDialog() {
        return this.importDialog;
    }

    public MetadataImportDialogModel getDialogResult() {
        return this.importDialogModel;
    }

    @Override
    public boolean isValid() {
        return this.importDialogModel.isValid();
    }

    @Bindable
    public void setMetadataFile() {
        this.jsClickUpload(this.metadataFileUpload.getElement().getId());
    }

    @Bindable
    public void removeLocalizedBundle() {
        int[] selectedRows = this.localizedBundlesTree.getSelectedRows();
        if (selectedRows.length == 1) {
            this.propertiesFileImportPanel.remove(selectedRows[0]);
            this.importDialogModel.removeLocalizedBundle(selectedRows[0]);
        }
    }

    @Bindable
    public void addLocalizedBundle() {
        final FileUpload localizedBundleUpload = new FileUpload();
        localizedBundleUpload.setName("localeFiles");
        Integer n = FILE_UPLOAD_SUFFIX;
        Integer n2 = FILE_UPLOAD_SUFFIX = Integer.valueOf(FILE_UPLOAD_SUFFIX + 1);
        localizedBundleUpload.getElement().setId("propertyFileUpload" + n);
        localizedBundleUpload.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String fileName = ((FileUpload)event.getSource()).getFilename();
                if (fileName == null || fileName.length() < 1) {
                    MetadataImportDialogController.this.propertiesFileImportPanel.remove((Widget)localizedBundleUpload);
                } else {
                    MetadataImportDialogController.this.importDialogModel.addLocalizedBundle(fileName, fileName);
                }
            }
        });
        this.propertiesFileImportPanel.add((Widget)localizedBundleUpload);
        this.jsClickUpload(localizedBundleUpload.getElement().getId());
    }

    native void jsClickUpload(String var1);

    private void reset() {
        this.metaFileLocation.setValue(this.resBundle.getString("importDialog.SELECT_METAFILE_LABEL", "browse for metadata file"));
        this.importDialogModel.removeAllLocalizedBundles();
        this.importDialogModel.setUploadedFile(null);
        if (this.formPanel != null && RootPanel.get().getWidgetIndex((Widget)this.formPanel) != -1) {
            RootPanel.get().remove((Widget)this.formPanel);
        }
        this.acceptButton.setDisabled(true);
        this.domainIdText.setValue("");
        this.overwrite = false;
        this.formPanel = null;
        this.removeHiddenPanels();
    }

    @Override
    public void concreteUploadCallback(String fileName, String uploadedFile) {
        this.importDialogModel.addLocalizedBundle(fileName, uploadedFile);
    }

    @Override
    public void genericUploadCallback(String uploadedFile) {
        this.importDialogModel.setUploadedFile(uploadedFile);
        this.acceptButton.setDisabled(!this.isValid());
    }

    @Override
    public void showDialog() {
        this.reset();
        this.importDialog.setTitle(this.resBundle.getString("importDialog.IMPORT_METADATA", "Import Metadata"));
        this.fileLabel.setValue(this.resBundle.getString("importDialog.XMI_FILE", "XMI File") + ":");
        super.showDialog();
        this.createWorkingForm();
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    public String getName() {
        return "metadataImportDialogController";
    }

    public FormPanel getFormPanel() {
        return this.formPanel;
    }

    @Override
    public void buildAndSetParameters() {
        Hidden overwriteParam = new Hidden("overwrite", String.valueOf(this.overwrite));
        this.mainFormPanel.add((Widget)overwriteParam);
    }

    @Override
    public void removeHiddenPanels() {
        for (int i = 0; this.mainFormPanel != null && i < this.mainFormPanel.getWidgetCount(); ++i) {
            if (!this.mainFormPanel.getWidget(i).getClass().equals(Hidden.class)) continue;
            this.mainFormPanel.remove(this.mainFormPanel.getWidget(i));
        }
    }

    public String convertToNLSMessage(String results, String fileName) {
        String messageId;
        String msg = results;
        int code = new Integer(results);
        String[] parameters = new String[]{};
        switch (code) {
            case 1: {
                messageId = "Metadata.PUBLISH_TO_SERVER_FAILED";
                break;
            }
            case 2: {
                messageId = "Metadata.PUBLISH_GENERAL_ERROR";
                break;
            }
            case 3: {
                messageId = "Metadata.PUBLISH_DATASOURCE_ERROR";
                break;
            }
            case 4: {
                messageId = "Metadata.PUBLISH_USERNAME_PASSWORD_FAIL";
                break;
            }
            case 7: {
                messageId = "Metadata.PUBLISH_XMLA_CATALOG_EXISTS";
                break;
            }
            case 8: {
                messageId = "Metadata.OVERWRITE_EXISTING_SCHEMA";
                break;
            }
            case 10: {
                messageId = "Metadata.PUBLISH_PROHIBITED_SYMBOLS_ERROR";
                parameters = new String[]{NameUtils.reservedCharListForDisplay((String)", ")};
                break;
            }
            default: {
                messageId = "Metadata.ERROR";
            }
        }
        msg = this.messages.getString(messageId, parameters);
        return msg + " Metadata File: " + fileName;
    }

    public void handleFormPanelEvent(FormPanel.SubmitCompleteEvent event) {
        if (event.getResults().contains("SUCCESS") || event.getResults().contains("3")) {
            this.showMessagebox(this.messages.getString("Metadata.SUCCESS"), "Metadata File " + this.importDialogModel.getUploadedFile() + " has been uploaded");
        } else {
            String message = event.getResults();
            if (message != null && !"".equals(message) && message.length() == 1) {
                int code = new Integer(message);
                if (code == 8 && !this.overwrite) {
                    this.overwriteFileDialog();
                } else {
                    this.showMessagebox(this.messages.getString("Metadata.ERROR"), this.convertToNLSMessage(event.getResults(), this.importDialogModel.getUploadedFile()));
                }
            } else {
                this.showMessagebox(this.messages.getString("Metadata.SERVER_ERROR"), this.convertToNLSMessage(event.getResults(), this.importDialogModel.getUploadedFile()));
            }
        }
    }

    @Bindable
    public void overwriteFileDialog() {
        XulConfirmBox confirm = null;
        try {
            confirm = (XulConfirmBox)this.document.createElement("confirmbox");
        }
        catch (XulException e) {
            Window.alert((String)e.getMessage());
        }
        confirm.setTitle("Confirmation");
        confirm.setMessage(this.messages.getString("Metadata.OVERWRITE_EXISTING_SCHEMA"));
        confirm.setAcceptLabel("Ok");
        confirm.setCancelLabel("Cancel");
        confirm.addDialogCallback((XulDialogCallback)new XulDialogCallback<String>(){

            public void onClose(XulComponent component, XulDialogCallback.Status status, String value) {
                if (status == XulDialogCallback.Status.ACCEPT) {
                    MetadataImportDialogController.this.overwrite = true;
                    MetadataImportDialogController.this.removeHiddenPanels();
                    MetadataImportDialogController.this.buildAndSetParameters();
                    MetadataImportDialogController.this.formPanel.submit();
                }
            }

            public void onError(XulComponent component, Throwable err) {
            }
        });
        confirm.open();
    }

    private void showMessagebox(String title, String message) {
        try {
            XulMessageBox messagebox = (XulMessageBox)this.document.createElement("messagebox");
            messagebox.setTitle(title);
            messagebox.setMessage(message);
        }
        catch (XulException e) {
            Window.alert((String)("Show MessabeBox " + e.getMessage()));
        }
    }

    public void setDatasourceMessages(DatasourceMessages datasourceMessages) {
        this.messages = datasourceMessages;
    }

    public String getFileName() {
        return this.importDialogModel.getUploadedFile();
    }

    @Override
    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    class DomainIdChangeListener
    implements PropertyChangeListener {
        DomainIdChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            MetadataImportDialogController.this.formDomainIdText.setText(evt.getNewValue().toString());
            MetadataImportDialogController.this.importDialogModel.setDomainId(evt.getNewValue().toString());
            MetadataImportDialogController.this.acceptButton.setDisabled(!MetadataImportDialogController.this.isValid());
        }
    }
}

