/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.ui.service;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.platform.dataaccess.datasource.DatasourceInfo;
import org.pentaho.platform.dataaccess.datasource.IDatasourceInfo;
import org.pentaho.platform.dataaccess.datasource.ui.service.IUIDatasourceAdminService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncDatasourceServiceManager;
import org.pentaho.ui.xul.XulServiceCallback;

public class DSWUIDatasourceService
implements IUIDatasourceAdminService {
    private IXulAsyncDatasourceServiceManager datasourceService;
    public static final String EXT = ".xmi";
    public static final String TYPE = "Data Source Wizard";
    private boolean editable = true;
    private boolean removable = true;
    private boolean importable = false;
    private boolean exportable = true;
    private boolean creatable = true;
    private String newUI = "builtin:";
    private String editUI = "builtin:";

    @Override
    public String getType() {
        return TYPE;
    }

    public DSWUIDatasourceService(IXulAsyncDatasourceServiceManager datasourceService) {
        this.datasourceService = datasourceService;
    }

    @Override
    public void getIds(final XulServiceCallback<List<IDatasourceInfo>> callback) {
        this.datasourceService.getDSWDatasourceIds(new XulServiceCallback<List<String>>(){

            public void success(List<String> ids) {
                ArrayList<DatasourceInfo> datasourceInfos = new ArrayList<DatasourceInfo>();
                for (String id : ids) {
                    String name = null;
                    if (id == null || id.length() <= 0) continue;
                    int index = id.indexOf(DSWUIDatasourceService.EXT);
                    name = index >= 0 ? id.substring(0, index) : id;
                    datasourceInfos.add(new DatasourceInfo(name, id, DSWUIDatasourceService.TYPE, DSWUIDatasourceService.this.editable, DSWUIDatasourceService.this.removable, DSWUIDatasourceService.this.importable, DSWUIDatasourceService.this.exportable));
                }
                callback.success(datasourceInfos);
            }

            public void error(String message, Throwable error) {
                callback.error(message, error);
            }
        });
    }

    @Override
    public String getNewUI() {
        return this.newUI;
    }

    @Override
    public String getEditUI(IDatasourceInfo dsInfo) {
        return this.editUI;
    }

    @Override
    public void export(IDatasourceInfo dsInfo) {
        this.datasourceService.export(dsInfo);
    }

    @Override
    public void remove(IDatasourceInfo dsInfo, Object callback) {
        this.datasourceService.remove(dsInfo, callback);
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean isRemovable() {
        return this.removable;
    }

    @Override
    public boolean isImportable() {
        return this.importable;
    }

    @Override
    public boolean isExportable() {
        return this.exportable;
    }

    @Override
    public boolean isCreatable() {
        return this.creatable;
    }
}

