/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.gwt.widgets.client.utils.NameUtils;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.platform.dataaccess.datasource.IDatasourceInfo;
import org.pentaho.platform.dataaccess.datasource.ui.service.UIDatasourceServiceManager;
import org.pentaho.platform.dataaccess.datasource.utils.ExceptionParser;
import org.pentaho.platform.dataaccess.datasource.wizard.IDatasourceSummary;
import org.pentaho.platform.dataaccess.datasource.wizard.IWizardController;
import org.pentaho.platform.dataaccess.datasource.wizard.IWizardDatasource;
import org.pentaho.platform.dataaccess.datasource.wizard.IWizardListener;
import org.pentaho.platform.dataaccess.datasource.wizard.IWizardStep;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IWizardModel;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncDSWDatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.dummy.DummyDatasource;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.dummy.SelectDatasourceStep;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class MainWizardController
extends AbstractXulEventHandler
implements IWizardController {
    private IWizardModel wizardModel;
    private IXulAsyncDSWDatasourceService datasourceService;
    private XulTextbox datasourceName;
    private IWizardDatasource activeDatasource;
    public static final String DEFAULT_INVALID_CHARACTERS = "$<>?&#%^*()!~:;[]{}|/";
    private static final String DISABLED_PROPERTY_NAME = "disabled";
    private static final String VALID_PROPERTY_NAME = "valid";
    private static final String NEXT_BTN_ELEMENT_ID = "main_wizard_window_extra2";
    private static final String BACK_BTN_ELEMENT_ID = "main_wizard_window_extra1";
    private static final String FINISH_BTN_ELEMENT_ID = "main_wizard_window_accept";
    private static final String CONTENT_DECK_ELEMENT_ID = "content_deck";
    private ArrayList<IWizardStep> steps;
    private int activeStep = -1;
    private BindingFactory bf;
    private XulDialog warningDialog;
    private Binding nextButtonBinding;
    private Binding finishedButtonBinding;
    private NotDisabledBindingConvertor notDisabledBindingConvertor;
    private List<IWizardListener> wizardListeners = new ArrayList<IWizardListener>();
    private XulDialog wizardDialog;
    private XulDialog summaryDialog;
    private XulMenuList datatypeMenuList;
    private XulButton finishButton;
    private DummyDatasource dummyDatasource = new DummyDatasource();
    private SelectDatasourceStep selectDatasourceStep;

    public MainWizardController(BindingFactory bf, IWizardModel wizardModel, IXulAsyncDSWDatasourceService datasourceService) {
        this.wizardModel = wizardModel;
        this.datasourceService = datasourceService;
        this.steps = new ArrayList();
        this.bf = bf;
        this.notDisabledBindingConvertor = new NotDisabledBindingConvertor();
    }

    @Override
    public IWizardStep getStep(int step) {
        return this.steps.get(step);
    }

    @Override
    public int getStepCount() {
        return this.steps.size();
    }

    @Override
    public void setActiveStep(int step) {
        try {
            if (this.steps == null || this.steps.isEmpty()) {
                return;
            }
            int oldActiveStep = this.activeStep;
            if (oldActiveStep >= 0) {
                IWizardStep deactivatingWizardStep = this.steps.get(oldActiveStep);
                if (step > oldActiveStep ? !deactivatingWizardStep.stepDeactivatingForward() : !deactivatingWizardStep.stepDeactivatingReverse()) {
                    return;
                }
            }
            this.activeStep = step;
            IWizardStep activatingWizardStep = this.steps.get(this.activeStep);
            this.updateBindings();
            XulDeck deck = (XulDeck)this.document.getElementById(CONTENT_DECK_ELEMENT_ID);
            int index = deck.getChildNodes().indexOf(activatingWizardStep.getUIComponent());
            deck.setSelectedIndex(index);
            this.selectDataSourceMenuList(activatingWizardStep, index);
            activatingWizardStep.refresh();
            if (this.activeStep > oldActiveStep) {
                activatingWizardStep.stepActivatingForward();
            } else {
                activatingWizardStep.stepActivatingReverse();
            }
            this.firePropertyChange("activeStep", oldActiveStep, this.activeStep);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void selectDataSourceMenuList(IWizardStep activatingWizardStep, int index) {
        if (this.datatypeMenuList.getElements().size() > 0 && index != -1 && this.activeDatasource != null) {
            if (this.activeDatasource.getId().equals("NONE")) {
                this.datatypeMenuList.setSelectedIndex(0);
            } else if (this.activeDatasource.getId().equals("CSV")) {
                this.datatypeMenuList.setSelectedIndex(1);
            } else if (this.activeDatasource.getId().equals("MULTI-TABLE-DS")) {
                this.datatypeMenuList.setSelectedIndex(3);
            } else if (this.activeDatasource.getId().equals("SQL-DS")) {
                this.datatypeMenuList.setSelectedIndex(2);
            }
        }
    }

    @Override
    public int getActiveStep() {
        return this.activeStep;
    }

    @Override
    public void init() {
        this.wizardDialog = (XulDialog)this.document.getElementById("main_wizard_window");
        this.summaryDialog = (XulDialog)this.document.getElementById("summaryDialog");
        this.finishButton = (XulButton)this.document.getElementById(FINISH_BTN_ELEMENT_ID);
        this.datasourceName = (XulTextbox)this.document.getElementById("datasourceName");
        this.bf.createBinding((Object)this.datasourceName, "value", (Object)this.wizardModel, "datasourceName", new BindingConvertor[0]);
        this.wizardModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("datasourceName")) {
                    ((IWizardStep)MainWizardController.this.steps.get(MainWizardController.this.activeStep)).setValid(((IWizardStep)MainWizardController.this.steps.get(MainWizardController.this.activeStep)).isValid());
                }
            }
        });
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.datatypeMenuList = (XulMenuList)this.document.getElementById("datatypeMenuList");
        Binding datasourceBinding = this.bf.createBinding((Object)this.wizardModel, "datasources", (Object)this.datatypeMenuList, "elements", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.datatypeMenuList, "selectedItem", (Object)this.wizardModel, "selectedDatasource", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.wizardModel, "selectedDatasource", (Object)this, "selectedDatasource", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "activeStep", BACK_BTN_ELEMENT_ID, DISABLED_PROPERTY_NAME, new BindingConvertor[]{new BackButtonBindingConverter()});
        this.dummyDatasource = (DummyDatasource)this.wizardModel.getDatasources().iterator().next();
        this.activeDatasource = this.dummyDatasource;
        this.selectDatasourceStep = this.dummyDatasource.getSelectDatasourceStep();
        try {
            for (IWizardDatasource datasource : this.wizardModel.getDatasources()) {
                datasource.init(this.getXulDomContainer(), this.wizardModel);
            }
            this.steps.add(this.selectDatasourceStep);
            this.selectDatasourceStep.activating();
            this.setActiveStep(0);
            datasourceBinding.fireSourceChanged();
            this.setSelectedDatasource(this.dummyDatasource);
            this.datasourceService.getDatasourceIllegalCharacters(new XulServiceCallback<String>(){

                public void success(String retVal) {
                }

                public void error(String message, Throwable error) {
                }
            });
        }
        catch (XulException e) {
            MessageHandler.getInstance().showErrorDialog("Error", e.getMessage());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            MessageHandler.getInstance().showErrorDialog("Error", e.getMessage());
            e.printStackTrace();
        }
    }

    public void resetSelectedDatasource() {
        this.datatypeMenuList.setSelectedIndex(0);
    }

    @Bindable
    public void setSelectedDatasource(IWizardDatasource datasource) {
        IWizardDatasource prevSelection = this.activeDatasource;
        this.activeDatasource = datasource;
        if (datasource == null || prevSelection == this.activeDatasource) {
            return;
        }
        try {
            datasource.activating();
            if (prevSelection != null) {
                this.steps.removeAll(prevSelection.getSteps());
                prevSelection.deactivating();
            }
            for (int i = 1; i < datasource.getSteps().size(); ++i) {
                this.steps.add(datasource.getSteps().get(i));
            }
            this.steps.addAll(datasource.getSteps());
            this.wizardModel.setSelectedDatasource(datasource);
            this.activeStep = 0;
            this.updateBindings();
        }
        catch (XulException e) {
            e.printStackTrace();
        }
    }

    public void reset() {
        this.setActiveStep(0);
    }

    protected void updateBindings() {
        if (this.nextButtonBinding != null) {
            this.nextButtonBinding.destroyBindings();
        }
        if (this.finishedButtonBinding != null) {
            this.finishedButtonBinding.destroyBindings();
        }
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.nextButtonBinding = this.bf.createBinding((Object)this.getStep(this.getActiveStep()), VALID_PROPERTY_NAME, NEXT_BTN_ELEMENT_ID, DISABLED_PROPERTY_NAME, new BindingConvertor[]{this.notDisabledBindingConvertor});
        this.finishedButtonBinding = this.bf.createBinding((Object)this.activeDatasource, "finishable", FINISH_BTN_ELEMENT_ID, DISABLED_PROPERTY_NAME, new BindingConvertor[]{this.notDisabledBindingConvertor});
        try {
            this.nextButtonBinding.fireSourceChanged();
            this.finishedButtonBinding.fireSourceChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @Bindable
    public void cancel() {
        this.setCancelled();
    }

    private void setCancelled() {
        for (IWizardListener wizardListener : this.wizardListeners) {
            wizardListener.onCancel();
        }
    }

    @Override
    @Bindable
    public void finish() {
        if (this.finishButton.isDisabled()) {
            return;
        }
        this.finishButton.setDisabled(true);
        final String datasourceName = this.wizardModel.getDatasourceName();
        if (this.isDatasourceNameValid(datasourceName)) {
            UIDatasourceServiceManager manager = UIDatasourceServiceManager.getInstance();
            manager.getIds(new XulServiceCallback<List<IDatasourceInfo>>(){

                public void success(List<IDatasourceInfo> datasourceInfos) {
                    MainWizardController.this.finishButton.setDisabled(false);
                    boolean isEditing = MainWizardController.this.wizardModel.isEditing();
                    ArrayList<String> datasourceNames = new ArrayList<String>();
                    for (IDatasourceInfo datasourceInfo : datasourceInfos) {
                        if (!datasourceInfo.getType().equals("Data Source Wizard") && !datasourceInfo.getType().equals("Analysis")) continue;
                        datasourceNames.add(datasourceInfo.getName());
                    }
                    if (datasourceNames.contains(datasourceName) && !isEditing) {
                        MainWizardController.this.showWarningDialog();
                    } else {
                        MainWizardController.this.setFinished();
                    }
                }

                public void error(String s, Throwable throwable) {
                    MainWizardController.this.finishButton.setDisabled(false);
                    throwable.printStackTrace();
                    MessageHandler.getInstance().showErrorDialog(throwable.getMessage());
                }
            });
        } else {
            this.finishButton.setDisabled(false);
            MessageHandler.getInstance().showErrorDialog("Error", MessageHandler.getString("DatasourceEditor.ERROR_0005_INVALID_DATASOURCE_NAME", NameUtils.reservedCharListForDisplay((String)" ")), true);
        }
    }

    @Bindable
    public void overwriteDialogAccept() {
        this.warningDialog.hide();
        this.setFinished();
    }

    @Bindable
    public void overwriteDialogCancel() {
        this.warningDialog.hide();
    }

    private void setFinished() {
        this.wizardDialog.hide();
        MessageHandler.getInstance().showWaitingDialog();
        this.activeDatasource.onFinish(new XulServiceCallback<IDatasourceSummary>(){

            public void success(IDatasourceSummary iDatasourceSummary) {
                ((LogicalModel)iDatasourceSummary.getDomain().getLogicalModels().get(0)).setProperty("DatasourceType", (Object)MainWizardController.this.activeDatasource.getId());
                for (IWizardListener wizardListener : MainWizardController.this.wizardListeners) {
                    wizardListener.onFinish(iDatasourceSummary);
                }
            }

            public void error(String s, Throwable throwable) {
                throwable.printStackTrace();
                MessageHandler.getInstance().closeWaitingDialog();
                MessageHandler.getInstance().showErrorDialog("Error", ExceptionParser.getErrorMessage(throwable, MessageHandler.getString("DatasourceEditor.ERROR_0001_UNKNOWN_ERROR_HAS_OCCURED")), true);
            }
        });
    }

    public void showWarningDialog() {
        this.warningDialog = (XulDialog)this.xulDomContainer.getDocumentRoot().getElementById("overwriteDialog");
        this.warningDialog.show();
    }

    @Bindable
    public void next() {
        for (int i = this.getActiveStep(); i < this.steps.size() - 1; ++i) {
            IWizardStep nextStep = this.getStep(i + 1);
            if (nextStep.isDisabled()) continue;
            this.setActiveStep(i + 1);
            break;
        }
    }

    @Bindable
    public void back() {
        for (int i = this.getActiveStep() - 1; i > -1; --i) {
            IWizardStep lastStep = this.getStep(i);
            if (lastStep.isDisabled()) continue;
            this.setActiveStep(i);
            break;
        }
    }

    public String getName() {
        return "wizardController";
    }

    @Override
    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    @Override
    public BindingFactory getBindingFactory() {
        return this.bf;
    }

    public void addWizardListener(IWizardListener listener) {
        this.wizardListeners.add(listener);
    }

    public void removeWizardListener(IWizardListener listener) {
        this.wizardListeners.remove(listener);
    }

    @Bindable
    public void editFieldSettings() {
        this.summaryDialog.hide();
        this.wizardDialog.show();
        this.finishButton.setDisabled(false);
    }

    private boolean isDatasourceNameValid(String datasourceName) {
        return NameUtils.isValidFileName((String)datasourceName);
    }

    private boolean containsNone(String str, String invalidChars) {
        if (str == null || invalidChars == null) {
            return true;
        }
        char[] invalidCharsArray = null;
        int strSize = str.length();
        if (invalidChars != null) {
            invalidCharsArray = invalidChars.toCharArray();
        }
        int validSize = invalidCharsArray.length;
        for (int i = 0; i < strSize; ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < validSize; ++j) {
                if (invalidCharsArray[j] != ch) continue;
                return false;
            }
        }
        return true;
    }

    class NotDisabledBindingConvertor
    extends BindingConvertor<Boolean, Boolean> {
        NotDisabledBindingConvertor() {
        }

        public Boolean sourceToTarget(Boolean value) {
            return value == false;
        }

        public Boolean targetToSource(Boolean value) {
            return value == false;
        }
    }

    protected class BackButtonBindingConverter
    extends BindingConvertor<Integer, Boolean> {
        protected BackButtonBindingConverter() {
        }

        public Boolean sourceToTarget(Integer value) {
            return value <= 0;
        }

        public Integer targetToSource(Boolean value) {
            return null;
        }
    }
}

