/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.controllers;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.util.DatabaseTypeHelper;
import org.pentaho.platform.dataaccess.datasource.beans.AutobeanUtilities;
import org.pentaho.platform.dataaccess.datasource.utils.ExceptionParser;
import org.pentaho.platform.dataaccess.datasource.wizard.ConnectionDialogListener;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.ConnectionController;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceModel;
import org.pentaho.ui.database.event.DatabaseDialogListener;
import org.pentaho.ui.database.event.IConnectionAutoBeanFactory;
import org.pentaho.ui.database.gwt.GwtDatabaseDialog;
import org.pentaho.ui.database.gwt.GwtXulAsyncDatabaseDialectService;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulHbox;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class WizardConnectionController
extends AbstractXulEventHandler {
    private List<ConnectionDialogListener> listeners = new ArrayList<ConnectionDialogListener>();
    private DatasourceModel datasourceModel;
    private XulDialog removeConfirmationDialog;
    private XulDialog saveConnectionConfirmationDialog;
    private XulDialog overwriteConnectionConfirmationDialog;
    private XulDialog renameConnectionConfirmationDialog;
    private XulDialog errorDialog;
    private XulDialog errorDetailsDialog;
    private XulDialog successDialog;
    private XulDialog successDetailsDialog;
    private XulLabel errorLabel = null;
    private XulLabel successLabel = null;
    GwtXulAsyncDatabaseDialectService dialectService = new GwtXulAsyncDatabaseDialectService();
    GwtDatabaseDialog databaseDialog;
    DatabaseTypeHelper databaseTypeHelper;
    IDatabaseConnection currentConnection;
    ConnectionSetter connectionSetter = new ConnectionSetter();
    protected IConnectionAutoBeanFactory connectionAutoBeanFactory;
    protected String previousConnectionName;
    protected String existingConnectionName;

    public WizardConnectionController(Document document) {
        this.document = document;
        this.connectionAutoBeanFactory = (IConnectionAutoBeanFactory)GWT.create(IConnectionAutoBeanFactory.class);
        this.init();
    }

    protected void copyDatabaseConnectionProperties(IDatabaseConnection source, IDatabaseConnection target) {
        target.setId(source.getId());
        target.setAccessType(source.getAccessType());
        target.setDatabaseType(source.getDatabaseType());
        target.setExtraOptions(source.getExtraOptions());
        target.setName(source.getName());
        target.setHostname(source.getHostname());
        target.setDatabaseName(source.getDatabaseName());
        target.setDatabasePort(source.getDatabasePort());
        target.setUsername(source.getUsername());
        target.setPassword(source.getPassword());
        target.setStreamingResults(source.isStreamingResults());
        target.setDataTablespace(source.getDataTablespace());
        target.setIndexTablespace(source.getIndexTablespace());
        target.setUsingDoubleDecimalAsSchemaTableSeparator(source.isUsingDoubleDecimalAsSchemaTableSeparator());
        target.setInformixServername(source.getInformixServername());
        target.setAttributes(source.getAttributes());
        target.setChanged(source.getChanged());
        target.setQuoteAllFields(source.isQuoteAllFields());
        target.setForcingIdentifiersToLowerCase(source.isForcingIdentifiersToLowerCase());
        target.setForcingIdentifiersToUpperCase(source.isForcingIdentifiersToUpperCase());
        target.setConnectSql(source.getConnectSql());
        target.setUsingConnectionPool(source.isUsingConnectionPool());
        target.setInitialPoolSize(source.getInitialPoolSize());
        target.setMaximumPoolSize(source.getMaximumPoolSize());
        target.setPartitioned(source.isPartitioned());
        target.setConnectionPoolingProperties(source.getConnectionPoolingProperties());
        target.setPartitioningInformation(source.getPartitioningInformation());
    }

    protected AutoBean<IDatabaseConnection> createIDatabaseConnectionBean(IDatabaseConnection connection) {
        AutoBean bean = this.connectionAutoBeanFactory.iDatabaseConnection();
        IDatabaseConnection connectionBean = (IDatabaseConnection)bean.as();
        this.copyDatabaseConnectionProperties(connection, connectionBean);
        return AutoBeanUtils.getAutoBean((Object)connectionBean);
    }

    @Bindable
    public void init() {
        XulServiceCallback<List<IDatabaseType>> callback = new XulServiceCallback<List<IDatabaseType>>(){

            public void error(String message, Throwable error) {
                error.printStackTrace();
            }

            public void success(List<IDatabaseType> retVal) {
                WizardConnectionController.this.databaseTypeHelper = new DatabaseTypeHelper(retVal);
            }
        };
        this.dialectService.getDatabaseTypes((XulServiceCallback)callback);
        this.saveConnectionConfirmationDialog = (XulDialog)this.document.getElementById("saveConnectionConfirmationDialog");
        this.overwriteConnectionConfirmationDialog = (XulDialog)this.document.getElementById("overwriteConnectionConfirmationDialog");
        this.renameConnectionConfirmationDialog = (XulDialog)this.document.getElementById("renameConnectionConfirmationDialog");
        this.errorDialog = (XulDialog)this.document.getElementById("errorDialog");
        this.errorDetailsDialog = (XulDialog)this.document.getElementById("errorDetailsDialog");
        this.errorLabel = (XulLabel)this.document.getElementById("errorLabel");
        this.successDialog = (XulDialog)this.document.getElementById("successDialog");
        this.successDetailsDialog = (XulDialog)this.document.getElementById("successDetailsDialog");
        this.successLabel = (XulLabel)this.document.getElementById("successLabel");
        this.removeConfirmationDialog = (XulDialog)this.document.getElementById("removeConfirmationDialog");
    }

    @Bindable
    public void openErrorDialog(String title, String message) {
        this.errorDialog.setTitle(title);
        this.errorLabel.setValue(message);
        this.errorDialog.show();
    }

    @Bindable
    public void closeErrorDialog() {
        if (!this.errorDialog.isHidden()) {
            this.errorDialog.hide();
        }
    }

    @Bindable
    public void closeSuccessDetailsDialog() {
        if (!this.successDetailsDialog.isHidden()) {
            this.successDetailsDialog.hide();
        }
    }

    @Bindable
    public void toggleDetails() {
        XulHbox details;
        details.setVisible(!(details = (XulHbox)this.document.getElementById("details_hider")).isVisible());
    }

    @Bindable
    public void openSuccesDialog(String title, String message) {
        this.successDialog.setTitle(title);
        this.successLabel.setValue(message);
        this.successDialog.show();
    }

    @Bindable
    public void closeSuccessDialog() {
        if (!this.successDialog.isHidden()) {
            this.successDialog.hide();
        }
    }

    @Bindable
    public void toggleSuccessDetails() {
        XulHbox details;
        details.setVisible(!(details = (XulHbox)this.document.getElementById("success_details_hider")).isVisible());
    }

    @Bindable
    public void closeErrorDetailsDialog() {
        if (!this.errorDetailsDialog.isHidden()) {
            this.errorDetailsDialog.hide();
        }
    }

    public void setDatasourceModel(DatasourceModel model) {
        this.datasourceModel = model;
    }

    public DatasourceModel getDatasourceModel() {
        return this.datasourceModel;
    }

    public String getName() {
        return "wizardConnectionController";
    }

    @Bindable
    public void closeDialog() {
        for (ConnectionDialogListener listener : this.listeners) {
            listener.onDialogCancel();
        }
    }

    @Bindable
    public void handleDialogAccept() {
        RequestBuilder testConnectionBuilder = new RequestBuilder(RequestBuilder.PUT, ConnectionController.getServiceURL("test"));
        testConnectionBuilder.setHeader("Content-Type", "application/json");
        try {
            AutoBean<IDatabaseConnection> bean = this.createIDatabaseConnectionBean(this.currentConnection);
            testConnectionBuilder.sendRequest(AutoBeanCodex.encode(bean).getPayload(), new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    WizardConnectionController.this.saveConnectionConfirmationDialog.show();
                }

                public void onResponseReceived(Request request, Response response) {
                    try {
                        if (response.getStatusCode() == 200) {
                            WizardConnectionController.this.renameCheck();
                        } else {
                            WizardConnectionController.this.saveConnectionConfirmationDialog.show();
                        }
                    }
                    catch (Exception e) {
                        WizardConnectionController.this.displayErrorMessage(e);
                    }
                }
            });
        }
        catch (RequestException e) {
            this.displayErrorMessage(e);
        }
    }

    @Bindable
    public void renameCheck() {
        if (!this.saveConnectionConfirmationDialog.isHidden()) {
            this.closeSaveConnectionConfirmationDialog();
        }
        if (this.datasourceModel.isEditing() && !this.previousConnectionName.equals(this.currentConnection.getName())) {
            this.showRenameConnectionConfirmationDialog();
        } else {
            this.overwriteCheck();
        }
    }

    @Bindable
    public void overwriteCheck() {
        if (!this.saveConnectionConfirmationDialog.isHidden()) {
            this.closeSaveConnectionConfirmationDialog();
        }
        if (!this.renameConnectionConfirmationDialog.isHidden()) {
            this.closeRenameConnectionConfirmationDialog();
        }
        if (this.datasourceModel.isEditing() && this.previousConnectionName.equals(this.currentConnection.getName())) {
            this.updateConnection();
        } else {
            RequestBuilder getConnectionBuilder = new RequestBuilder(RequestBuilder.GET, ConnectionController.getServiceURL("get", new String[][]{{"name", this.currentConnection.getName()}}));
            getConnectionBuilder.setHeader("Content-Type", "application/json");
            try {
                AutoBean<IDatabaseConnection> bean = this.createIDatabaseConnectionBean(this.currentConnection);
                getConnectionBuilder.sendRequest(AutoBeanCodex.encode(bean).getPayload(), new RequestCallback(){

                    public void onResponseReceived(Request request, Response response) {
                        switch (response.getStatusCode()) {
                            case 200: {
                                WizardConnectionController.this.showOverwriteConnectionConfirmationDialog();
                                break;
                            }
                            case 404: {
                                WizardConnectionController.this.saveConnection();
                                break;
                            }
                            default: {
                                WizardConnectionController.this.saveConnection();
                            }
                        }
                    }

                    public void onError(Request request, Throwable exception) {
                        WizardConnectionController.this.displayErrorMessage(exception);
                    }
                });
            }
            catch (Exception e) {
                this.displayErrorMessage(e);
            }
        }
    }

    @Bindable
    public void updateConnection() {
        RequestBuilder updateConnectionBuilder = new RequestBuilder(RequestBuilder.POST, ConnectionController.getServiceURL("update"));
        updateConnectionBuilder.setHeader("Content-Type", "application/json");
        try {
            AutoBean<IDatabaseConnection> bean = this.createIDatabaseConnectionBean(this.currentConnection);
            updateConnectionBuilder.sendRequest(AutoBeanCodex.encode(bean).getPayload(), new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    WizardConnectionController.this.displayErrorMessage(exception);
                }

                public void onResponseReceived(Request request, Response response) {
                    try {
                        if (response.getStatusCode() == 200) {
                            WizardConnectionController.this.currentConnection = AutobeanUtilities.connectionBeanToImpl(WizardConnectionController.this.currentConnection);
                            WizardConnectionController.this.datasourceModel.getGuiStateModel().updateConnection(WizardConnectionController.this.existingConnectionName, WizardConnectionController.this.currentConnection);
                            WizardConnectionController.this.datasourceModel.setSelectedRelationalConnection(WizardConnectionController.this.currentConnection);
                        } else if (response.getStatusCode() == 500) {
                            RequestBuilder deleteConnectionBuilder = new RequestBuilder(RequestBuilder.DELETE, ConnectionController.getServiceURL("deletebyname", new String[][]{{"name", WizardConnectionController.this.previousConnectionName}}));
                            try {
                                deleteConnectionBuilder.sendRequest(null, new RequestCallback(){

                                    public void onError(Request request, Throwable exception) {
                                        WizardConnectionController.this.displayErrorMessage(exception);
                                    }

                                    public void onResponseReceived(Request request, Response response) {
                                        try {
                                            if (response.getStatusCode() == 200) {
                                                WizardConnectionController.this.datasourceModel.getGuiStateModel().deleteConnection(WizardConnectionController.this.datasourceModel.getSelectedRelationalConnection().getName());
                                                List<IDatabaseConnection> connections = WizardConnectionController.this.datasourceModel.getGuiStateModel().getConnections();
                                                if (connections != null && connections.size() > 0) {
                                                    WizardConnectionController.this.datasourceModel.setSelectedRelationalConnection(connections.get(connections.size() - 1));
                                                } else {
                                                    WizardConnectionController.this.datasourceModel.setSelectedRelationalConnection(null);
                                                }
                                                WizardConnectionController.this.addConnection();
                                            } else {
                                                WizardConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0002_UNABLE_TO_DELETE_CONNECTION"));
                                            }
                                        }
                                        catch (Exception e) {
                                            WizardConnectionController.this.displayErrorMessage(e);
                                        }
                                    }
                                });
                            }
                            catch (RequestException e) {
                                WizardConnectionController.this.displayErrorMessage(e);
                            }
                        } else {
                            WizardConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0004_UNABLE_TO_UPDATE_CONNECTION"));
                        }
                    }
                    catch (Exception e) {
                        WizardConnectionController.this.displayErrorMessage(e);
                    }
                }
            });
        }
        catch (RequestException e) {
            this.displayErrorMessage(e);
        }
    }

    @Bindable
    public void addConnection() {
        RequestBuilder addConnectionBuilder = new RequestBuilder(RequestBuilder.POST, ConnectionController.getServiceURL("add"));
        addConnectionBuilder.setHeader("Content-Type", "application/json");
        try {
            AutoBean<IDatabaseConnection> bean = this.createIDatabaseConnectionBean(this.currentConnection);
            addConnectionBuilder.sendRequest(AutoBeanCodex.encode(bean).getPayload(), new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    WizardConnectionController.this.displayErrorMessage(exception);
                }

                public void onResponseReceived(Request request, Response response) {
                    try {
                        if (response.getStatusCode() == 200) {
                            IDatabaseConnection conn = AutobeanUtilities.connectionBeanToImpl(WizardConnectionController.this.currentConnection);
                            WizardConnectionController.this.datasourceModel.getGuiStateModel().addConnection(conn);
                            WizardConnectionController.this.datasourceModel.setSelectedRelationalConnection(conn);
                        } else {
                            WizardConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0001_UNABLE_TO_ADD_CONNECTION"));
                        }
                    }
                    catch (Exception e) {
                        WizardConnectionController.this.displayErrorMessage(e);
                    }
                }
            });
        }
        catch (RequestException e) {
            this.displayErrorMessage(e);
        }
    }

    @Bindable
    public void overwriteConnection() {
        if (!this.saveConnectionConfirmationDialog.isHidden()) {
            this.closeSaveConnectionConfirmationDialog();
        }
        if (!this.renameConnectionConfirmationDialog.isHidden()) {
            this.closeRenameConnectionConfirmationDialog();
        }
        if (!this.overwriteConnectionConfirmationDialog.isHidden()) {
            this.overwriteConnectionConfirmationDialog.hide();
        }
        this.existingConnectionName = this.currentConnection.getName();
        this.updateConnection();
    }

    @Bindable
    public void saveConnection() {
        if (!this.saveConnectionConfirmationDialog.isHidden()) {
            this.closeSaveConnectionConfirmationDialog();
        }
        if (!this.renameConnectionConfirmationDialog.isHidden()) {
            this.closeRenameConnectionConfirmationDialog();
        }
        if (!this.overwriteConnectionConfirmationDialog.isHidden()) {
            this.overwriteConnectionConfirmationDialog.hide();
        }
        if (this.datasourceModel.isEditing()) {
            this.updateConnection();
        } else {
            this.addConnection();
        }
    }

    @Bindable
    public void testConnection() {
        RequestBuilder testConnectionBuilder = new RequestBuilder(RequestBuilder.PUT, ConnectionController.getServiceURL("test"));
        testConnectionBuilder.setHeader("Content-Type", "application/json");
        try {
            AutoBean<IDatabaseConnection> bean = this.createIDatabaseConnectionBean(this.currentConnection);
            testConnectionBuilder.sendRequest(AutoBeanCodex.encode(bean).getPayload(), new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    WizardConnectionController.this.displayErrorMessage(exception);
                }

                public void onResponseReceived(Request request, Response response) {
                    Boolean testPassed = new Boolean(response.getText());
                    try {
                        if (testPassed.booleanValue()) {
                            WizardConnectionController.this.openSuccesDialog(MessageHandler.getString("SUCCESS"), MessageHandler.getString("ConnectionController.CONNECTION_TEST_SUCCESS"));
                        } else {
                            WizardConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0003_CONNECTION_TEST_FAILED"));
                        }
                    }
                    catch (Exception e) {
                        WizardConnectionController.this.displayErrorMessage(e);
                    }
                }
            });
        }
        catch (RequestException e) {
            this.displayErrorMessage(e);
        }
    }

    @Bindable
    public void deleteConnection() {
        this.removeConfirmationDialog.hide();
        RequestBuilder deleteConnectionBuilder = new RequestBuilder(RequestBuilder.DELETE, ConnectionController.getServiceURL("deletebyname", new String[][]{{"name", this.datasourceModel.getSelectedRelationalConnection().getName()}}));
        try {
            deleteConnectionBuilder.sendRequest(null, new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    WizardConnectionController.this.displayErrorMessage(exception);
                }

                public void onResponseReceived(Request request, Response response) {
                    try {
                        if (response.getStatusCode() == 200) {
                            WizardConnectionController.this.openSuccesDialog(MessageHandler.getString("SUCCESS"), MessageHandler.getString("ConnectionController.CONNECTION_DELETED"));
                            WizardConnectionController.this.datasourceModel.getGuiStateModel().deleteConnection(WizardConnectionController.this.datasourceModel.getSelectedRelationalConnection().getName());
                            List<IDatabaseConnection> connections = WizardConnectionController.this.datasourceModel.getGuiStateModel().getConnections();
                            if (connections != null && connections.size() > 0) {
                                WizardConnectionController.this.datasourceModel.setSelectedRelationalConnection(connections.get(connections.size() - 1));
                            } else {
                                WizardConnectionController.this.datasourceModel.setSelectedRelationalConnection(null);
                            }
                        } else {
                            WizardConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0002_UNABLE_TO_DELETE_CONNECTION"));
                        }
                    }
                    catch (Exception e) {
                        WizardConnectionController.this.displayErrorMessage(e);
                    }
                }
            });
        }
        catch (RequestException e) {
            this.displayErrorMessage(e);
        }
    }

    public void addConnectionDialogListener(ConnectionDialogListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeConnectionDialogListener(ConnectionDialogListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void displayErrorMessage(Throwable th) {
        this.errorDialog.setTitle(ExceptionParser.getErrorHeader(th, MessageHandler.getString("DatasourceEditor.USER_ERROR_TITLE")));
        this.errorLabel.setValue(ExceptionParser.getErrorMessage(th, MessageHandler.getString("DatasourceEditor.ERROR_0001_UNKNOWN_ERROR_HAS_OCCURED")));
        this.errorDialog.show();
    }

    @Bindable
    public void onDialogAccept(IDatabaseConnection databaseConnection) {
        this.currentConnection = databaseConnection;
        this.addConnection();
    }

    @Bindable
    public void onDialogCancel() {
    }

    @Bindable
    public void onDialogReady() {
        if (this.datasourceModel.isEditing()) {
            this.showEditConnectionDialog();
        } else {
            this.showAddConnectionDialog();
        }
    }

    @Bindable
    public void showAddConnectionDialog() {
        this.datasourceModel.setEditing(false);
        if (this.databaseDialog != null) {
            this.existingConnectionName = this.previousConnectionName = null;
            this.databaseDialog.setDatabaseConnection(null);
            this.databaseDialog.show();
        } else {
            this.databaseDialog = new GwtDatabaseDialog(this.databaseTypeHelper, GWT.getModuleBaseURL() + "dataaccess-databasedialog.xul", (DatabaseDialogListener)this.connectionSetter);
        }
    }

    @Bindable
    public void showEditConnectionDialog() {
        this.datasourceModel.setEditing(true);
        if (this.databaseDialog != null) {
            IDatabaseConnection connection = this.datasourceModel.getSelectedRelationalConnection();
            this.existingConnectionName = this.previousConnectionName = connection.getName();
            DatabaseConnection editConnection = new DatabaseConnection();
            this.copyDatabaseConnectionProperties(connection, (IDatabaseConnection)editConnection);
            this.databaseDialog.setDatabaseConnection((IDatabaseConnection)editConnection);
            this.databaseDialog.show();
        } else {
            this.databaseDialog = new GwtDatabaseDialog(this.databaseTypeHelper, GWT.getModuleBaseURL() + "dataaccess-databasedialog.xul", (DatabaseDialogListener)this.connectionSetter);
        }
    }

    @Bindable
    public void showRemoveConnectionDialog() {
        this.removeConfirmationDialog.show();
    }

    @Bindable
    public void closeSaveConnectionConfirmationDialog() {
        this.saveConnectionConfirmationDialog.hide();
    }

    @Bindable
    public void closeRemoveConfirmationDialog() {
        this.removeConfirmationDialog.hide();
    }

    public void showRenameConnectionConfirmationDialog() {
        this.renameConnectionConfirmationDialog.show();
    }

    @Bindable
    public void closeRenameConnectionConfirmationDialog() {
        this.renameConnectionConfirmationDialog.hide();
    }

    public void showOverwriteConnectionConfirmationDialog() {
        this.overwriteConnectionConfirmationDialog.show();
    }

    @Bindable
    public void closeOverwriteConnectionConfirmationDialog() {
        this.overwriteConnectionConfirmationDialog.hide();
    }

    class ConnectionSetter
    implements DatabaseDialogListener {
        ConnectionSetter() {
        }

        public void onDialogAccept(IDatabaseConnection connection) {
            WizardConnectionController.this.currentConnection = connection;
            WizardConnectionController.this.handleDialogAccept();
        }

        public void onDialogCancel() {
        }

        public void onDialogReady() {
            if (WizardConnectionController.this.datasourceModel.isEditing()) {
                WizardConnectionController.this.showEditConnectionDialog();
            } else {
                WizardConnectionController.this.showAddConnectionDialog();
            }
        }
    }
}

