/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.platform.dataaccess.datasource.wizard.models.FileInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IRelationalModelValidationListener;
import org.pentaho.platform.dataaccess.datasource.wizard.models.RelationalModelValidationListenerCollection;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;

public class GuiStateModel
extends XulEventSourceAdapter {
    private boolean relationalValidated;
    private boolean relationalPreviewValidated;
    private boolean relationalApplyValidated;
    private List<IDatabaseConnection> connections = new ArrayList<IDatabaseConnection>();
    private String previewLimit = "10";
    private List<LogicalModel> logicalModels;
    private String localeCode;
    private boolean dataStagingComplete;
    private FileInfo selectedCsvFile;
    private boolean dirty = true;
    private RelationalModelValidationListenerCollection relationalModelValidationListeners;

    @Bindable
    public List<IDatabaseConnection> getConnections() {
        return this.connections;
    }

    public void addConnection(IDatabaseConnection connection) {
        List<IDatabaseConnection> previousValue = this.getPreviousValue();
        this.connections.add(connection);
        this.firePropertyChange("connections", previousValue, this.connections);
    }

    public void updateConnection(String oldName, IDatabaseConnection connection) {
        List<Object> previousValue = this.getPreviousValue();
        IDatabaseConnection conn = this.getConnectionByName(oldName);
        if (conn == null) {
            return;
        }
        String newName = connection.getName();
        conn.setName(newName);
        conn.setAccessType(connection.getAccessType());
        conn.setConnectionPoolingProperties(connection.getConnectionPoolingProperties());
        conn.setConnectSql(connection.getConnectSql());
        conn.setDatabaseName(connection.getDatabaseName());
        conn.setDatabasePort(connection.getDatabasePort());
        conn.setDatabaseType(connection.getDatabaseType());
        conn.setDataTablespace(connection.getDataTablespace());
        conn.setForcingIdentifiersToLowerCase(connection.isForcingIdentifiersToLowerCase());
        conn.setForcingIdentifiersToUpperCase(connection.isForcingIdentifiersToUpperCase());
        conn.setHostname(connection.getHostname());
        conn.setIndexTablespace(connection.getIndexTablespace());
        conn.setInformixServername(connection.getInformixServername());
        conn.setInitialPoolSize(connection.getInitialPoolSize());
        conn.setMaximumPoolSize(connection.getMaximumPoolSize());
        conn.setPartitioned(connection.isPartitioned());
        conn.setPartitioningInformation(connection.getPartitioningInformation());
        conn.setPassword(connection.getPassword());
        conn.setQuoteAllFields(connection.isQuoteAllFields());
        conn.setExtraOptions(connection.getExtraOptions());
        conn.setStreamingResults(connection.isStreamingResults());
        conn.setUsername(connection.getUsername());
        conn.setUsingConnectionPool(connection.isUsingConnectionPool());
        conn.setUsingDoubleDecimalAsSchemaTableSeparator(connection.isUsingDoubleDecimalAsSchemaTableSeparator());
        if (!oldName.equals(newName)) {
            this.firePropertyChange("connections", previousValue, Collections.emptyList());
            previousValue = Collections.emptyList();
        }
        this.firePropertyChange("connections", previousValue, this.connections);
    }

    public void updateConnection(IDatabaseConnection connection) {
        this.updateConnection(connection.getName(), connection);
    }

    @Bindable
    private List<IDatabaseConnection> getPreviousValue() {
        ArrayList<IDatabaseConnection> previousValue = new ArrayList<IDatabaseConnection>();
        for (IDatabaseConnection conn : this.connections) {
            previousValue.add(conn);
        }
        return previousValue;
    }

    public void deleteConnection(IDatabaseConnection connection) {
        List<IDatabaseConnection> previousValue = this.getPreviousValue();
        this.connections.remove(this.connections.indexOf(connection));
        this.firePropertyChange("connections", previousValue, this.connections);
    }

    public void deleteConnection(String name) {
        for (IDatabaseConnection connection : this.connections) {
            if (!connection.getName().equals(name)) continue;
            this.deleteConnection(connection);
            break;
        }
    }

    @Bindable
    public void setConnections(List<IDatabaseConnection> value) {
        List<IDatabaseConnection> previousValue = this.getPreviousValue();
        this.connections = value;
        this.firePropertyChange("connections", previousValue, value);
    }

    @Bindable
    public String getPreviewLimit() {
        return this.previewLimit;
    }

    @Bindable
    public void setPreviewLimit(String value) {
        String previousVal = this.previewLimit;
        this.previewLimit = value;
        this.firePropertyChange("previewLimit", previousVal, value);
    }

    public IDatabaseConnection getConnectionByName(String name) {
        for (IDatabaseConnection connection : this.connections) {
            if (!connection.getName().equals(name)) continue;
            return connection;
        }
        return null;
    }

    public Integer getConnectionIndex(IDatabaseConnection conn) {
        IDatabaseConnection connection = this.getConnectionByName(conn.getName());
        return this.connections.indexOf(connection);
    }

    @Bindable
    public boolean isRelationalValidated() {
        return this.relationalValidated;
    }

    @Bindable
    private void setRelationalValidated(boolean value) {
        if (value != this.relationalValidated) {
            this.relationalValidated = value;
            this.firePropertyChange("relationalValidated", !value, value);
        }
    }

    public void validateRelational() {
        this.setRelationalPreviewValidated(true);
        this.setRelationalApplyValidated(true);
        this.setRelationalValidated(true);
        this.fireRelationalModelValid();
    }

    public void invalidateRelational() {
        this.setRelationalPreviewValidated(false);
        this.setRelationalApplyValidated(false);
        this.setRelationalValidated(false);
        this.fireRelationalModelInValid();
    }

    @Bindable
    public void clearModel() {
        this.setPreviewLimit("10");
        this.setSelectedCsvFile(null);
    }

    public void addRelationalModelValidationListener(IRelationalModelValidationListener listener) {
        if (this.relationalModelValidationListeners == null) {
            this.relationalModelValidationListeners = new RelationalModelValidationListenerCollection();
        }
        this.relationalModelValidationListeners.add(listener);
    }

    public void removeRelationalListener(IRelationalModelValidationListener listener) {
        if (this.relationalModelValidationListeners != null) {
            this.relationalModelValidationListeners.remove(listener);
        }
    }

    void fireRelationalModelValid() {
        if (this.relationalModelValidationListeners != null) {
            this.relationalModelValidationListeners.fireRelationalModelValid();
        }
    }

    void fireRelationalModelInValid() {
        if (this.relationalModelValidationListeners != null) {
            this.relationalModelValidationListeners.fireRelationalModelInValid();
        }
    }

    public void setRelationalPreviewValidated(boolean value) {
        if (value != this.relationalPreviewValidated) {
            this.relationalPreviewValidated = value;
            this.firePropertyChange("relationalPreviewValidated", !value, this.relationalPreviewValidated);
        }
    }

    public boolean isRelationalPreviewValidated() {
        return this.relationalPreviewValidated;
    }

    public boolean isRelationalApplyValidated() {
        return this.relationalApplyValidated;
    }

    public void setRelationalApplyValidated(boolean value) {
        if (value != this.relationalApplyValidated) {
            this.relationalApplyValidated = value;
            this.firePropertyChange("relationalApplyValidated", !value, this.relationalApplyValidated);
        }
    }

    public List<LogicalModel> getLogicalModels() {
        return this.logicalModels;
    }

    public void setLogicalModels(List<LogicalModel> logicalModels) {
        this.logicalModels = logicalModels;
    }

    public String getLocaleCode() {
        return this.localeCode;
    }

    public void setLocaleCode(String localeCode) {
        this.localeCode = localeCode;
    }

    public void setDataStagingComplete(boolean status) {
        this.dataStagingComplete = status;
    }

    public boolean isDataStagingComplete() {
        return this.dataStagingComplete;
    }

    public FileInfo getSelectedCsvFile() {
        return this.selectedCsvFile;
    }

    public void setSelectedCsvFile(FileInfo selectedCsvFile) {
        this.selectedCsvFile = selectedCsvFile;
    }

    @Bindable
    public boolean isDirty() {
        return this.dirty;
    }

    @Bindable
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.firePropertyChange("dirty", null, dirty);
    }
}

