/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import java.lang.reflect.Constructor;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPentahoConnection;
import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.dialect.GenericDatabaseDialect;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.service.DatabaseDialectService;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.api.repository.datasource.DatasourceMgmtServiceException;
import org.pentaho.platform.api.repository.datasource.DuplicateDatasourceException;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.api.repository.datasource.NonExistingDatasourceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.IConnectionService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.IDataAccessPermissionHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.SimpleDataAccessPermissionHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.ConnectionServiceHelper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.PentahoConnectionFactory;
import org.pentaho.platform.plugin.services.connections.sql.SQLConnection;

public class ConnectionServiceImpl
extends PentahoBase
implements IConnectionService {
    private IDataAccessPermissionHandler dataAccessPermHandler;
    protected IDatasourceMgmtService datasourceMgmtSvc;
    private DatabaseDialectService dialectService = new DatabaseDialectService();
    GenericDatabaseDialect genericDialect = new GenericDatabaseDialect();
    private static final Log logger = LogFactory.getLog(ConnectionServiceImpl.class);

    public Log getLogger() {
        return logger;
    }

    public ConnectionServiceImpl() {
        IPentahoSession session = PentahoSessionHolder.getSession();
        this.datasourceMgmtSvc = (IDatasourceMgmtService)PentahoSystem.get(IDatasourceMgmtService.class, (IPentahoSession)session);
        try {
            IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
            String dataAccessClassName = resLoader.getPluginSetting(this.getClass(), "settings/data-access-permission-handler", SimpleDataAccessPermissionHandler.class.getName());
            Class<?> clazz = Class.forName(dataAccessClassName, true, this.getClass().getClassLoader());
            Constructor<?> defaultConstructor = clazz.getConstructor(new Class[0]);
            this.dataAccessPermHandler = (IDataAccessPermissionHandler)defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0007_DATAACCESS_PERMISSIONS_INIT_ERROR", e.getLocalizedMessage()), (Throwable)e);
            this.dataAccessPermHandler = new SimpleDataAccessPermissionHandler();
        }
    }

    public boolean hasDataAccessPermission() {
        return this.dataAccessPermHandler != null && this.dataAccessPermHandler.hasDataAccessPermission(PentahoSessionHolder.getSession());
    }

    protected void ensureDataAccessPermission() throws ConnectionServiceException {
        if (!this.hasDataAccessPermission()) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED");
            logger.error((Object)message);
            throw new ConnectionServiceException(403, message);
        }
    }

    @Override
    public List<IDatabaseConnection> getConnections() throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        List connectionList = null;
        try {
            connectionList = this.datasourceMgmtSvc.getDatasources();
        }
        catch (DatasourceMgmtServiceException dme) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0002_UNABLE_TO_GET_CONNECTION_LIST", dme.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(message, dme);
        }
        return connectionList;
    }

    @Override
    public IDatabaseConnection getConnectionByName(String name) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        try {
            IDatabaseConnection connection = this.datasourceMgmtSvc.getDatasourceByName(name);
            if (connection == null) {
                throw new ConnectionServiceException(404, Messages.getErrorString("ConnectionServiceImpl.ERROR_0003_UNABLE_TO_GET_CONNECTION", name));
            }
            return connection;
        }
        catch (DatasourceMgmtServiceException dme) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0003_UNABLE_TO_GET_CONNECTION", dme.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(message, dme);
        }
    }

    public IDatabaseConnection getConnectionById(String id) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        try {
            IDatabaseConnection connection = this.datasourceMgmtSvc.getDatasourceById(id);
            if (connection == null) {
                throw new ConnectionServiceException(404, Messages.getErrorString("ConnectionServiceImpl.ERROR_0003_UNABLE_TO_GET_CONNECTION", id));
            }
            return connection;
        }
        catch (DatasourceMgmtServiceException dme) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0003_UNABLE_TO_GET_CONNECTION", dme.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(message, dme);
        }
    }

    @Override
    public boolean addConnection(IDatabaseConnection connection) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        try {
            this.datasourceMgmtSvc.createDatasource(connection);
            return true;
        }
        catch (DuplicateDatasourceException duplicateDatasourceException) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0004_UNABLE_TO_ADD_CONNECTION", connection.getName(), duplicateDatasourceException.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(409, message, duplicateDatasourceException);
        }
        catch (Exception e) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0004_UNABLE_TO_ADD_CONNECTION", connection.getName(), e.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(message, e);
        }
    }

    protected String getConnectionPassword(String name, String password) throws ConnectionServiceException {
        return ConnectionServiceHelper.getConnectionPassword(name, password);
    }

    @Override
    public boolean updateConnection(IDatabaseConnection connection) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        try {
            connection.setPassword(this.getConnectionPassword(connection.getName(), connection.getPassword()));
            this.datasourceMgmtSvc.updateDatasourceByName(connection.getName(), connection);
            return true;
        }
        catch (NonExistingDatasourceException nonExistingDatasourceException) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0005_UNABLE_TO_UPDATE_CONNECTION", connection.getName(), nonExistingDatasourceException.getLocalizedMessage());
            throw new ConnectionServiceException(404, message, nonExistingDatasourceException);
        }
        catch (Exception e) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0005_UNABLE_TO_UPDATE_CONNECTION", connection.getName(), e.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(message, e);
        }
    }

    @Override
    public boolean deleteConnection(IDatabaseConnection connection) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        try {
            this.datasourceMgmtSvc.deleteDatasourceByName(connection.getName());
            return true;
        }
        catch (NonExistingDatasourceException nonExistingDatasourceException) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0006_UNABLE_TO_DELETE_CONNECTION", connection.getName(), nonExistingDatasourceException.getLocalizedMessage());
            throw new ConnectionServiceException(404, message, nonExistingDatasourceException);
        }
        catch (Exception e) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0006_UNABLE_TO_DELETE_CONNECTION", connection.getName(), e.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(message, e);
        }
    }

    @Override
    public boolean deleteConnection(String name) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        try {
            this.datasourceMgmtSvc.deleteDatasourceByName(name);
            return true;
        }
        catch (NonExistingDatasourceException nonExistingDatasourceException) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0006_UNABLE_TO_DELETE_CONNECTION", name, nonExistingDatasourceException.getLocalizedMessage());
            throw new ConnectionServiceException(404, message, nonExistingDatasourceException);
        }
        catch (Exception e) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0006_UNABLE_TO_DELETE_CONNECTION", name, e.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(message, e);
        }
    }

    @Override
    public boolean testConnection(IDatabaseConnection connection) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        if (connection != null) {
            if (connection.getPassword() == null) {
                connection.setPassword("");
            }
            IDatabaseDialect dialect = this.dialectService.getDialect(connection);
            String driverClass = null;
            driverClass = connection.getDatabaseType().getShortName().equals("GENERIC") ? (String)connection.getAttributes().get("CUSTOM_DRIVER_CLASS") : dialect.getNativeDriver();
            IPentahoConnection pentahoConnection = null;
            try {
                pentahoConnection = connection.getAccessType().equals((Object)DatabaseAccessType.JNDI) ? PentahoConnectionFactory.getConnection((String)"SQL", (String)connection.getDatabaseName(), null, (ILogger)this) : PentahoConnectionFactory.getConnection((String)"SQL", (String)driverClass, (String)dialect.getURLWithExtraOptions(connection), (String)connection.getUsername(), (String)this.getConnectionPassword(connection.getName(), connection.getPassword()), null, (ILogger)this);
            }
            catch (DatabaseDialectException e) {
                throw new ConnectionServiceException(e);
            }
            if (pentahoConnection != null) {
                boolean testedOk = ((SQLConnection)pentahoConnection).getNativeConnection() != null;
                pentahoConnection.close();
                return testedOk;
            }
            return false;
        }
        String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0008_UNABLE_TO_TEST_NULL_CONNECTION");
        logger.error((Object)message);
        throw new ConnectionServiceException(400, message);
    }

    @Override
    public boolean isConnectionExist(String connectionName) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        try {
            IDatabaseConnection connection = this.datasourceMgmtSvc.getDatasourceByName(connectionName);
            return connection != null;
        }
        catch (DatasourceMgmtServiceException dme) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0003_UNABLE_TO_GET_CONNECTION", dme.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(message, dme);
        }
    }
}

