/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPlatformReadyListener;
import org.pentaho.platform.api.engine.IPluginLifecycleListener;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.api.engine.PluginLifecycleException;
import org.pentaho.platform.api.repository2.unified.IBackingRepositoryLifecycleManager;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.AgileMartDatasourceLifecycleManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.repository2.unified.lifecycle.DelegatingBackingRepositoryLifecycleManager;

public class DataAccessLifecycleListener
implements IPluginLifecycleListener,
IPlatformReadyListener {
    private static final Log log = LogFactory.getLog(DataAccessLifecycleListener.class);
    private static final String ENABLE_AGILEMART_DATASOURCE = "enable-agile-mart-datasource";

    public void init() throws PluginLifecycleException {
    }

    public void loaded() throws PluginLifecycleException {
    }

    public void ready() throws PluginLifecycleException {
        boolean enableAgilemartDatasource = false;
        try {
            IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
            enableAgilemartDatasource = Boolean.parseBoolean(resLoader.getPluginSetting(DataAccessLifecycleListener.class, ENABLE_AGILEMART_DATASOURCE, "false"));
        }
        catch (Throwable t) {
            log.warn((Object)t.getMessage(), t);
        }
        if (enableAgilemartDatasource) {
            try {
                SecurityHelper.getInstance().runAsSystem((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        AgileMartDatasourceLifecycleManager.getInstance().startup();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            DelegatingBackingRepositoryLifecycleManager manager = (DelegatingBackingRepositoryLifecycleManager)PentahoSystem.get(DelegatingBackingRepositoryLifecycleManager.class, (String)"backingRepositoryLifecycleManager", null);
            manager.addLifeCycleManager((IBackingRepositoryLifecycleManager)AgileMartDatasourceLifecycleManager.getInstance());
        }
    }

    public void unLoaded() throws PluginLifecycleException {
    }
}

