/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataParam;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.dialect.GenericDatabaseDialect;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.DatabaseConnectionPoolParameter;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.service.DatabaseDialectService;
import org.pentaho.database.util.DatabaseUtil;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.dataaccess.datasource.api.AnalysisService;
import org.pentaho.platform.dataaccess.datasource.api.DatasourceService;
import org.pentaho.platform.dataaccess.datasource.api.resources.AnalysisResource;
import org.pentaho.platform.dataaccess.datasource.api.resources.DataSourceWizardResource;
import org.pentaho.platform.dataaccess.datasource.api.resources.MetadataResource;
import org.pentaho.platform.dataaccess.datasource.wizard.csv.CsvUtils;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ConnectionServiceImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.StringArrayWrapper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.metadata.PentahoMetadataDomainRepository;
import org.pentaho.platform.web.http.api.resources.JaxbList;
import org.pentaho.ui.database.event.DefaultDatabaseConnectionList;
import org.pentaho.ui.database.event.DefaultDatabaseConnectionPoolParameterList;
import org.pentaho.ui.database.event.IDatabaseConnectionList;
import org.pentaho.ui.database.event.IDatabaseConnectionPoolParameterList;

@Path(value="/data-access/api")
public class DatasourceResource
extends DataSourceWizardResource {
    private static final String XMLA_ENABLED_FLAG = "xmlaEnabledFlag";
    private static final String CATALOG_NAME = "catalogName";
    private static final String ORIG_CATALOG_NAME = "origCatalogName";
    private static final String DATASOURCE_NAME = "datasourceName";
    private static final String UPLOAD_ANALYSIS = "uploadAnalysis";
    private static final String PARAMETERS = "parameters";
    private static final String OVERWRITE_IN_REPOS = "overwrite";
    private static final int SUCCESS = 3;
    private static final Log logger = LogFactory.getLog(DatasourceResource.class);
    private ConnectionServiceImpl connectionService;
    private DatabaseDialectService dialectService;
    GenericDatabaseDialect genericDialect = new GenericDatabaseDialect();
    private static final String LANG = "[a-z]{2}";
    private static final String LANG_CC = "[a-z]{2}_[A-Z]{2}";
    private static final String LANG_CC_EXT = "[a-z]{2}_[A-Z]{2}_[^/]+";
    private static final List<String> ENCODINGS = Arrays.asList("", "UTF-8", "UTF-16BE", "UTF-16LE", "UTF-32BE", "UTF-32LE", "Shift_JIS", "ISO-2022-JP", "ISO-2022-CN", "ISO-2022-KR", "GB18030", "Big5", "EUC-JP", "EUC-KR", "ISO-8859-1", "ISO-8859-2", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "windows-1251", "windows-1256", "KOI8-R", "ISO-8859-9");
    private static final Pattern[] patterns = new Pattern[]{Pattern.compile("([a-z]{2}).properties$"), Pattern.compile("([a-z]{2}_[A-Z]{2}).properties$"), Pattern.compile("([a-z]{2}_[A-Z]{2}_[^/]+).properties$"), Pattern.compile("([^/]+)_([a-z]{2})\\.properties$"), Pattern.compile("([^/]+)_([a-z]{2}_[A-Z]{2})\\.properties$"), Pattern.compile("([^/]+)_([a-z]{2}_[A-Z]{2}_[^/]+)\\.properties$")};
    private static final DatabaseConnectionPoolParameter[] poolingParameters = new DatabaseConnectionPoolParameter[]{new DatabaseConnectionPoolParameter("defaultAutoCommit", "true", "The default auto-commit state of connections created by this pool."), new DatabaseConnectionPoolParameter("defaultReadOnly", null, "The default read-only state of connections created by this pool.\nIf not set then the setReadOnly method will not be called.\n (Some drivers don't support read only mode, ex: Informix)"), new DatabaseConnectionPoolParameter("defaultTransactionIsolation", null, "the default TransactionIsolation state of connections created by this pool. One of the following: (see javadoc)\n\n  * NONE\n  * READ_COMMITTED\n  * READ_UNCOMMITTED\n  * REPEATABLE_READ  * SERIALIZABLE\n"), new DatabaseConnectionPoolParameter("defaultCatalog", null, "The default catalog of connections created by this pool."), new DatabaseConnectionPoolParameter("initialSize", "0", "The initial number of connections that are created when the pool is started."), new DatabaseConnectionPoolParameter("maxActive", "8", "The maximum number of active connections that can be allocated from this pool at the same time, or non-positive for no limit."), new DatabaseConnectionPoolParameter("maxIdle", "8", "The maximum number of connections that can remain idle in the pool, without extra ones being released, or negative for no limit."), new DatabaseConnectionPoolParameter("minIdle", "0", "The minimum number of connections that can remain idle in the pool, without extra ones being created, or zero to create none."), new DatabaseConnectionPoolParameter("maxWait", "-1", "The maximum number of milliseconds that the pool will wait (when there are no available connections) for a connection to be returned before throwing an exception, or -1 to wait indefinitely."), new DatabaseConnectionPoolParameter("validationQuery", null, "The SQL query that will be used to validate connections from this pool before returning them to the caller.\nIf specified, this query MUST be an SQL SELECT statement that returns at least one row."), new DatabaseConnectionPoolParameter("testOnBorrow", "true", "The indication of whether objects will be validated before being borrowed from the pool.\nIf the object fails to validate, it will be dropped from the pool, and we will attempt to borrow another.\nNOTE - for a true value to have any effect, the validationQuery parameter must be set to a non-null string."), new DatabaseConnectionPoolParameter("testOnReturn", "false", "The indication of whether objects will be validated before being returned to the pool.\nNOTE - for a true value to have any effect, the validationQuery parameter must be set to a non-null string."), new DatabaseConnectionPoolParameter("testWhileIdle", "false", "The indication of whether objects will be validated by the idle object evictor (if any). If an object fails to validate, it will be dropped from the pool.\nNOTE - for a true value to have any effect, the validationQuery parameter must be set to a non-null string."), new DatabaseConnectionPoolParameter("timeBetweenEvictionRunsMillis", null, "The number of milliseconds to sleep between runs of the idle object evictor thread. When non-positive, no idle object evictor thread will be run."), new DatabaseConnectionPoolParameter("poolPreparedStatements", "false", "Enable prepared statement pooling for this pool."), new DatabaseConnectionPoolParameter("maxOpenPreparedStatements", "-1", "The maximum number of open statements that can be allocated from the statement pool at the same time, or zero for no limit."), new DatabaseConnectionPoolParameter("accessToUnderlyingConnectionAllowed", "false", "Controls if the PoolGuard allows access to the underlying connection."), new DatabaseConnectionPoolParameter("removeAbandoned", "false", "Flag to remove abandoned connections if they exceed the removeAbandonedTimout.\nIf set to true a connection is considered abandoned and eligible for removal if it has been idle longer than the removeAbandonedTimeout. Setting this to true can recover db connections from poorly written applications which fail to close a connection."), new DatabaseConnectionPoolParameter("removeAbandonedTimeout", "300", "Timeout in seconds before an abandoned connection can be removed."), new DatabaseConnectionPoolParameter("logAbandoned", "false", "Flag to log stack traces for application code which abandoned a Statement or Connection.\nLogging of abandoned Statements and Connections adds overhead for every Connection open or new Statement because a stack trace has to be generated.")};

    public DatasourceResource() {
        this.connectionService = new ConnectionServiceImpl();
        this.dialectService = new DatabaseDialectService(true);
    }

    public JaxbList<String> getAnalysisDatasourceIds() {
        return new AnalysisResource().getSchemaIds();
    }

    public JaxbList<String> getMetadataDatasourceIds() {
        return new MetadataResource().listDomains();
    }

    @GET
    @Path(value="/datasource/dsw/ids")
    @Produces(value={"application/xml", "application/json"})
    @Facet(name="Unsupported")
    public JaxbList<String> getDSWDatasourceIds() {
        return new DataSourceWizardResource().getDSWDIds();
    }

    @Facet(name="Unsupported")
    public Response doGetMetadataFilesAsDownload(@PathParam(value="metadataId") String metadataId) {
        return new MetadataResource().downloadMetadata(metadataId);
    }

    @Facet(name="Unsupported")
    public Response doGetAnalysisFilesAsDownload(@PathParam(value="analysisId") String analysisId) {
        return new AnalysisResource().downloadSchema(analysisId);
    }

    @GET
    @Path(value="/datasource/dsw/{dswId : .+}/download")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="DSW datasource export succeeded."), @ResponseCode(code=401, condition="User is not authorized to export DSW datasource."), @ResponseCode(code=500, condition="Failure to export DSW datasource.")})
    public Response doGetDSWFilesAsDownload(@PathParam(value="dswId") String dswId) {
        return new DataSourceWizardResource().downloadDsw(dswId);
    }

    @POST
    @Path(value="/datasource/dsw/{dswId : .+}/remove")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="DSW datasource removed successfully."), @ResponseCode(code=401, condition="User is not authorized to remove DSW datasource.")})
    @Facet(name="Unsupported")
    public Response doRemoveMetadata(@PathParam(value="dswId") String metadataId) {
        return new DataSourceWizardResource().remove(metadataId);
    }

    @Facet(name="Unsupported")
    public Response doRemoveAnalysis(@PathParam(value="analysisId") String analysisId) {
        return new AnalysisResource().downloadSchema(analysisId);
    }

    @Facet(name="Unsupported")
    public Response doRemoveDSW(@PathParam(value="dswId") String dswId) {
        return new DataSourceWizardResource().remove(dswId);
    }

    @GET
    @Path(value="/datasource/{dswId : .+}/getAnalysisDatasourceInfo")
    @Produces(value={"*/*"})
    @Facet(name="Unsupported")
    public Response getAnalysisDatasourceInfo(@PathParam(value="dswId") String dswId) {
        IMondrianCatalogService mondrianCatalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (IPentahoSession)PentahoSessionHolder.getSession());
        MondrianCatalog catalog = mondrianCatalogService.getCatalog(dswId, PentahoSessionHolder.getSession());
        String parameters = catalog.getDataSourceInfo();
        return Response.ok().entity((Object)parameters).build();
    }

    @PUT
    @Path(value="/mondrian/putSchema")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @Facet(name="Unsupported")
    public Response putMondrianSchema(@FormDataParam(value="uploadAnalysis") InputStream dataInputStream, @FormDataParam(value="uploadAnalysis") FormDataContentDisposition schemaFileInfo, @FormDataParam(value="catalogName") String catalogName, @FormDataParam(value="origCatalogName") String origCatalogName, @FormDataParam(value="datasourceName") String datasourceName, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="xmlaEnabledFlag") String xmlaEnabledFlag, @FormDataParam(value="parameters") String parameters) throws PentahoAccessControlException {
        Response response = null;
        int statusCode = 2;
        try {
            AnalysisService service = new AnalysisService();
            boolean overWriteInRepository = "True".equalsIgnoreCase(overwrite);
            boolean xmlaEnabled = "True".equalsIgnoreCase(xmlaEnabledFlag);
            service.putMondrianSchema(dataInputStream, schemaFileInfo, catalogName, origCatalogName, datasourceName, overWriteInRepository, xmlaEnabled, parameters);
            statusCode = 3;
        }
        catch (PentahoAccessControlException pac) {
            logger.error((Object)pac.getMessage());
            statusCode = 5;
        }
        catch (PlatformImportException pe) {
            statusCode = pe.getErrorStatus();
            logger.error((Object)("Error putMondrianSchema " + pe.getMessage() + " status = " + statusCode));
        }
        catch (Exception e) {
            logger.error((Object)("Error putMondrianSchema " + e.getMessage()));
            statusCode = 2;
        }
        response = Response.ok().status(statusCode).type("text/plain").build();
        logger.debug((Object)("putMondrianSchema Response " + response));
        return response;
    }

    @POST
    @Path(value="/mondrian/postAnalysis")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain", "text/html"})
    @Facet(name="Unsupported")
    public Response postMondrainSchema(@FormDataParam(value="uploadAnalysis") InputStream dataInputStream, @FormDataParam(value="uploadAnalysis") FormDataContentDisposition schemaFileInfo, @FormDataParam(value="catalogName") String catalogName, @FormDataParam(value="origCatalogName") String origCatalogName, @FormDataParam(value="datasourceName") String datasourceName, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="xmlaEnabledFlag") String xmlaEnabledFlag, @FormDataParam(value="parameters") String parameters) throws PentahoAccessControlException {
        Response response = this.putMondrianSchema(dataInputStream, schemaFileInfo, catalogName, origCatalogName, datasourceName, overwrite, xmlaEnabledFlag, parameters);
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder.entity((Object)String.valueOf(response.getStatus()));
        responseBuilder.status(200);
        return responseBuilder.build();
    }

    @POST
    @Path(value="/metadata/postimport")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @Facet(name="Unsupported")
    public Response importMetadataDatasourceWithPost(@FormDataParam(value="domainId") String domainId, @FormDataParam(value="metadataFile") InputStream metadataFile, @FormDataParam(value="metadataFile") FormDataContentDisposition metadataFileInfo, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="localeFiles") List<FormDataBodyPart> localeFiles, @FormDataParam(value="localeFiles") List<FormDataContentDisposition> localeFilesInfo) throws PentahoAccessControlException {
        Response response = this.importMetadataDatasource(domainId, metadataFile, metadataFileInfo, overwrite, localeFiles, localeFilesInfo);
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder.entity((Object)String.valueOf(response.getStatus()));
        responseBuilder.status(200);
        return responseBuilder.build();
    }

    @PUT
    @Path(value="/metadata/import")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @Deprecated
    @Facet(name="Unsupported")
    public Response importMetadataDatasource(@FormDataParam(value="domainId") String domainId, @FormDataParam(value="metadataFile") InputStream metadataFile, @FormDataParam(value="metadataFile") FormDataContentDisposition metadataFileInfo, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="localeFiles") List<FormDataBodyPart> localeFiles, @FormDataParam(value="localeFiles") List<FormDataContentDisposition> localeFilesInfo) {
        return new MetadataResource().importMetadataDatasourceLegacy(domainId, metadataFile, metadataFileInfo, overwrite, localeFiles, localeFilesInfo);
    }

    @PUT
    @Path(value="/metadata/uploadServletImport")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Deprecated
    @Facet(name="Unsupported")
    public Response uploadServletImportMetadataDatasource(String localizeBundleEntries, @QueryParam(value="domainId") String domainId, @QueryParam(value="metadataFile") String metadataFile) throws PentahoAccessControlException {
        try {
            DatasourceService.validateAccess();
        }
        catch (PentahoAccessControlException e) {
            return Response.serverError().entity((Object)e.toString()).build();
        }
        IMetadataDomainRepository metadataDomainRepository = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, (IPentahoSession)PentahoSessionHolder.getSession());
        PentahoMetadataDomainRepository metadataImporter = new PentahoMetadataDomainRepository((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
        CsvUtils csvUtils = new CsvUtils();
        boolean validPropertyFiles = true;
        StringBuffer invalidFiles = new StringBuffer();
        try {
            String TMP_FILE_PATH = File.separatorChar + "system" + File.separatorChar + "tmp" + File.separatorChar;
            String sysTmpDir = PentahoSystem.getApplicationContext().getSolutionPath(TMP_FILE_PATH);
            FileInputStream metadataInputStream = new FileInputStream(sysTmpDir + File.separatorChar + metadataFile);
            metadataImporter.storeDomain((InputStream)metadataInputStream, domainId, true);
            metadataDomainRepository.getDomain(domainId);
            StringTokenizer bundleEntriesParam = new StringTokenizer(localizeBundleEntries, ";");
            block4: while (bundleEntriesParam.hasMoreTokens()) {
                String localizationBundleElement = bundleEntriesParam.nextToken();
                StringTokenizer localizationBundle = new StringTokenizer(localizationBundleElement, "=");
                String localizationFileName = localizationBundle.nextToken();
                String localizationFile = localizationBundle.nextToken();
                if (localizationFileName.endsWith(".properties")) {
                    String encoding = csvUtils.getEncoding(localizationFile);
                    if (ENCODINGS.contains(encoding)) {
                        for (Pattern propertyBundlePattern : patterns) {
                            Matcher propertyBundleMatcher = propertyBundlePattern.matcher(localizationFileName);
                            if (!propertyBundleMatcher.matches()) continue;
                            FileInputStream bundleFileInputStream = new FileInputStream(sysTmpDir + File.separatorChar + localizationFile);
                            metadataImporter.addLocalizationFile(domainId, propertyBundleMatcher.group(2), (InputStream)bundleFileInputStream, true);
                            continue block4;
                        }
                        continue;
                    }
                    validPropertyFiles = false;
                    invalidFiles.append(localizationFileName);
                    continue;
                }
                validPropertyFiles = false;
                invalidFiles.append(localizationFileName);
            }
            if (!validPropertyFiles) {
                return Response.serverError().entity((Object)(Messages.getString("MetadataDatasourceService.ERROR_002_PROPERTY_FILES_ERROR") + invalidFiles.toString())).build();
            }
            return Response.ok((Object)"SUCCESS").type("text/plain").build();
        }
        catch (Exception e) {
            metadataImporter.removeDomain(domainId);
            return Response.serverError().entity((Object)Messages.getString("MetadataDatasourceService.ERROR_001_METADATA_DATASOURCE_ERROR")).build();
        }
    }

    @PUT
    @Path(value="/metadata/storeDomain")
    @Consumes(value={"application/octet-stream", "text/plain"})
    @Produces(value={"text/plain"})
    @Facet(name="Unsupported")
    public Response storeDomain(InputStream metadataFile, @QueryParam(value="domainId") String domainId) throws PentahoAccessControlException {
        try {
            DatasourceService.validateAccess();
            PentahoMetadataDomainRepository metadataImporter = new PentahoMetadataDomainRepository((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
            metadataImporter.storeDomain(metadataFile, domainId, true);
            return Response.ok((Object)"SUCCESS").type("text/plain").build();
        }
        catch (PentahoAccessControlException e) {
            return Response.serverError().entity((Object)e.toString()).build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)Messages.getString("MetadataDatasourceService.ERROR_001_METADATA_DATASOURCE_ERROR")).build();
        }
    }

    @PUT
    @Path(value="/metadata/addLocalizationFile")
    @Consumes(value={"application/octet-stream", "text/plain"})
    @Produces(value={"text/plain"})
    @Facet(name="Unsupported")
    public Response addLocalizationFile(@QueryParam(value="domainId") String domainId, @QueryParam(value="locale") String locale, InputStream propertiesFile) throws PentahoAccessControlException {
        try {
            DatasourceService.validateAccess();
            PentahoMetadataDomainRepository metadataImporter = new PentahoMetadataDomainRepository((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
            metadataImporter.addLocalizationFile(domainId, locale, propertiesFile, true);
            return Response.ok((Object)"SUCCESS").type("text/plain").build();
        }
        catch (PentahoAccessControlException e) {
            return Response.serverError().entity((Object)e.toString()).build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)Messages.getString("MetadataDatasourceService.ERROR_001_METADATA_DATASOURCE_ERROR")).build();
        }
    }

    @GET
    @Path(value="/connection/list")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public IDatabaseConnectionList getConnections() throws ConnectionServiceException {
        DefaultDatabaseConnectionList databaseConnections = new DefaultDatabaseConnectionList();
        List<IDatabaseConnection> conns = this.connectionService.getConnections();
        for (IDatabaseConnection conn : conns) {
            this.hidePassword(conn);
        }
        databaseConnections.setDatabaseConnections(conns);
        return databaseConnections;
    }

    @GET
    @Path(value="/connection/get")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public IDatabaseConnection getConnectionByName(@QueryParam(value="name") String name) throws ConnectionServiceException {
        IDatabaseConnection conn = this.connectionService.getConnectionByName(name);
        this.hidePassword(conn);
        return conn;
    }

    @GET
    @Path(value="/connection/checkexists")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public Response isConnectionExist(@QueryParam(value="name") String name) throws ConnectionServiceException {
        boolean exists = this.connectionService.isConnectionExist(name);
        try {
            if (exists) {
                return Response.ok().build();
            }
            return Response.notModified().build();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/connection/getresponse")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public Response getConnectionByNameWithResponse(@QueryParam(value="name") String name) throws ConnectionServiceException {
        Response response;
        IDatabaseConnection conn = null;
        try {
            conn = this.connectionService.getConnectionByName(name);
            this.hidePassword(conn);
            response = Response.ok().entity((Object)conn).build();
        }
        catch (Exception ex) {
            response = Response.serverError().entity((Object)ex.getMessage()).build();
        }
        return response;
    }

    @POST
    @Path(value="/connection/add")
    @Consumes(value={"application/json"})
    @Facet(name="Unsupported")
    public Response addConnection(DatabaseConnection connection) throws ConnectionServiceException {
        try {
            this.validateAccess();
            boolean success = this.connectionService.addConnection((IDatabaseConnection)connection);
            if (success) {
                return Response.ok().build();
            }
            return Response.notModified().build();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/connection/update")
    @Consumes(value={"application/json"})
    @Facet(name="Unsupported")
    public Response updateConnection(DatabaseConnection connection) throws ConnectionServiceException {
        try {
            this.applySavedPassword((IDatabaseConnection)connection);
            boolean success = this.connectionService.updateConnection((IDatabaseConnection)connection);
            if (success) {
                return Response.ok().build();
            }
            return Response.notModified().build();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="/connection/delete")
    @Consumes(value={"application/json"})
    @Facet(name="Unsupported")
    public Response deleteConnection(DatabaseConnection connection) throws ConnectionServiceException {
        try {
            boolean success = this.connectionService.deleteConnection((IDatabaseConnection)connection);
            if (success) {
                return Response.ok().build();
            }
            return Response.notModified().build();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="/connection/deletebyname")
    public Response deleteConnectionByName(@QueryParam(value="name") String name) throws ConnectionServiceException {
        try {
            boolean success = this.connectionService.deleteConnection(name);
            if (success) {
                return Response.ok().build();
            }
            return Response.notModified().build();
        }
        catch (Throwable t) {
            return Response.serverError().build();
        }
    }

    @PUT
    @Path(value="/connection/test")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @Facet(name="Unsupported")
    public Response testConnection(DatabaseConnection connection) throws ConnectionServiceException {
        boolean success = false;
        this.applySavedPassword((IDatabaseConnection)connection);
        success = this.connectionService.testConnection((IDatabaseConnection)connection);
        if (success) {
            return Response.ok((Object)Messages.getString("ConnectionServiceImpl.INFO_0001_CONNECTION_SUCCEED", connection.getDatabaseName())).build();
        }
        return Response.serverError().entity((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0009_CONNECTION_FAILED", connection.getDatabaseName())).build();
    }

    @GET
    @Path(value="/connection/poolingParameters")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public IDatabaseConnectionPoolParameterList getPoolingParameters() {
        DefaultDatabaseConnectionPoolParameterList value = new DefaultDatabaseConnectionPoolParameterList();
        ArrayList<DatabaseConnectionPoolParameter> paramList = new ArrayList<DatabaseConnectionPoolParameter>();
        for (DatabaseConnectionPoolParameter param : poolingParameters) {
            paramList.add(param);
        }
        value.setDatabaseConnectionPoolParameters(paramList);
        return value;
    }

    @GET
    @Path(value="/connection/createDatabaseConnection")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public IDatabaseConnection createDatabaseConnection(@QueryParam(value="driver") String driver, @QueryParam(value="url") String url) {
        for (IDatabaseDialect dialect : this.dialectService.getDatabaseDialects()) {
            if (dialect.getNativeDriver() == null || !dialect.getNativeDriver().equals(driver) || dialect.getNativeJdbcPre() == null || !url.startsWith(dialect.getNativeJdbcPre())) continue;
            return dialect.createNativeConnection(url);
        }
        IDatabaseConnection conn = this.genericDialect.createNativeConnection(url);
        conn.getAttributes().put("CUSTOM_DRIVER_CLASS", driver);
        return conn;
    }

    @POST
    @Path(value="/connection/checkParams")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public StringArrayWrapper checkParameters(DatabaseConnection connection) {
        StringArrayWrapper array = null;
        String[] rawValues = DatabaseUtil.convertToDatabaseMeta((IDatabaseConnection)connection).checkParameters();
        if (rawValues.length > 0) {
            array = new StringArrayWrapper();
            array.setArray(rawValues);
        }
        return array;
    }

    private void validateAccess() throws PentahoAccessControlException {
        boolean isAdmin;
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        boolean bl = isAdmin = policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && (policy.isAllowed("org.pentaho.security.administerSecurity") || policy.isAllowed("org.pentaho.security.publish"));
        if (!isAdmin) {
            throw new PentahoAccessControlException("Access Denied");
        }
    }

    private void hidePassword(IDatabaseConnection conn) {
        conn.setPassword(null);
    }

    private void applySavedPassword(IDatabaseConnection conn) throws ConnectionServiceException {
        if (StringUtils.isBlank((String)conn.getPassword())) {
            IDatabaseConnection savedConn;
            if (conn.getId() != null) {
                savedConn = this.connectionService.getConnectionById(conn.getId());
            } else {
                try {
                    savedConn = this.connectionService.getConnectionByName(conn.getName());
                }
                catch (ConnectionServiceException e) {
                    logger.warn((Object)e.getMessage());
                    savedConn = null;
                }
            }
            if (savedConn != null) {
                conn.setPassword(savedConn.getPassword());
            }
        }
    }

    @GET
    @Path(value="/connection/getid")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public Response getConnectionIdByNameWithResponse(@QueryParam(value="name") String name) throws ConnectionServiceException {
        Response response;
        IDatabaseConnection conn = null;
        try {
            conn = this.connectionService.getConnectionByName(name);
            response = conn != null ? Response.ok().entity((Object)conn.getId()).build() : Response.notModified().build();
        }
        catch (Exception ex) {
            response = Response.serverError().entity((Object)ex.getMessage()).build();
        }
        return response;
    }
}

