/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Element;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.XMLParser;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.gwt.widgets.client.utils.NameUtils;
import org.pentaho.gwt.widgets.login.client.AuthenticatedGwtServiceUtil;
import org.pentaho.gwt.widgets.login.client.IAuthenticatedGwtCommand;
import org.pentaho.platform.dataaccess.datasource.IDatasourceInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncDatasourceServiceManager;
import org.pentaho.ui.xul.XulServiceCallback;

public class DatasourceServiceManagerGwtImpl
implements IXulAsyncDatasourceServiceManager {
    String getAnalysisDatasourceIdsURL = this.getWebAppRoot() + "plugin/data-access/api/datasource/analysis/ids";
    String getMetadataDatasourceIdsURL = this.getWebAppRoot() + "plugin/data-access/api/datasource/metadata/ids";
    String getDSWDatasourceIdsURL = this.getWebAppRoot() + "plugin/data-access/api/datasource/dsw/ids";
    String isAdminURL = this.getWebAppRoot() + "api/repo/files/canAdminister";

    @Override
    public void getAnalysisDatasourceIds(final XulServiceCallback<List<String>> xulCallback) {
        AuthenticatedGwtServiceUtil.invokeCommand((IAuthenticatedGwtCommand)new IAuthenticatedGwtCommand(){

            public void execute(final AsyncCallback callback) {
                String cacheBuster = "?ts=" + new Date().getTime();
                RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, DatasourceServiceManagerGwtImpl.this.getAnalysisDatasourceIdsURL + cacheBuster);
                try {
                    requestBuilder.sendRequest(null, new RequestCallback(){

                        public void onError(Request request, Throwable exception) {
                            callback.onFailure(exception);
                        }

                        public void onResponseReceived(Request request, Response response) {
                            if (response.getStatusCode() == 200) {
                                callback.onSuccess((Object)DatasourceServiceManagerGwtImpl.this.convertReponseToList(response));
                            }
                        }
                    });
                }
                catch (RequestException e) {
                    xulCallback.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }, (AsyncCallback)new AsyncCallback<List<String>>(){

            public void onFailure(Throwable arg0) {
                xulCallback.error(arg0.getLocalizedMessage(), arg0);
            }

            public void onSuccess(List<String> arg0) {
                xulCallback.success(arg0);
            }
        });
    }

    @Override
    public void getMetadataDatasourceIds(final XulServiceCallback<List<String>> xulCallback) {
        AuthenticatedGwtServiceUtil.invokeCommand((IAuthenticatedGwtCommand)new IAuthenticatedGwtCommand(){

            public void execute(final AsyncCallback callback) {
                String cacheBuster = "?ts=" + new Date().getTime();
                RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, DatasourceServiceManagerGwtImpl.this.getMetadataDatasourceIdsURL + cacheBuster);
                try {
                    requestBuilder.sendRequest(null, new RequestCallback(){

                        public void onError(Request request, Throwable exception) {
                            callback.onFailure(exception);
                        }

                        public void onResponseReceived(Request request, Response response) {
                            if (response.getStatusCode() == 200) {
                                callback.onSuccess((Object)DatasourceServiceManagerGwtImpl.this.convertReponseToList(response));
                            }
                        }
                    });
                }
                catch (RequestException e) {
                    xulCallback.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }, (AsyncCallback)new AsyncCallback<List<String>>(){

            public void onFailure(Throwable arg0) {
                xulCallback.error(arg0.getLocalizedMessage(), arg0);
            }

            public void onSuccess(List<String> arg0) {
                xulCallback.success(arg0);
            }
        });
    }

    @Override
    public void isAdmin(final XulServiceCallback<Boolean> xulCallback) {
        AuthenticatedGwtServiceUtil.invokeCommand((IAuthenticatedGwtCommand)new IAuthenticatedGwtCommand(){

            public void execute(final AsyncCallback callback) {
                RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, DatasourceServiceManagerGwtImpl.this.isAdminURL);
                try {
                    requestBuilder.sendRequest(null, new RequestCallback(){

                        public void onError(Request request, Throwable exception) {
                            callback.onFailure(exception);
                        }

                        public void onResponseReceived(Request request, Response response) {
                            if (response.getStatusCode() == 200) {
                                callback.onSuccess((Object)Boolean.parseBoolean(response.getText()));
                            }
                        }
                    });
                }
                catch (RequestException e) {
                    xulCallback.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }, (AsyncCallback)new AsyncCallback<Boolean>(){

            public void onFailure(Throwable arg0) {
                xulCallback.error(arg0.getLocalizedMessage(), arg0);
            }

            public void onSuccess(Boolean arg0) {
                xulCallback.success((Object)arg0);
            }
        });
    }

    public native String getWebAppRoot();

    private List<String> convertReponseToList(Response response) {
        ArrayList<String> dataList = new ArrayList<String>();
        Document document = XMLParser.parse((String)response.getText());
        Element element = document.getDocumentElement();
        Node node = element.getFirstChild();
        boolean done = false;
        do {
            try {
                dataList.add(this.getNodeValueByTagName(node, "Item"));
                Node node2 = node = node.getNextSibling() != null ? node.getNextSibling() : null;
                if (node != null) continue;
                done = true;
            }
            catch (Exception e) {
                done = true;
            }
        } while (!done);
        return dataList;
    }

    private String getNodeValueByTagName(Node node, String tagName) {
        if (node != null && node.getFirstChild() != null) {
            return node.getFirstChild().getNodeValue();
        }
        return null;
    }

    @Override
    public void getDSWDatasourceIds(final XulServiceCallback<List<String>> xulCallback) {
        AuthenticatedGwtServiceUtil.invokeCommand((IAuthenticatedGwtCommand)new IAuthenticatedGwtCommand(){

            public void execute(final AsyncCallback callback) {
                String cacheBuster = "?ts=" + new Date().getTime();
                RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, DatasourceServiceManagerGwtImpl.this.getDSWDatasourceIdsURL + cacheBuster);
                try {
                    requestBuilder.sendRequest(null, new RequestCallback(){

                        public void onError(Request request, Throwable exception) {
                            callback.onFailure(exception);
                        }

                        public void onResponseReceived(Request request, Response response) {
                            if (response.getStatusCode() == 200) {
                                callback.onSuccess((Object)DatasourceServiceManagerGwtImpl.this.convertReponseToList(response));
                            }
                        }
                    });
                }
                catch (RequestException e) {
                    xulCallback.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }, (AsyncCallback)new AsyncCallback<List<String>>(){

            public void onFailure(Throwable arg0) {
                xulCallback.error(arg0.getLocalizedMessage(), arg0);
            }

            public void onSuccess(List<String> arg0) {
                xulCallback.success(arg0);
            }
        });
    }

    @Override
    public void export(IDatasourceInfo dsInfo) {
        String exportURL = null;
        String datasourceId = NameUtils.URLEncode((String)dsInfo.getId());
        if (dsInfo.getType() == "Metadata") {
            exportURL = this.getWebAppRoot() + "plugin/data-access/api/datasource/metadata/" + datasourceId + "/download";
        } else if (dsInfo.getType() == "Analysis") {
            exportURL = this.getWebAppRoot() + "plugin/data-access/api/datasource/analysis/" + datasourceId + "/download";
        } else if (dsInfo.getType() == "Data Source Wizard") {
            exportURL = this.getWebAppRoot() + "plugin/data-access/api/datasource/dsw/" + datasourceId + "/download";
        }
        Window.open(exportURL, (String)"_new", (String)"");
    }

    @Override
    public void remove(IDatasourceInfo dsInfo, final Object xulCallback) {
        String datasourceId = NameUtils.URLEncode((String)dsInfo.getId());
        final String removeURL = dsInfo.getType() == "Metadata" ? this.getWebAppRoot() + "plugin/data-access/api/datasource/metadata/" + datasourceId + "/remove" : (dsInfo.getType() == "Analysis" ? this.getWebAppRoot() + "plugin/data-access/api/datasource/analysis/" + datasourceId + "/remove" : (dsInfo.getType() == "Data Source Wizard" ? this.getWebAppRoot() + "plugin/data-access/api/datasource/dsw/" + datasourceId + "/remove" : null));
        AuthenticatedGwtServiceUtil.invokeCommand((IAuthenticatedGwtCommand)new IAuthenticatedGwtCommand<Boolean>(){

            public void execute(final AsyncCallback<Boolean> callback) {
                RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, removeURL);
                try {
                    requestBuilder.sendRequest(null, new RequestCallback(){

                        public void onError(Request request, Throwable exception) {
                            callback.onFailure(exception);
                        }

                        public void onResponseReceived(Request request, Response response) {
                            callback.onSuccess((Object)(response.getStatusCode() == 200 ? 1 : 0));
                        }
                    });
                }
                catch (RequestException e) {
                    XulServiceCallback responseCallback = (XulServiceCallback)xulCallback;
                    responseCallback.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }, (AsyncCallback)new AsyncCallback<Boolean>(){

            public void onFailure(Throwable e) {
                XulServiceCallback responseCallback = (XulServiceCallback)xulCallback;
                responseCallback.error(e.getLocalizedMessage(), e);
            }

            public void onSuccess(Boolean arg) {
                XulServiceCallback responseCallback = (XulServiceCallback)xulCallback;
                responseCallback.success((Object)arg);
            }
        });
    }
}

