/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import java.io.File;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.gwt.GwtModelerWorkspaceHelper;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.agile.AgileHelper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.DSWDatasourceServiceImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ModelerService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.PentahoSystemHelper;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class DebugModelerService
extends ModelerService {
    private IPentahoSession getSession() {
        IPentahoSession session = null;
        IPentahoObjectFactory pentahoObjectFactory = PentahoSystem.getObjectFactory();
        if (pentahoObjectFactory != null) {
            try {
                session = (IPentahoSession)pentahoObjectFactory.get(IPentahoSession.class, "systemStartupSession", null);
            }
            catch (ObjectFactoryException e) {
                e.printStackTrace();
            }
        }
        return session;
    }

    @Override
    public String serializeModels(Domain domain, String name) throws Exception {
        String domainId;
        PentahoSystemHelper.init();
        this.initKettle();
        try {
            File pathDir;
            DSWDatasourceServiceImpl datasourceService = new DSWDatasourceServiceImpl();
            ModelerWorkspace model = new ModelerWorkspace((IModelerWorkspaceHelper)new GwtModelerWorkspaceHelper(), datasourceService.getGeoContext());
            model.setModelName(name);
            model.setDomain(domain);
            String solutionStorage = AgileHelper.getDatasourceSolutionStorage();
            String metadataLocation = "resources/metadata";
            String path = solutionStorage + "/" + metadataLocation + "/";
            domainId = path + name + ".xmi";
            IApplicationContext appContext = PentahoSystem.getApplicationContext();
            if (appContext != null) {
                path = PentahoSystem.getApplicationContext().getSolutionPath(path);
            }
            if (!(pathDir = new File(path)).exists()) {
                pathDir.mkdirs();
            }
            IPentahoSession session = this.getSession();
            model.getWorkspaceHelper().populateDomain(model);
            LogicalModel lModel = (LogicalModel)domain.getLogicalModels().get(0);
            String catName = lModel.getName("en_US");
            lModel.setProperty("MondrianCatalogRef", (Object)catName);
            File file = new File(path + name + ".mondrian.xml");
            String catConnectStr = "Provider=mondrian;DataSource=" + ((SqlPhysicalModel)domain.getPhysicalModels().get(0)).getId();
            String catDef = "solution:" + solutionStorage + "/" + "resources" + "/" + "metadata" + "/" + file.getName();
            this.addCatalog(catName, catConnectStr, catDef, session);
        }
        catch (Exception e) {
            this.getLogger().error((Object)e);
            throw e;
        }
        return domainId;
    }

    private void addCatalog(String catName, String catConnectStr, String catDef, IPentahoSession session) {
    }
}

