/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Element;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.platform.dataaccess.datasource.DatasourceInfo;
import org.pentaho.platform.dataaccess.datasource.IDatasourceInfo;

public class XMLToDatasourceInfoConverter {
    private String xml;

    public XMLToDatasourceInfoConverter(String xml) {
        this.xml = xml;
    }

    public List<IDatasourceInfo> convert() {
        Document document = this.getXMLDocumentFromString(this.xml);
        return this.getDatasourceInfoList(document.getDocumentElement());
    }

    private List<IDatasourceInfo> getDatasourceInfoList(Element element) {
        ArrayList<IDatasourceInfo> datasourceInfoList = new ArrayList<IDatasourceInfo>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element ele = (Element)nodeList.item(i);
            boolean editable = Boolean.parseBoolean(this.getNodeValueByTagName(ele, "editable"));
            boolean removable = Boolean.parseBoolean(this.getNodeValueByTagName(ele, "removable"));
            boolean importable = Boolean.parseBoolean(this.getNodeValueByTagName(ele, "importable"));
            boolean exportable = Boolean.parseBoolean(this.getNodeValueByTagName(ele, "exportable"));
            DatasourceInfo info = new DatasourceInfo(this.getName(ele), this.getId(ele), this.getType(ele), editable, removable, importable, exportable);
            datasourceInfoList.add(info);
        }
        return datasourceInfoList;
    }

    private Node getNodeByTagName(Element element, String tagName) {
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node == null || !node.getNodeName().equals(tagName)) continue;
            return node;
        }
        return null;
    }

    private final String getType(Element element) {
        return this.getNodeValueByTagName(element, "type");
    }

    private final String getId(Element element) {
        return this.getNodeValueByTagName(element, "id");
    }

    private final String getName(Element element) {
        return this.getNodeValueByTagName(element, "name");
    }

    private Document getXMLDocumentFromString(String xmlText) {
        return XMLParser.parse((String)xmlText);
    }

    private String getNodeValueByTagName(Element element, String tagName) {
        Node node = this.getNodeByTagName(element, tagName);
        if (node != null && node.getFirstChild() != null) {
            return node.getFirstChild().getNodeValue();
        }
        return null;
    }
}

