/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.geo.GeoContext;
import org.pentaho.agilebi.modeler.geo.GeoContextConfigProvider;
import org.pentaho.agilebi.modeler.geo.GeoContextFactory;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.marshal.MarshallableResultSet;
import org.pentaho.commons.connection.marshal.MarshallableRow;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.commons.connection.memory.MemoryResultSet;
import org.pentaho.metadata.query.model.util.CsvDataReader;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.dataaccess.datasource.beans.SerializedResultSet;
import org.pentaho.platform.dataaccess.datasource.wizard.service.DatasourceServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.GeoContextSettingsProvider;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.services.connection.PentahoConnectionFactory;
import org.pentaho.platform.plugin.services.connections.sql.SQLConnection;
import org.pentaho.platform.plugin.services.connections.sql.SQLMetaData;
import org.pentaho.platform.util.logging.SimpleLogger;

public class DatasourceServiceHelper {
    private static final Log logger = LogFactory.getLog(DatasourceServiceHelper.class);
    private static final String PLUGIN_NAME = "data-access";
    private static final String SETTINGS_FILE = "data-access/settings.xml";
    private static GeoContextConfigProvider configProvider = new GeoContextSettingsProvider("data-access/settings.xml");

    public static Connection getDataSourceConnection(String connectionName, IPentahoSession session) {
        SQLConnection sqlConnection = (SQLConnection)PentahoConnectionFactory.getConnection((String)"SQL", (String)connectionName, (IPentahoSession)session, (ILogger)new SimpleLogger(DatasourceServiceHelper.class.getName()));
        return sqlConnection.getNativeConnection();
    }

    public static SerializedResultSet getSerializeableResultSet(String connectionName, String query, int rowLimit, IPentahoSession session) throws DatasourceServiceException {
        SerializedResultSet serializedResultSet = null;
        SQLConnection sqlConnection = null;
        try {
            sqlConnection = (SQLConnection)PentahoConnectionFactory.getConnection((String)"SQL", (String)connectionName, (IPentahoSession)PentahoSessionHolder.getSession(), null);
            sqlConnection.setMaxRows(rowLimit);
            sqlConnection.setReadOnly(true);
            IPentahoResultSet resultSet = sqlConnection.executeQuery(query);
            logger.debug((Object)"ResultSet is not scrollable. Copying into memory");
            if (!resultSet.isScrollable()) {
                resultSet = DatasourceServiceHelper.convertToMemoryResultSet(resultSet);
            }
            MarshallableResultSet marshallableResultSet = new MarshallableResultSet();
            marshallableResultSet.setResultSet(resultSet);
            IPentahoMetaData ipmd = resultSet.getMetaData();
            int[] columnTypes = null;
            if (ipmd instanceof SQLMetaData) {
                SQLMetaData smd = (SQLMetaData)ipmd;
                columnTypes = smd.getJDBCColumnTypes();
            } else if (ipmd instanceof MemoryMetaData) {
                MemoryMetaData mmd = (MemoryMetaData)ipmd;
                String[] columnTypesAsString = mmd.getColumnTypes();
                columnTypes = new int[columnTypesAsString.length];
                for (int i = 0; i < columnTypesAsString.length; ++i) {
                    columnTypes[i] = Integer.parseInt(columnTypesAsString[i]);
                }
            }
            if (columnTypes != null) {
                ArrayList<List<String>> data = new ArrayList<List<String>>();
                for (MarshallableRow row : marshallableResultSet.getRows()) {
                    String[] rowData = row.getCell();
                    ArrayList<String> rowDataList = new ArrayList<String>(rowData.length);
                    for (int j = 0; j < rowData.length; ++j) {
                        rowDataList.add(rowData[j]);
                    }
                    data.add(rowDataList);
                }
                serializedResultSet = new SerializedResultSet(columnTypes, marshallableResultSet.getColumnNames().getColumnName(), data);
            }
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceHelper.ERROR_0001_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), (Throwable)e);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceHelper.ERROR_0001_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), e);
        }
        finally {
            if (sqlConnection != null) {
                sqlConnection.close();
            }
        }
        return serializedResultSet;
    }

    public static List<List<String>> getCsvDataSample(String fileLocation, boolean headerPresent, String delimiter, String enclosure, int rowLimit) {
        CsvDataReader reader = new CsvDataReader(fileLocation, headerPresent, delimiter, enclosure, rowLimit);
        return reader.loadData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IPentahoResultSet convertToMemoryResultSet(IPentahoResultSet resultSet) throws SQLException {
        MemoryResultSet cachedResultSet = null;
        try {
            IPentahoMetaData meta = resultSet.getMetaData();
            Object[][] columnHeaders = meta.getColumnHeaders();
            MemoryMetaData cachedMetaData = new MemoryMetaData(columnHeaders, (Object[][])null);
            if (meta instanceof SQLMetaData) {
                SQLMetaData sqlMeta = (SQLMetaData)meta;
                int[] colTypes = sqlMeta.getJDBCColumnTypes();
                String[] colTypesAsString = new String[colTypes.length];
                for (int i = 0; i < colTypes.length; ++i) {
                    colTypesAsString[i] = Integer.toString(colTypes[i]);
                }
                cachedMetaData.setColumnTypes(colTypesAsString);
            }
            cachedResultSet = new MemoryResultSet((IPentahoMetaData)cachedMetaData);
            Object[] rowObjects = resultSet.next();
            while (rowObjects != null) {
                cachedResultSet.addRow(rowObjects);
                rowObjects = resultSet.next();
            }
        }
        finally {
            resultSet.close();
        }
        return cachedResultSet;
    }

    public static GeoContext getGeoContext() throws DatasourceServiceException {
        try {
            GeoContext geo = GeoContextFactory.create((GeoContextConfigProvider)configProvider);
            return geo;
        }
        catch (ModelerException e) {
            throw new DatasourceServiceException(e);
        }
    }
}

