/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk;

import com.sun.jersey.api.representation.Form;
import com.sun.jersey.spi.container.ContainerRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.dom4j.DocumentException;
import pt.webdetails.cpf.plugins.IPluginFilter;
import pt.webdetails.cpf.plugins.Plugin;
import pt.webdetails.cpf.plugins.PluginsAnalyzer;
import pt.webdetails.cpf.utils.CharsetHelper;
import pt.webdetails.cpf.utils.IPluginUtils;
import pt.webdetails.cpf.utils.PluginUtils;
import pt.webdetails.cpk.CpkCoreService;
import pt.webdetails.cpk.CpkEngine;
import pt.webdetails.cpk.CpkPentahoEnvironment;
import pt.webdetails.cpk.ICpkEnvironment;
import pt.webdetails.cpk.datasources.DataSource;
import pt.webdetails.cpk.elements.IDataSourceProvider;
import pt.webdetails.cpk.elements.IElement;
import pt.webdetails.cpk.sitemap.LinkGenerator;
import pt.webdetails.cpk.utils.CpkUtils;

@Path(value="/{pluginId}/api")
public class CpkApi {
    private static final Log logger = LogFactory.getLog(CpkApi.class);
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final String DEFAULT_NO_DASHBOARD_MESSAGE = "This plugin does not contain a dashboard";
    private static final String[] reservedWords = new String[]{"ping", "default", "reload", "refresh", "version", "status", "getSitemapJson", "elementsList", "listDataAccessTypes", "reloadPlugins"};
    protected CpkCoreService coreService;
    protected ICpkEnvironment cpkEnv;
    static final ObjectMapper mapper = new ObjectMapper();

    public CpkApi() {
        this.init();
    }

    protected void init() {
        this.cpkEnv = new CpkPentahoEnvironment((IPluginUtils)new PluginUtils(), reservedWords);
        this.coreService = new CpkCoreService(this.cpkEnv);
    }

    protected static String getEncoding() {
        return CharsetHelper.getEncoding();
    }

    @GET
    @Path(value="/{param}")
    public void genericEndpointGet(@PathParam(value="param") String param, @Context HttpServletRequest request, @Context HttpServletResponse response, @Context HttpHeaders headers) throws Exception {
        this.callEndpoint(param, request, response, headers);
    }

    @POST
    @Path(value="/{param}")
    public void genericEndpointPost(@PathParam(value="param") String param, @Context HttpServletRequest request, @Context HttpServletResponse response, @Context HttpHeaders headers) throws Exception {
        this.callEndpoint(param, request, response, headers);
    }

    @GET
    @Path(value="/ping")
    public String ping() {
        return "Pong: I was called from " + this.cpkEnv.getPluginName();
    }

    @GET
    @Path(value="/default")
    public void defaultElement(@Context HttpServletResponse response) throws IOException {
        IElement defaultElement = this.coreService.getDefaultElement();
        if (defaultElement != null) {
            CpkUtils.redirect((HttpServletResponse)response, (String)defaultElement.getId());
        } else {
            response.getOutputStream().write(DEFAULT_NO_DASHBOARD_MESSAGE.getBytes(CpkApi.getEncoding()));
            response.getOutputStream().flush();
        }
    }

    @GET
    @Path(value="/reload")
    public void reload(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context HttpHeaders headers) throws DocumentException, IOException {
        this.coreService.reload((OutputStream)response.getOutputStream(), this.buildBloatedMap(request, response, headers));
    }

    @GET
    @Path(value="/refresh")
    @Produces(value={"text/plain"})
    public void refreshGet(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context HttpHeaders headers) throws DocumentException, IOException {
        this.refresh(request, response, headers);
    }

    @POST
    @Path(value="/refresh")
    @Produces(value={"text/plain"})
    public void refreshPost(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context HttpHeaders headers) throws DocumentException, IOException {
        this.refresh(request, response, headers);
    }

    private void refresh(HttpServletRequest request, HttpServletResponse response, HttpHeaders headers) throws IOException, DocumentException {
        this.coreService.refresh((OutputStream)response.getOutputStream(), this.buildBloatedMap(request, response, headers));
        response.getOutputStream().flush();
    }

    @GET
    @Path(value="/version")
    @Produces(value={"text/plain"})
    public void version(@PathParam(value="pluginId") String pluginId, @Context HttpServletResponse response) throws IOException {
        PluginsAnalyzer pluginsAnalyzer = new PluginsAnalyzer();
        pluginsAnalyzer.refresh();
        String version = null;
        IPluginFilter thisPlugin = new IPluginFilter(){

            public boolean include(Plugin plugin) {
                return plugin.getId().equalsIgnoreCase(CpkApi.this.cpkEnv.getPluginName());
            }
        };
        List plugins = pluginsAnalyzer.getPlugins(thisPlugin);
        version = ((Plugin)plugins.get(0)).getVersion().toString();
        this.writeMessage((OutputStream)response.getOutputStream(), version);
    }

    @GET
    @Path(value="/status")
    public void status(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context HttpHeaders headers) throws DocumentException, IOException {
        if (request.getParameter("json") != null) {
            this.coreService.statusJson((OutputStream)response.getOutputStream(), response);
        } else {
            this.coreService.status((OutputStream)response.getOutputStream(), this.buildBloatedMap(request, response, headers));
        }
    }

    @GET
    @Path(value="/getSitemapJson")
    public void getSitemapJson(@Context HttpServletResponse response) throws IOException {
        Map elementsMap = CpkEngine.getInstance().getElementsMap();
        JsonNode sitemap = null;
        if (elementsMap != null) {
            LinkGenerator linkGen = new LinkGenerator(elementsMap, this.cpkEnv.getPluginUtils());
            sitemap = linkGen.getLinksJson();
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue((OutputStream)response.getOutputStream(), sitemap);
    }

    @GET
    @Path(value="/elementsList")
    public void elementsList(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context HttpHeaders headers) throws IOException {
        this.coreService.getElementsList((OutputStream)response.getOutputStream(), this.buildBloatedMap(request, response, headers));
    }

    private void writeMessage(OutputStream out, String message) {
        try {
            out.write(message.getBytes(CpkApi.getEncoding()));
            out.flush();
        }
        catch (IOException ex) {
            Logger.getLogger(CpkApi.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @GET
    @Path(value="/listDataAccessTypes")
    @Produces(value={"application/json"})
    public void listDataAccessTypes(@Context HttpServletResponse response) throws Exception {
        int index;
        LinkedHashSet<DataSource> dataSources = new LinkedHashSet<DataSource>();
        StringBuilder dsDeclarations = new StringBuilder("{");
        Collection endpoints = this.coreService.getElements();
        String pluginId = this.cpkEnv.getPluginName();
        String safePluginId = this.sanitizePluginId(pluginId);
        if (endpoints != null) {
            for (IElement endpoint : endpoints) {
                if (!(endpoint instanceof IDataSourceProvider)) continue;
                logger.info((Object)String.format("DataSource Endpoint found: %s)", endpoint));
                IDataSourceProvider dataSourceProvider = (IDataSourceProvider)endpoint;
                String endpointName = endpoint.getName();
                DataSource dataSource = dataSourceProvider.getDataSource();
                dataSource.getMetadata().setPluginId(pluginId);
                dataSources.add(dataSource);
                dsDeclarations.append(String.format("\"%s_%s_CPKENDPOINT\": ", safePluginId, endpointName));
                dsDeclarations.append(mapper.writeValueAsString((Object)dataSource));
                dsDeclarations.append(",");
            }
        }
        if ((index = dsDeclarations.lastIndexOf(",")) > 0) {
            dsDeclarations.deleteCharAt(index);
        }
        dsDeclarations.append("}");
        IOUtils.write((String)dsDeclarations.toString(), (OutputStream)response.getOutputStream());
        response.getOutputStream().flush();
    }

    private String sanitizePluginId(String pluginId) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pluginId.length(); ++i) {
            char c = pluginId.charAt(i);
            if ((!Character.isJavaIdentifierStart(c) || i != 0) && (!Character.isJavaIdentifierPart(c) || i <= 0)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    @GET
    @Path(value="/reloadPlugins")
    public void reloadPluginsGet() throws Exception {
        this.reloadPlugins();
    }

    @POST
    @Path(value="/reloadPlugins")
    public void reloadPluginsPost() throws Exception {
        this.reloadPlugins();
    }

    public void reloadPlugins() throws Exception {
    }

    @GET
    @Path(value="/clearCache")
    public void clearKettleResultsCache() {
        this.coreService.clearKettleResultsCache();
    }

    private Map<String, Map<String, Object>> buildBloatedMap(HttpServletRequest request, HttpServletResponse response, HttpHeaders headers) {
        HashMap<String, Map<String, Object>> mainMap = new HashMap<String, Map<String, Object>>();
        mainMap.put("request", this.buildRequestMap(request, headers));
        mainMap.put("path", this.buildPathMap(request, response, headers));
        return mainMap;
    }

    private Map<String, Object> buildRequestMap(HttpServletRequest request, HttpHeaders headers) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        if (request == null) {
            return requestMap;
        }
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            requestMap.put(o.toString(), request.getParameter(o.toString()));
        }
        Form form = ((ContainerRequest)headers).getFormParameters();
        for (String next : form.keySet()) {
            requestMap.put(next, ((List)form.get((Object)next)).get(0));
        }
        return requestMap;
    }

    private Map<String, Object> buildPathMap(HttpServletRequest request, HttpServletResponse response, HttpHeaders headers) {
        HashMap<String, Object> pathMap = new HashMap<String, Object>();
        pathMap.put("httprequest", request);
        pathMap.put("httpresponse", response);
        if (headers != null && headers.getRequestHeaders().containsKey((Object)"contentType")) {
            pathMap.put("contentType", headers.getRequestHeader("contentType"));
        }
        return pathMap;
    }

    private void callEndpoint(String endpoint, HttpServletRequest request, HttpServletResponse response, HttpHeaders headers) throws Exception {
        Map<String, Map<String, Object>> bloatedMap = this.buildBloatedMap(request, response, headers);
        bloatedMap.get("path").put("path", "/" + endpoint);
        this.coreService.createContent(bloatedMap);
        response.getOutputStream().flush();
    }

    public void createContent(Map<String, Map<String, Object>> bloatedMap) throws Exception {
        this.coreService.createContent(bloatedMap);
    }
}

