/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cpf.PentahoPluginEnvironment;
import pt.webdetails.cpf.plugins.Plugin;
import pt.webdetails.cpf.plugins.PluginsAnalyzer;
import pt.webdetails.cpf.session.ISessionUtils;
import pt.webdetails.cpf.session.PentahoSessionUtils;
import pt.webdetails.cpf.utils.IPluginUtils;
import pt.webdetails.cpk.ICpkEnvironment;
import pt.webdetails.cpk.security.AccessControl;
import pt.webdetails.cpk.security.IAccessControl;

public class CpkPentahoEnvironment
extends PentahoPluginEnvironment
implements ICpkEnvironment {
    private IPluginUtils pluginUtils;
    private HashSet<String> reservedWords;

    public CpkPentahoEnvironment() {
        this.pluginUtils = null;
        this.reservedWords = new HashSet();
    }

    public CpkPentahoEnvironment(IPluginUtils pluginUtils, String[] reservedWords) {
        this.pluginUtils = pluginUtils;
        this.reservedWords = new HashSet<String>(Arrays.asList(reservedWords));
    }

    public IPluginUtils getPluginUtils() {
        return this.pluginUtils;
    }

    public IAccessControl getAccessControl() {
        return new AccessControl(this.pluginUtils);
    }

    public String getPluginName() {
        return this.pluginUtils.getPluginName();
    }

    public Set<String> getReservedWords() {
        return Collections.unmodifiableSet(this.reservedWords);
    }

    public ISessionUtils getSessionUtils() {
        return new PentahoSessionUtils();
    }

    public String getWebAppDir() {
        return PentahoSystem.getApplicationContext().getApplicationPath("");
    }

    public void reload() {
        PluginsAnalyzer pluginsAnalyzer = new PluginsAnalyzer();
        pluginsAnalyzer.refresh();
        List plugins = pluginsAnalyzer.getInstalledPlugins();
        String pluginName = this.pluginUtils.getPluginName();
        for (Plugin plgn : plugins) {
            if (!plgn.getName().equalsIgnoreCase(pluginName) && !plgn.getId().equalsIgnoreCase(pluginName)) continue;
            plgn.setName(pluginName);
            break;
        }
    }
}

