/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.testing;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import org.mortbay.io.Buffer;
import org.mortbay.io.Buffers;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.io.SimpleBuffers;
import org.mortbay.io.View;
import org.mortbay.io.bio.StringEndPoint;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpGenerator;
import org.mortbay.jetty.HttpParser;
import org.mortbay.jetty.HttpVersions;
import org.mortbay.util.ByteArrayOutputStream2;

public class HttpTester {
    protected HttpFields _fields = new HttpFields();
    protected String _method;
    protected String _uri;
    protected String _version;
    protected int _status;
    protected String _reason;
    protected ByteArrayOutputStream2 _parsedContent;
    protected byte[] _genContent;

    public void reset() {
        this._fields.clear();
        this._method = null;
        this._uri = null;
        this._version = null;
        this._status = 0;
        this._reason = null;
        this._parsedContent = null;
        this._genContent = null;
    }

    public String parse(String rawHTTP) throws IOException {
        ByteArrayBuffer buf = new ByteArrayBuffer(rawHTTP);
        View view = new View((Buffer)buf);
        HttpParser parser = new HttpParser((Buffer)view, (HttpParser.EventHandler)new PH());
        parser.parse();
        return view.toString();
    }

    public String generate() throws IOException {
        ByteArrayBuffer bb = new ByteArrayBuffer(32768 + (this._genContent != null ? this._genContent.length : 0));
        ByteArrayBuffer sb = new ByteArrayBuffer(4096);
        StringEndPoint endp = new StringEndPoint();
        HttpGenerator generator = new HttpGenerator((Buffers)new SimpleBuffers(new Buffer[]{sb, bb}), (EndPoint)endp, sb.capacity(), bb.capacity());
        if (this._method != null) {
            generator.setRequest(this.getMethod(), this.getURI());
            if (this._version == null) {
                generator.setVersion(11);
            } else {
                generator.setVersion(HttpVersions.CACHE.getOrdinal(HttpVersions.CACHE.lookup(this._version)));
            }
            generator.completeHeader(this._fields, false);
            if (this._genContent != null) {
                generator.addContent((Buffer)new View((Buffer)new ByteArrayBuffer(this._genContent)), false);
            } else if (this._parsedContent != null) {
                generator.addContent((Buffer)new ByteArrayBuffer(this._parsedContent.toByteArray()), false);
            }
        }
        generator.complete();
        generator.flush();
        return endp.getOutput();
    }

    public String getMethod() {
        return this._method;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public String getReason() {
        return this._reason;
    }

    public void setReason(String reason) {
        this._reason = reason;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public String getURI() {
        return this._uri;
    }

    public void setURI(String uri) {
        this._uri = uri;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void addHeader(String name, String value) throws IllegalArgumentException {
        this._fields.add(name, value);
    }

    public void addDateHeader(String name, long date) {
        this._fields.addDateField(name, date);
    }

    public void addLongHeader(String name, long value) {
        this._fields.addLongField(name, value);
    }

    public void addSetCookie(Cookie cookie) {
        this._fields.addSetCookie(cookie);
    }

    public long getDateHeader(String name) {
        return this._fields.getDateField(name);
    }

    public Enumeration getHeaderNames() {
        return this._fields.getFieldNames();
    }

    public long getLongHeader(String name) throws NumberFormatException {
        return this._fields.getLongField(name);
    }

    public String getHeader(String name) {
        return this._fields.getStringField(name);
    }

    public Enumeration getHeaderValues(String name) {
        return this._fields.getValues(name);
    }

    public void setHeader(String name, String value) {
        this._fields.put(name, value);
    }

    public void setDateHeader(String name, long date) {
        this._fields.putDateField(name, date);
    }

    public void setLongHeader(String name, long value) {
        this._fields.putLongField(name, value);
    }

    public void removeHeader(String name) {
        this._fields.remove(name);
    }

    public String getContent() {
        if (this._parsedContent != null) {
            return this._parsedContent.toString();
        }
        if (this._genContent != null) {
            return new String(this._genContent);
        }
        return null;
    }

    public void setContent(String content) {
        this._parsedContent = null;
        if (content != null) {
            this._genContent = content.getBytes();
            this.setLongHeader("Content-Length", this._genContent.length);
        } else {
            this.removeHeader("Content-Length");
            this._genContent = null;
        }
    }

    private class PH
    extends HttpParser.EventHandler {
        private PH() {
        }

        public void startRequest(Buffer method, Buffer url, Buffer version) throws IOException {
            HttpTester.this.reset();
            HttpTester.this._method = method.toString();
            HttpTester.this._uri = url.toString();
            HttpTester.this._version = version.toString();
        }

        public void startResponse(Buffer version, int status, Buffer reason) throws IOException {
            HttpTester.this.reset();
            HttpTester.this._version = version.toString();
            HttpTester.this._status = status;
            HttpTester.this._reason = reason.toString();
        }

        public void parsedHeader(Buffer name, Buffer value) throws IOException {
            HttpTester.this._fields.add(name, value);
        }

        public void headerComplete() throws IOException {
        }

        public void messageComplete(long contextLength) throws IOException {
        }

        public void content(Buffer ref) throws IOException {
            if (HttpTester.this._parsedContent == null) {
                HttpTester.this._parsedContent = new ByteArrayOutputStream2();
            }
            HttpTester.this._parsedContent.write(ref.asArray());
        }
    }
}

