/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.context.autoinclude;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.cdf.context.autoinclude.AutoIncludeConfig;
import org.pentaho.cdf.context.autoinclude.DashboardMatchRule;
import org.pentaho.cdf.environment.CdfEngine;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IBasicFileFilter;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.repository.util.RepositoryHelper;

public class AutoInclude {
    private static final Log log = LogFactory.getLog(AutoInclude.class);
    private static final String PLUGIN_INCLUDES_DIR = CdfEngine.getEnvironment().getCdfPluginRepositoryDir() + "/includes";
    private String cdaFile;
    private Matcher cdaMatcher;
    private List<DashboardMatchRule> dashboardRules;

    public AutoInclude(String cdaPath, Matcher cdaMatcher, List<Node> dashboardRuleNodes) {
        this.cdaFile = cdaPath;
        this.dashboardRules = new ArrayList<DashboardMatchRule>();
        this.cdaMatcher = cdaMatcher;
        for (Node node : dashboardRuleNodes) {
            try {
                DashboardMatchRule rule = new DashboardMatchRule(this.cdaMatcher, node);
                this.dashboardRules.add(rule);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public boolean canInclude(String dashboardPath) {
        boolean canInclude = false;
        for (DashboardMatchRule rule : this.dashboardRules) {
            canInclude = rule.canInclude(dashboardPath, canInclude);
        }
        if (log.isDebugEnabled() && canInclude) {
            log.debug((Object)(this.cdaFile + " to be included in " + dashboardPath));
        }
        return canInclude;
    }

    public String getCdaPath() {
        return this.cdaFile;
    }

    public String toString() {
        return this.cdaFile + (this.dashboardRules != null ? " [" + StringUtils.join(this.dashboardRules.iterator(), (String)", ") + "]" : "[]");
    }

    public static List<AutoInclude> buildAutoIncludeList(Document config, IReadAccess cdaRoot) {
        long start = System.currentTimeMillis();
        List<AutoIncludeConfig> autoIncludeConfigs = AutoIncludeConfig.getAutoIncludeConfigs(config);
        ArrayList<Pattern> cdaRegexList = new ArrayList<Pattern>();
        for (AutoIncludeConfig autoInc : autoIncludeConfigs) {
            cdaRegexList.add(autoInc.getCdaRegex());
        }
        List<IBasicFile> cdaFiles = AutoInclude.getCdaFiles(cdaRegexList, cdaRoot);
        ArrayList<String> cdaPaths = new ArrayList<String>();
        for (IBasicFile cda : cdaFiles) {
            cdaPaths.add(cda.getPath());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%d cda files from %d rules", cdaPaths.size(), cdaRegexList.size()));
        }
        ArrayList<AutoInclude> result = new ArrayList<AutoInclude>();
        for (AutoIncludeConfig aiConfig : autoIncludeConfigs) {
            result.addAll(AutoInclude.processAutoIncludes(aiConfig, cdaPaths));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("AutoInclude list(%d) built in %s", result.size(), Util.getElapsedSeconds((long)start)));
            log.trace((Object)("AutoInclude list: \n\t" + StringUtils.join(result.iterator(), (String)"\n\t")));
        }
        return result;
    }

    private static List<IBasicFile> getCdaFiles(final List<Pattern> cdaPathRegexes, IReadAccess cdaRoot) {
        IBasicFileFilter cdaFilter = new IBasicFileFilter(){

            public boolean accept(IBasicFile file) {
                for (Pattern regex : cdaPathRegexes) {
                    if (!regex.matcher(RepositoryHelper.joinPaths((String[])new String[]{PLUGIN_INCLUDES_DIR, file.getPath()})).matches()) continue;
                    return true;
                }
                return false;
            }
        };
        long start = System.currentTimeMillis();
        List cdaFiles = cdaRoot.listFiles(null, cdaFilter, -1, false);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%d matching cda files found (%s)", cdaFiles.size(), Util.getElapsedSeconds((long)start)));
        }
        return cdaFiles;
    }

    private static List<AutoInclude> processAutoIncludes(AutoIncludeConfig config, List<String> cdaPaths) {
        ArrayList<AutoInclude> autoIncludes = new ArrayList<AutoInclude>();
        for (String cdaPath : cdaPaths) {
            cdaPath = RepositoryHelper.joinPaths((String[])new String[]{PLUGIN_INCLUDES_DIR, cdaPath});
            Matcher matcher = config.getCdaRegex().matcher(cdaPath);
            if (!matcher.matches()) continue;
            AutoInclude include = new AutoInclude(cdaPath, matcher, config.getDashboardRules());
            autoIncludes.add(include);
        }
        return autoIncludes;
    }
}

