/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.context.autoinclude;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

class AutoIncludeConfig {
    private static final Log log = LogFactory.getLog(AutoIncludeConfig.class);
    private Node node;
    private Pattern cdaRegex;
    private Pattern dataAccessIdRegex;

    public AutoIncludeConfig(Node autoInclude) throws PatternSyntaxException {
        this.node = autoInclude;
        String re = XmlDom4JHelper.getNodeText((String)"cda", (Node)autoInclude, (String)"");
        this.cdaRegex = Pattern.compile(re);
        re = XmlDom4JHelper.getNodeText((String)"ids", (Node)autoInclude, (String)".*");
        this.dataAccessIdRegex = Pattern.compile(re);
    }

    public Pattern getCdaRegex() {
        return this.cdaRegex;
    }

    public Pattern getDataAccessIdRegex() {
        return this.dataAccessIdRegex;
    }

    public List<Node> getDashboardRules() {
        return this.node.selectNodes("dashboards/*");
    }

    public String toString() {
        return this.node.asXML();
    }

    public static List<AutoIncludeConfig> getAutoIncludeConfigs(Document config) {
        List includes = config.selectNodes("//autoincludes/autoinclude");
        ArrayList<AutoIncludeConfig> autoIncludeConfigs = new ArrayList<AutoIncludeConfig>();
        for (Node include : includes) {
            try {
                autoIncludeConfigs.add(new AutoIncludeConfig(include));
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("read:\n " + include.asXML()));
            }
            catch (PatternSyntaxException e) {
                log.error((Object)("Bad regular expression in " + include.asXML()));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(autoIncludeConfigs.size() + " autoinclude entries read."));
        }
        return autoIncludeConfigs;
    }
}

