/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.environment.broker;

import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.cdf.environment.broker.ICdfInterPluginBroker;
import pt.webdetails.cpf.InterPluginCall;

public class PentahoCdfInterPluginBroker
implements ICdfInterPluginBroker {
    private static final Log logger = LogFactory.getLog(PentahoCdfInterPluginBroker.class);
    private static PentahoCdfInterPluginBroker instance;

    public static PentahoCdfInterPluginBroker getInstance() {
        if (instance == null) {
            instance = new PentahoCdfInterPluginBroker();
        }
        return instance;
    }

    public void addCdaQueries(JSONObject queries, String cdaPath) {
        List<String> dataAccessIds = this.listCdaQueries(cdaPath);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("data access ids for %s:( %s )", cdaPath, StringUtils.join(dataAccessIds.iterator(), (String)", ")));
        }
        for (String id : dataAccessIds) {
            String reply = this.executeCdaQuery(cdaPath, id);
            try {
                queries.put(id, (Object)new JSONObject(reply));
            }
            catch (JSONException e) {
                logger.error((Object)("Failed to add query " + id + " to contex object"));
            }
        }
    }

    public String executeCdaQuery(String path, String id) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dataAccessId", id);
        params.put("path", path);
        logger.info((Object)("[Timing] Executing autoinclude query: " + new SimpleDateFormat("HH:mm:ss.SSS").format(new Date())));
        InterPluginCall ipc = new InterPluginCall(InterPluginCall.CDA, "doQueryInterPluginOld", params);
        String reply = ipc.callInPluginClassLoader();
        logger.info((Object)("[Timing] Done executing autoinclude query: " + new SimpleDateFormat("HH:mm:ss.SSS").format(new Date())));
        return reply;
    }

    public List<String> listCdaQueries(String cda) {
        SAXReader reader = new SAXReader();
        ArrayList<String> queryOutput = new ArrayList<String>();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("path", cda);
            params.put("outputType", "xml");
            InterPluginCall ipc = new InterPluginCall(InterPluginCall.CDA, "listQueriesInterPluginOld", params);
            String reply = ipc.call();
            Document queryList = reader.read((Reader)new StringReader(reply));
            List queries = queryList.selectNodes("//ResultSet/Row/Col[1]");
            for (Node query : queries) {
                queryOutput.add(query.getText());
            }
        }
        catch (DocumentException e) {
            return null;
        }
        return queryOutput;
    }
}

