/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.localization;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.cdf.environment.CdfEngine;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.repository.api.IUserContentAccess;

public class MessageBundlesHelper {
    private String globalBaseMessageFile;
    private String targetDashboardCacheDir;
    private String targetDashboardBaseMsgFile;
    private String sourceDashboardBaseMsgFile;
    private String languagesCacheUrl;

    public MessageBundlesHelper(String dashboardSolution, String dashboardPath, String dashboardsMessagesBaseFilename) {
        this.init("Messages", dashboardSolution, dashboardPath, dashboardsMessagesBaseFilename);
    }

    public MessageBundlesHelper(String dashboardSolutionPath, String dashboardsMessagesBaseFilename) {
        this.init("Messages", dashboardSolutionPath, dashboardsMessagesBaseFilename);
    }

    public void saveI18NMessageFilesToCache() throws IOException {
        this.createCacheDirIfNotExists(this.targetDashboardCacheDir);
        this.copyStdGlobalMessageFileToCache();
        if (this.sourceDashboardBaseMsgFile != null) {
            this.appendMessageFiles(this.sourceDashboardBaseMsgFile, this.globalBaseMessageFile, this.targetDashboardBaseMsgFile);
        } else {
            this.appendMessageFiles(this.globalBaseMessageFile, this.targetDashboardBaseMsgFile);
        }
    }

    public String getMessageFilesCacheUrl() {
        return FilenameUtils.separatorsToUnix((String)this.languagesCacheUrl);
    }

    protected void init(String baseGlobalMessageSetFilename, String dashboardSolution, String dashboardPath, String dashboardsMessagesBaseFilename) {
        this.globalBaseMessageFile = Util.joinPath((String[])new String[]{"resources/languages/", baseGlobalMessageSetFilename});
        this.languagesCacheUrl = Util.joinPath((String[])new String[]{"tmp/.cache", dashboardSolution + dashboardPath});
        this.targetDashboardCacheDir = this.getMessageFilesCacheUrl();
        this.targetDashboardBaseMsgFile = Util.joinPath((String[])new String[]{this.languagesCacheUrl, dashboardsMessagesBaseFilename != null ? dashboardsMessagesBaseFilename : baseGlobalMessageSetFilename});
        if (!StringUtils.isEmpty((String)dashboardsMessagesBaseFilename)) {
            this.sourceDashboardBaseMsgFile = Util.joinPath((String[])new String[]{dashboardSolution, dashboardPath, dashboardsMessagesBaseFilename});
        }
    }

    protected void init(String baseGlobalMessageSetFilename, String dashboardSolutionPath, String dashboardsMessagesBaseFilename) {
        this.globalBaseMessageFile = Util.joinPath((String[])new String[]{"resources/languages/", baseGlobalMessageSetFilename});
        this.languagesCacheUrl = Util.joinPath((String[])new String[]{"tmp/.cache", dashboardSolutionPath});
        this.targetDashboardCacheDir = this.getMessageFilesCacheUrl();
        this.targetDashboardBaseMsgFile = Util.joinPath((String[])new String[]{this.languagesCacheUrl, dashboardsMessagesBaseFilename != null ? dashboardsMessagesBaseFilename : baseGlobalMessageSetFilename});
        if (!StringUtils.isEmpty((String)dashboardsMessagesBaseFilename)) {
            this.sourceDashboardBaseMsgFile = Util.joinPath((String[])new String[]{dashboardSolutionPath, dashboardsMessagesBaseFilename});
        }
    }

    protected void createCacheDirIfNotExists(String targetDashboardCacheDir) {
        if (!this.getSystemReader().fileExists(targetDashboardCacheDir)) {
            this.getSystemWriter().createFolder(targetDashboardCacheDir);
        }
    }

    protected void appendMessageFiles(String globalBaseMessageFile, String targetDashboardBaseMsgFile) throws IOException {
        this.appendMessageFiles(null, globalBaseMessageFile, targetDashboardBaseMsgFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendMessageFiles(String sourceDashboardBaseMsgFile, String globalBaseMessageFile, String targetDashboardBaseMsgFile) throws IOException {
        String localeSuffix = "_" + CdfEngine.getEnvironment().getLocale().getLanguage();
        targetDashboardBaseMsgFile = !targetDashboardBaseMsgFile.endsWith(localeSuffix) ? targetDashboardBaseMsgFile + localeSuffix : targetDashboardBaseMsgFile;
        IBasicFile fBaseMsgGlobal = this.getSystemReader().fetchFile(globalBaseMessageFile + "_" + CdfEngine.getEnvironment().getLocale().getLanguage() + ".properties");
        if (!this.getSystemReader().fileExists(targetDashboardBaseMsgFile + ".properties")) {
            File tempMessageFile = null;
            String locale = CdfEngine.getEnvironment().getLocale().getLanguage();
            try {
                String theLine;
                String tempMessageFileName = System.getProperty("java.io.tmpdir") + "tempMessageFile_" + System.currentTimeMillis();
                tempMessageFile = new File(tempMessageFileName);
                BufferedWriter bwTempBaseMsgTarget = new BufferedWriter(new FileWriter(tempMessageFile, true));
                String globalBaseMessageFileName = globalBaseMessageFile + "_" + locale + ".properties";
                if (!this.getSystemReader().fileExists(globalBaseMessageFileName)) {
                    InputStream content = new ByteArrayInputStream("".getBytes());
                    if (this.getSystemReader().fileExists(globalBaseMessageFile + ".properties")) {
                        content = this.getSystemReader().fetchFile(globalBaseMessageFile + ".properties").getContents();
                    }
                    this.getSystemWriter().saveFile(globalBaseMessageFileName, content);
                    fBaseMsgGlobal = this.getSystemReader().fetchFile(globalBaseMessageFileName);
                }
                BufferedReader brBaseMsgGlobal = new BufferedReader(new InputStreamReader(fBaseMsgGlobal.getContents()));
                while ((theLine = brBaseMsgGlobal.readLine()) != null) {
                    bwTempBaseMsgTarget.write(theLine + "\n");
                }
                brBaseMsgGlobal.close();
                if (!StringUtils.isEmpty((String)sourceDashboardBaseMsgFile)) {
                    IBasicFile msgFile = null;
                    if (this.getUserContentReader().fileExists(sourceDashboardBaseMsgFile + "_" + locale + ".properties")) {
                        msgFile = this.getUserContentReader().fetchFile(sourceDashboardBaseMsgFile + "_" + locale + ".properties");
                    } else if (this.getUserContentReader().fileExists(sourceDashboardBaseMsgFile + ".properties")) {
                        msgFile = this.getUserContentReader().fetchFile(sourceDashboardBaseMsgFile + ".properties");
                    }
                    if (msgFile != null && msgFile.getContents() != null) {
                        BufferedReader brBaseMsgDashboard = new BufferedReader(new InputStreamReader(msgFile.getContents()));
                        while ((theLine = brBaseMsgDashboard.readLine()) != null) {
                            bwTempBaseMsgTarget.write(theLine + "\n");
                        }
                        brBaseMsgDashboard.close();
                    }
                }
                bwTempBaseMsgTarget.close();
                this.getSystemWriter().saveFile(targetDashboardBaseMsgFile + ".properties", (InputStream)new FileInputStream(tempMessageFile));
            }
            finally {
                if (tempMessageFile != null && tempMessageFile.exists()) {
                    tempMessageFile.delete();
                }
            }
        }
    }

    protected void copyStdGlobalMessageFileToCache() throws IOException {
        String standardGlobalMessageFilename = "Messages.properties";
        String standardGlobalMessageFilenamePath = Util.joinPath((String[])new String[]{"resources/languages/", standardGlobalMessageFilename});
        if (!this.getSystemReader().fileExists(standardGlobalMessageFilenamePath)) {
            this.getSystemWriter().saveFile(standardGlobalMessageFilenamePath, (InputStream)new ByteArrayInputStream("".getBytes()));
        }
        IBasicFile fromFile = this.getSystemReader().fetchFile(standardGlobalMessageFilenamePath);
        String toFile = Util.joinPath((String[])new String[]{this.targetDashboardCacheDir, standardGlobalMessageFilename});
        if (this.getSystemWriter().fileExists(toFile)) {
            return;
        }
        this.getSystemWriter().saveFile(toFile, fromFile.getContents());
    }

    private IReadAccess getSystemReader() {
        return CdfEngine.getPluginSystemReader(null);
    }

    private IRWAccess getSystemWriter() {
        return CdfEngine.getEnvironment().getContentAccessFactory().getPluginSystemWriter(null);
    }

    private IUserContentAccess getUserContentReader() {
        return CdfEngine.getUserContentReader(null);
    }
}

