/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.settings;

import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.cdf.settings.SettingsEngine;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import pt.webdetails.cpf.utils.PluginIOUtils;

@Path(value="/pentaho-cdf/api/settings")
public class SettingsApi {
    IPentahoSession userSession;
    private static final Log logger = LogFactory.getLog(SettingsApi.class);

    @POST
    @Path(value="/set")
    public void set(@FormParam(value="key") String key, @FormParam(value="value") String value) {
        if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value)) {
            logger.equals("empty values not allowed -> key:" + key + " | value:" + value);
            return;
        }
        SettingsEngine.getInstance().setValue(key, value, PentahoSessionHolder.getSession());
    }

    @GET
    @Path(value="/get")
    public void get(@QueryParam(value="key") String key, @Context HttpServletResponse servletResponse) {
        if (StringUtils.isEmpty((String)key)) {
            logger.equals("empty key value not allowed");
            return;
        }
        Object value = SettingsEngine.getInstance().getValue(key, PentahoSessionHolder.getSession());
        try {
            PluginIOUtils.writeOutAndFlush((OutputStream)servletResponse.getOutputStream(), (String)value.toString());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

