/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.views;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.cdf.views.View;
import pt.webdetails.cpf.persistence.Filter;
import pt.webdetails.cpf.persistence.Persistable;
import pt.webdetails.cpf.persistence.PersistenceEngine;
import pt.webdetails.cpf.persistence.SimplePersistence;

public class ViewEngine {
    private static final Log logger = LogFactory.getLog(ViewEngine.class);
    private static final String RESULT_OK = "ok";
    private static final String RESULT_ERROR = "error";
    private static ViewEngine instance;

    private ViewEngine() {
        PersistenceEngine pe = PersistenceEngine.getInstance();
        if (!pe.classExists(View.class.getName())) {
            pe.initializeClass(View.class.getName());
        }
    }

    public static synchronized ViewEngine getInstance() {
        if (instance == null) {
            instance = new ViewEngine();
        }
        return instance;
    }

    public View getView(String viewName, String user) {
        SimplePersistence sp = SimplePersistence.getInstance();
        Filter filter = new Filter();
        filter.where("name").equalTo((Object)viewName).and().where("user").equalTo((Object)user);
        List views = sp.load(View.class, filter);
        return views != null && views.size() > 0 ? (View)views.get(0) : null;
    }

    public JSONObject listViews(String user) {
        SimplePersistence sp = SimplePersistence.getInstance();
        Filter filter = new Filter();
        filter.where("user").equalTo((Object)user);
        List views = sp.load(View.class, filter);
        JSONObject obj = new JSONObject();
        JSONArray arr = new JSONArray();
        for (View v : views) {
            arr.put((Object)v.toJSON());
        }
        try {
            obj.put("views", (Object)arr);
            obj.put("status", (Object)RESULT_OK);
        }
        catch (JSONException e) {
            logger.error((Object)e);
        }
        return obj;
    }

    public JSONObject listAllViews(String user) {
        JSONObject response = new JSONObject();
        SimplePersistence sp = SimplePersistence.getInstance();
        Filter filter = new Filter();
        filter.where("user").equalTo((Object)user);
        List views = sp.loadAll(View.class);
        JSONArray arr = new JSONArray();
        for (View v : views) {
            arr.put((Object)v.toJSON());
        }
        try {
            response.put("views", (Object)arr);
            response.put("status", (Object)RESULT_OK);
        }
        catch (JSONException e) {
            logger.error((Object)e);
        }
        return response;
    }

    public String saveView(String view, String user) {
        View viewObj = new View();
        try {
            JSONObject json = new JSONObject(view);
            viewObj.fromJSON(json);
            viewObj.setUser(user);
            PersistenceEngine pe = PersistenceEngine.getInstance();
            pe.store((Persistable)viewObj);
        }
        catch (JSONException e) {
            logger.error((Object)e);
            return RESULT_ERROR;
        }
        return RESULT_OK;
    }

    public String deleteView(String viewName, String user) {
        try {
            Filter filter = new Filter();
            filter.where("user").equalTo((Object)user).and().where("name").equalTo((Object)viewName);
            SimplePersistence.getInstance().delete(View.class, filter);
            return RESULT_OK;
        }
        catch (Exception e) {
            return RESULT_ERROR;
        }
    }

    public void listReports() {
    }

    public void saveReport() {
    }

    public static enum Operation {
        GET_VIEW("GETVIEW"),
        LIST_VIEWS("LISTVIEWS"),
        LIST_ALL_VIEWS("LISTALLVIEWS"),
        SAVE_VIEW("SAVEVIEW"),
        DELETE_VIEW("DELETEVIEW"),
        UNKNOWN("UNKNOWN");

        private final String operation;

        private Operation(String operation) {
            this.operation = operation;
        }

        public static Operation get(String operation) {
            try {
                return Operation.valueOf(operation.toUpperCase());
            }
            catch (Exception exception) {
                return UNKNOWN;
            }
        }
    }
}

