/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.xactions;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.cdf.util.CdfHttpServletRequestWrapper;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.SolutionHelper;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.http.api.resources.XactionUtil;

public class ActionEngine {
    private static final Log logger = LogFactory.getLog(ActionEngine.class);
    private static ActionEngine instance;

    public static synchronized ActionEngine getInstance() {
        if (instance == null) {
            instance = new ActionEngine();
        }
        return instance;
    }

    public ActionEngine() {
        logger.info((Object)"Creating ActionEngine instance");
    }

    @Deprecated
    public boolean executeAction(String resource, IPentahoSession userSession, OutputStream out, HashMap<String, String> params) {
        ISolutionEngine engine = SolutionHelper.execute((String)"executeAction", (IPentahoSession)userSession, (String)resource, params, (OutputStream)out);
        int status = engine.getExecutionContext().getStatus();
        return status == 6;
    }

    public boolean executeAction(String path, String contentType, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, IPentahoSession userSession, HashMap<String, String> params) throws IOException {
        boolean success = false;
        try {
            String buffer;
            IUnifiedRepository unifiedRepository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, null);
            RepositoryFile file = unifiedRepository.getFile(path);
            CdfHttpServletRequestWrapper request = new CdfHttpServletRequestWrapper(httpServletRequest);
            if (params != null) {
                for (String key : params.keySet()) {
                    request.addParameter(key, params.get(key));
                }
            }
            if (!StringUtils.isEmpty((String)(buffer = XactionUtil.execute((String)contentType, (RepositoryFile)file, (HttpServletRequest)request, (HttpServletResponse)httpServletResponse, (IPentahoSession)userSession, null)))) {
                httpServletResponse.getOutputStream().write(buffer.getBytes(LocaleHelper.getSystemEncoding()));
            }
            success = true;
        }
        catch (Throwable t) {
            logger.error((Object)t);
            httpServletResponse.sendError(500, t.getMessage());
        }
        return success;
    }
}

