/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.database.event;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.Command;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseConnectionPoolParameter;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseConnectionPoolParameter;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.model.PartitionDatabaseMeta;
import org.pentaho.database.util.DatabaseTypeHelper;
import org.pentaho.gwt.widgets.client.utils.NameUtils;
import org.pentaho.ui.database.event.DatabaseDialogListener;
import org.pentaho.ui.database.event.GwtLayoutHandler;
import org.pentaho.ui.database.event.IConnectionAutoBeanFactory;
import org.pentaho.ui.database.event.IDatabaseConnectionPoolParameterList;
import org.pentaho.ui.database.event.IFragmentHandler;
import org.pentaho.ui.database.event.ILaunch;
import org.pentaho.ui.database.event.IMessages;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulCheckbox;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulListitem;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulTreeItem;
import org.pentaho.ui.xul.containers.XulTreeRow;
import org.pentaho.ui.xul.containers.XulWindow;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class DataHandler
extends AbstractXulEventHandler {
    private static final String LINE_SEPARATOR = "\n";
    private static final int SC_NO_CONTENT_IE = 1223;
    protected DatabaseDialogListener listener;
    protected IMessages messages;
    protected ILaunch launch;
    protected DatabaseTypeHelper databaseTypeHelper;
    protected IFragmentHandler fragmentHandler;
    private DatabaseConnectionPoolParameter[] poolingParameters;
    protected IDatabaseConnection databaseConnection = null;
    private IDatabaseConnection cache;
    private XulDeck dialogDeck;
    private XulListbox deckOptionsBox;
    private XulListbox connectionBox;
    private XulListbox accessBox;
    private XulTextbox connectionNameBox;
    protected XulTextbox hostNameBox;
    protected XulTextbox databaseNameBox;
    protected XulTextbox portNumberBox;
    protected XulTextbox userNameBox;
    protected XulTextbox passwordBox;
    protected XulTextbox customDriverClassBox;
    protected XulTextbox customUrlBox;
    protected XulTextbox dataTablespaceBox;
    protected XulTextbox indexTablespaceBox;
    private XulTextbox serverInstanceBox;
    private XulTextbox serverNameBox;
    protected XulTextbox languageBox;
    protected XulTextbox systemNumberBox;
    protected XulTextbox clientBox;
    private XulCheckbox doubleDecimalSeparatorCheck;
    private XulCheckbox useIntegratedSecurityCheck;
    private XulCheckbox resultStreamingCursorCheck;
    protected XulTree optionsParameterTree;
    private XulCheckbox clusteringCheck;
    protected XulTree clusterParameterTree;
    private XulLabel clusterParameterDescriptionLabel;
    XulCheckbox quoteIdentifiersCheck;
    XulCheckbox lowerCaseIdentifiersCheck;
    XulCheckbox upperCaseIdentifiersCheck;
    XulTextbox sqlBox;
    private XulLabel poolSizeLabel;
    private XulLabel maxPoolSizeLabel;
    private XulCheckbox poolingCheck;
    protected XulTextbox poolSizeBox;
    protected XulTextbox maxPoolSizeBox;
    private XulTextbox poolingDescription;
    private XulLabel poolingParameterDescriptionLabel;
    private XulLabel poolingDescriptionLabel;
    protected XulTree poolParameterTree;
    protected IConnectionAutoBeanFactory connectionAutoBeanFactory;

    public DataHandler() {
        this.setName("dataHandler");
        this.connectionAutoBeanFactory = (IConnectionAutoBeanFactory)GWT.create(IConnectionAutoBeanFactory.class);
        this.cache = this.createDatabaseConnection();
    }

    public void setFragmentHandler(IFragmentHandler fragmentHandler) {
        this.fragmentHandler = fragmentHandler;
    }

    public void setDatabaseTypeHelper(DatabaseTypeHelper databaseTypeHelper) {
        this.databaseTypeHelper = databaseTypeHelper;
    }

    public void setDatabaseDialogListener(DatabaseDialogListener listener) {
        this.listener = listener;
    }

    public void setMessages(IMessages messages) {
        this.messages = messages;
    }

    public void setLaunch(ILaunch launch) {
        this.launch = launch;
    }

    private IDatabaseConnection createDatabaseConnection() {
        IDatabaseConnection database = (IDatabaseConnection)this.connectionAutoBeanFactory.iDatabaseConnection().as();
        database.setAttributes(new HashMap());
        database.setConnectionPoolingProperties(new HashMap());
        database.setExtraOptions(new HashMap());
        return database;
    }

    @Bindable
    public void loadConnectionData() {
        if (this.connectionBox != null) {
            return;
        }
        this.getControls();
        for (String key : this.databaseTypeHelper.getDatabaseTypeNames()) {
            this.connectionBox.addItem((Object)key);
        }
        this.connectionBox.setRows(this.connectionBox.getRows());
        String key = this.getSelectedString(this.connectionBox);
        if (key == null) {
            key = this.databaseTypeHelper.getDatabaseTypeNames().get(0);
            this.connectionBox.setSelectedItem((Object)key);
        } else {
            this.connectionBox.setSelectedItem((Object)key);
        }
        if (this.dialogDeck != null) {
            this.setDeckChildIndex();
        }
        this.setDefaultPoolParameters();
        if (this.databaseConnection != null) {
            this.setInfo(this.databaseConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Bindable
    public void loadAccessData() {
        try {
            this.jsni_showLoadingIndicator();
            this.getControls();
            this.pushCache();
            String key = this.getSelectedString(this.connectionBox);
            if (key == null) {
                key = (String)this.databaseTypeHelper.getDatabaseTypeNames().get(0);
                this.connectionBox.setSelectedItem((Object)key);
                return;
            }
            IDatabaseType database = this.databaseTypeHelper.getDatabaseTypeByName(key);
            List acc = database.getSupportedAccessTypes();
            String accessKey = this.getSelectedString(this.accessBox);
            boolean refreshInitiallyDisabled = this.fragmentHandler.isRefreshDisabled();
            this.fragmentHandler.setDisableRefresh(true);
            this.accessBox.removeItems();
            for (DatabaseAccessType value : acc) {
                this.accessBox.addItem((Object)value.getName());
            }
            if (!refreshInitiallyDisabled) {
                this.fragmentHandler.setDisableRefresh(false);
            }
            this.accessBox.setRows(this.accessBox.getRows());
            this.accessBox.setSelectedItem((Object)accessKey);
            this.fragmentHandler.refreshOptionsWithCallback(null);
            this.setOptionsData(this.databaseConnection != null ? this.databaseConnection.getExtraOptions() : null);
            this.setClusterData(this.databaseConnection != null ? this.databaseConnection.getPartitioningInformation() : null);
            this.popCache();
        }
        finally {
            this.jsni_hideLoadingIndicator();
        }
    }

    private native void jsni_showLoadingIndicator();

    private native void jsni_hideLoadingIndicator();

    private String getSelectedString(XulListbox box) {
        String key = null;
        Object keyObj = box.getSelectedItem();
        key = keyObj instanceof XulListitem ? ((XulListitem)keyObj).getLabel() : (String)keyObj;
        return key;
    }

    @Bindable
    public void editOptions(int index) {
        Object[][] values;
        String[] row;
        if (!(index + 1 != this.optionsParameterTree.getRows() || (row = (String[])(values = this.optionsParameterTree.getValues())[values.length - 1]) == null || DataHandler.isBlank(row[0]) && DataHandler.isBlank(row[1]))) {
            XulTreeRow newRow = this.optionsParameterTree.getRootChildren().addNewRow();
            newRow.addCellText(0, "");
            newRow.addCellText(1, "");
        }
    }

    @Bindable
    public void getOptionHelp() {
        String message = null;
        IDatabaseConnection database = this.createDatabaseConnection();
        this.getInfo(database);
        String url = database.getDatabaseType().getExtraOptionsHelpUrl();
        if (DataHandler.isBlank(url)) {
            message = this.messages.getString("DataHandler.USER_NO_HELP_AVAILABLE");
            this.showMessage(this.messages.getString("DataHandler.ERROR_MESSAGE_TITLE"), message, false);
            return;
        }
        if (this.launch != null) {
            ILaunch.Status status = this.launch.openUrl(url, this.messages);
            if (status.equals((Object)ILaunch.Status.Failed)) {
                message = this.messages.getString("DataHandler.USER_UNABLE_TO_LAUNCH_BROWSER", url);
                this.showMessage(this.messages.getString("DataHandler.ERROR_MESSAGE_TITLE"), message, false);
            }
        } else {
            this.showMessage(this.messages.getString("DataHandler.ERROR_MESSAGE_TITLE"), this.messages.getString("DataHandler.LAUNCH_NOT_SUPPORTED"), false);
        }
    }

    @Bindable
    public void addEmptyRowsToOptions() {
        final Object[][] values = this.optionsParameterTree.getValues();
        GwtLayoutHandler.deferUpdateUI(this.optionsParameterTree, new Command(){

            public void execute() {
                int rowsToAdd = 5 - values.length;
                while (rowsToAdd-- > 0) {
                    XulTreeRow row = DataHandler.this.optionsParameterTree.getRootChildren().addNewRow();
                    row.addCellText(0, "");
                    row.addCellText(1, "");
                }
            }
        });
    }

    @Bindable
    public void setDeckChildIndex() {
        this.getControls();
        int originalSelection = this.dialogDeck.getSelectedIndex();
        boolean passed = true;
        if (originalSelection == 3) {
            passed = this.checkPoolingParameters();
        }
        this.addEmptyRowsToOptions();
        if (passed) {
            int selected = this.deckOptionsBox.getSelectedIndex();
            if (selected < 0 && this.deckOptionsBox.getRowCount() > 0) {
                selected = 0;
                this.deckOptionsBox.setSelectedIndex(0);
            }
            this.dialogDeck.setSelectedIndex(selected);
        } else {
            this.dialogDeck.setSelectedIndex(originalSelection);
            this.deckOptionsBox.setSelectedIndex(originalSelection);
        }
    }

    @Bindable
    public void onPoolingCheck() {
        if (this.poolingCheck != null) {
            boolean dis;
            boolean bl = dis = !this.poolingCheck.isChecked();
            if (this.poolSizeBox != null) {
                this.poolSizeBox.setDisabled(dis);
            }
            if (this.maxPoolSizeBox != null) {
                this.maxPoolSizeBox.setDisabled(dis);
            }
            if (this.poolSizeLabel != null) {
                this.poolSizeLabel.setDisabled(dis);
            }
            if (this.maxPoolSizeLabel != null) {
                this.maxPoolSizeLabel.setDisabled(dis);
            }
            if (this.poolParameterTree != null) {
                GwtLayoutHandler.deferUpdateUI(this.poolParameterTree, new Command(){

                    public void execute() {
                        DataHandler.this.poolParameterTree.setDisabled(dis);
                        DataHandler.this.traverseDomSetReadOnly((XulComponent)DataHandler.this.poolParameterTree, dis);
                    }
                });
            }
            if (this.poolingParameterDescriptionLabel != null) {
                this.poolingParameterDescriptionLabel.setDisabled(dis);
            }
            if (this.poolingDescriptionLabel != null) {
                this.poolingDescriptionLabel.setDisabled(dis);
            }
            if (this.poolingDescription != null) {
                this.poolingDescription.setDisabled(dis);
            }
        }
    }

    @Bindable
    public void onClusterCheck() {
        if (this.clusteringCheck != null) {
            boolean dis;
            boolean bl = dis = !this.clusteringCheck.isChecked();
            if (this.clusterParameterTree != null) {
                this.clusterParameterTree.setDisabled(dis);
            }
            if (this.clusterParameterDescriptionLabel != null) {
                this.clusterParameterDescriptionLabel.setDisabled(dis);
            }
        }
    }

    public Object getData() {
        return this.databaseConnection;
    }

    public void setData(Object data) {
        if (data == null) {
            data = this.createDatabaseConnection();
        }
        this.databaseConnection = (IDatabaseConnection)data;
        this.setInfo(this.databaseConnection);
    }

    public void pushCache() {
        this.getConnectionSpecificInfo(this.cache);
    }

    public void popCache() {
        this.setConnectionSpecificInfo(this.cache);
    }

    @Bindable
    public void onCancel() {
        this.close();
        if (this.listener != null) {
            this.listener.onDialogCancel();
        }
    }

    @Bindable
    private void close() {
        XulComponent window = this.document.getElementById("general-datasource-window");
        if (window == null) {
            window = this.document.getRootElement();
        }
        if (window instanceof XulDialog) {
            ((XulDialog)window).hide();
        } else if (window instanceof XulWindow) {
            ((XulWindow)window).close();
        }
    }

    private boolean windowClosed() {
        boolean closedWindow = true;
        XulComponent window = this.document.getElementById("general-datasource-window");
        if (window == null) {
            window = this.document.getRootElement();
        }
        if (window instanceof XulWindow) {
            closedWindow = ((XulWindow)window).isClosed();
        }
        return closedWindow;
    }

    @Bindable
    public void onOK() {
        IDatabaseConnection database = this.createDatabaseConnection();
        this.getInfo(database);
        String illegals = NameUtils.getReservedChars();
        if (!NameUtils.isValidFileName((String)database.getName())) {
            this.showMessage(this.messages.getString("DatabaseDialog.ErrorConnectionName.title"), this.messages.getString("DatabaseDialog.ErrorConnectionName.description", illegals), false);
            return;
        }
        boolean passed = this.checkPoolingParameters();
        if (!passed) {
            return;
        }
        RequestBuilder checkParamsBuilder = new RequestBuilder(RequestBuilder.POST, DataHandler.getBaseURL() + "checkParams");
        checkParamsBuilder.setHeader("Content-Type", "application/json");
        try {
            AutoBean bean = AutoBeanUtils.getAutoBean((Object)database);
            String checkParamsJson = AutoBeanCodex.encode((AutoBean)bean).getPayload();
            checkParamsBuilder.sendRequest(checkParamsJson, new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    DataHandler.this.showMessage(DataHandler.this.messages.getString("DataHandler.ERROR_MESSAGE_TITLE"), exception.getMessage(), exception.getMessage().length() > 300);
                }

                public void onResponseReceived(Request request, Response response) {
                    if (response.getStatusCode() == 204 || response.getStatusCode() == 1223) {
                        if (DataHandler.this.databaseConnection == null) {
                            DataHandler.this.databaseConnection = (IDatabaseConnection)DataHandler.this.connectionAutoBeanFactory.iDatabaseConnection().as();
                        }
                        DataHandler.this.databaseConnection.setExtraOptions(new HashMap());
                        DataHandler.this.getInfo(DataHandler.this.databaseConnection);
                        DataHandler.this.databaseConnection.setChanged(true);
                        DataHandler.this.close();
                        if (DataHandler.this.listener != null) {
                            DataHandler.this.listener.onDialogAccept(DataHandler.this.databaseConnection);
                        }
                    } else {
                        DataHandler.this.gatherErrors(response);
                    }
                }
            });
        }
        catch (RequestException e) {
            this.showMessage(this.messages.getString("DataHandler.ERROR_MESSAGE_TITLE"), e.getMessage(), e.getMessage().length() > 300);
        }
    }

    @Bindable
    public void testDatabaseConnection() {
        final IDatabaseConnection database = this.createDatabaseConnection();
        this.getInfo(database);
        if (this.databaseConnection != null) {
            database.setId(this.databaseConnection.getId());
        }
        RequestBuilder checkParamsBuilder = new RequestBuilder(RequestBuilder.POST, DataHandler.getBaseURL() + "checkParams");
        checkParamsBuilder.setHeader("Content-Type", "application/json");
        try {
            AutoBean bean = AutoBeanUtils.getAutoBean((Object)database);
            String checkParamsJson = AutoBeanCodex.encode((AutoBean)bean).getPayload();
            checkParamsBuilder.sendRequest(checkParamsJson, new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    DataHandler.this.showMessage(DataHandler.this.messages.getString("DataHandler.ERROR_MESSAGE_TITLE"), exception.getMessage(), exception.getMessage().length() > 300);
                }

                public void onResponseReceived(Request request, Response response) {
                    int statusCode = response.getStatusCode();
                    if (statusCode == 204 || statusCode == 1223) {
                        RequestBuilder testBuilder = new RequestBuilder(RequestBuilder.PUT, DataHandler.getBaseURL() + "test");
                        testBuilder.setHeader("Content-Type", "application/json");
                        try {
                            AutoBean autoBean = AutoBeanUtils.getAutoBean((Object)database);
                            String testConnectionJson = AutoBeanCodex.encode((AutoBean)autoBean).getPayload();
                            testBuilder.sendRequest(testConnectionJson, new RequestCallback(){

                                public void onError(Request request1, Throwable exception) {
                                    DataHandler.this.showMessage(DataHandler.this.messages.getString("DataHandler.ERROR_MESSAGE_TITLE"), exception.getMessage(), exception.getMessage().length() > 300);
                                }

                                public void onResponseReceived(Request request1, Response response1) {
                                    DataHandler.this.showMessage(DataHandler.this.messages.getString("DataHandler.TEST_MESSAGE_TITLE"), response1.getText(), response1.getText().length() > 300);
                                }
                            });
                        }
                        catch (RequestException e) {
                            DataHandler.this.showMessage(DataHandler.this.messages.getString("DataHandler.ERROR_MESSAGE_TITLE"), e.getMessage(), e.getMessage().length() > 300);
                        }
                    } else {
                        DataHandler.this.gatherErrors(response);
                    }
                }
            });
        }
        catch (RequestException e) {
            this.showMessage(this.messages.getString("DataHandler.ERROR_MESSAGE_TITLE"), e.getMessage(), e.getMessage().length() > 300);
        }
    }

    private void gatherErrors(Response response) {
        if (response.getStatusCode() == 200 && !response.getText().equalsIgnoreCase("null")) {
            String message = "";
            JSONValue jsonValue = JSONParser.parseStrict((String)response.getText());
            String keyItems = "items";
            String starter = "* ";
            if (jsonValue.isObject() != null && jsonValue.isObject().containsKey("items")) {
                JSONValue items = jsonValue.isObject().get("items");
                if (items.isArray() != null) {
                    for (int i = 0; i < items.isArray().size(); ++i) {
                        message = message.concat("* ").concat(items.isArray().get(i).isString().stringValue()).concat(LINE_SEPARATOR);
                    }
                } else {
                    message = items.isString() != null ? message.concat("* ").concat(items.isString().stringValue()).concat(LINE_SEPARATOR) : message.concat("* ").concat(items.toString()).concat(LINE_SEPARATOR);
                }
            } else {
                message = message.concat("* ").concat(jsonValue.toString()).concat(LINE_SEPARATOR);
            }
            this.showMessage(this.messages.getString("DataHandler.CHECK_PARAMS_TITLE"), message, false);
        } else {
            this.showMessage(this.messages.getString("DataHandler.ERROR_MESSAGE_TITLE"), response.getStatusText(), response.getStatusText().length() > 300);
        }
    }

    protected void getInfo(IDatabaseConnection dbConnection) {
        Object[][] values;
        String access;
        this.getControls();
        dbConnection.setName(this.connectionNameBox.getValue());
        String connection = this.getSelectedString(this.connectionBox);
        if (connection != null) {
            dbConnection.setDatabaseType(this.databaseTypeHelper.getDatabaseTypeByName(connection));
        }
        if ((access = this.getSelectedString(this.accessBox)) != null) {
            dbConnection.setAccessType(DatabaseAccessType.getAccessTypeByName((String)access));
        }
        this.getConnectionSpecificInfo(dbConnection);
        if (this.portNumberBox != null) {
            dbConnection.setDatabasePort(this.portNumberBox.getValue());
        }
        if (this.optionsParameterTree != null) {
            values = this.optionsParameterTree.getValues();
            for (int i = 0; i < values.length; ++i) {
                String parameter = (String)values[i][0];
                String value = (String)values[i][1];
                if (value == null) {
                    value = "";
                }
                if (DataHandler.isBlank(parameter)) continue;
                dbConnection.addExtraOption(dbConnection.getDatabaseType().getShortName(), parameter, value);
            }
        }
        if (this.quoteIdentifiersCheck != null) {
            dbConnection.setQuoteAllFields(this.quoteIdentifiersCheck.isChecked());
        }
        if (this.lowerCaseIdentifiersCheck != null) {
            dbConnection.setForcingIdentifiersToLowerCase(this.lowerCaseIdentifiersCheck.isChecked());
        }
        if (this.upperCaseIdentifiersCheck != null) {
            dbConnection.setForcingIdentifiersToUpperCase(this.upperCaseIdentifiersCheck.isChecked());
        }
        if (this.sqlBox != null) {
            dbConnection.setConnectSql(this.sqlBox.getValue());
        }
        if (this.clusteringCheck != null) {
            dbConnection.setPartitioned(this.clusteringCheck.isChecked());
        }
        if (this.clusterParameterTree != null && dbConnection.isPartitioned()) {
            values = this.clusterParameterTree.getValues();
            ArrayList<PartitionDatabaseMeta> pdms = new ArrayList<PartitionDatabaseMeta>();
            for (int i = 0; i < values.length; ++i) {
                String partitionId = (String)values[i][0];
                if (DataHandler.isBlank(partitionId)) continue;
                String hostname = (String)values[i][1];
                String port = (String)values[i][2];
                String dbName = (String)values[i][3];
                String username = (String)values[i][4];
                String password = (String)values[i][5];
                PartitionDatabaseMeta pdm = new PartitionDatabaseMeta(partitionId, hostname, port, dbName);
                pdm.setUsername(username);
                pdm.setPassword(password);
                pdms.add(pdm);
            }
            dbConnection.setPartitioningInformation(pdms);
        }
        if (this.poolingCheck != null) {
            dbConnection.setUsingConnectionPool(this.poolingCheck.isChecked());
        }
        if (dbConnection.isUsingConnectionPool()) {
            if (this.poolSizeBox != null) {
                try {
                    int initialPoolSize = Integer.parseInt(this.poolSizeBox.getValue());
                    dbConnection.setInitialPoolSize(initialPoolSize);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (this.maxPoolSizeBox != null) {
                try {
                    int maxPoolSize = Integer.parseInt(this.maxPoolSizeBox.getValue());
                    dbConnection.setMaximumPoolSize(maxPoolSize);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (this.poolParameterTree != null) {
                Object[][] values2 = this.poolParameterTree.getValues();
                HashMap<String, String> properties = new HashMap<String, String>();
                for (int i = 0; i < values2.length; ++i) {
                    boolean isChecked = false;
                    isChecked = values2[i][0] instanceof Boolean ? ((Boolean)values2[i][0]).booleanValue() : Boolean.valueOf((String)values2[i][0]).booleanValue();
                    if (!isChecked) continue;
                    String parameter = (String)values2[i][1];
                    String value = (String)values2[i][2];
                    if (DataHandler.isBlank(parameter) || DataHandler.isBlank(value)) continue;
                    properties.put(parameter, value);
                }
                dbConnection.setConnectionPoolingProperties(properties);
            }
        }
    }

    private void setInfo(final IDatabaseConnection databaseConnection) {
        if (databaseConnection == null) {
            return;
        }
        if (databaseConnection.getAttributes() == null) {
            databaseConnection.setAttributes(new HashMap());
        }
        this.getControls();
        this.connectionNameBox.setValue(databaseConnection.getName());
        this.fragmentHandler.setDisableRefresh(true);
        if (databaseConnection.getDatabaseType() != null) {
            this.connectionBox.setSelectedItem((Object)databaseConnection.getDatabaseType().getName());
        } else {
            this.connectionBox.setSelectedIndex(0);
        }
        if (databaseConnection.getAccessType() != null) {
            this.accessBox.setSelectedItem((Object)databaseConnection.getAccessType().getName());
        } else {
            this.accessBox.setSelectedIndex(0);
        }
        this.fragmentHandler.setDisableRefresh(false);
        this.fragmentHandler.refreshOptionsWithCallback(new IFragmentHandler.Callback(){

            @Override
            public void callback() {
                DataHandler.this.setConnectionSpecificInfo(databaseConnection);
            }
        });
        if (this.portNumberBox != null) {
            this.portNumberBox.setValue(databaseConnection.getDatabasePort());
        }
        this.setOptionsData(databaseConnection.getExtraOptions());
        if (this.quoteIdentifiersCheck != null) {
            this.quoteIdentifiersCheck.setChecked(databaseConnection.isQuoteAllFields());
        }
        if (this.lowerCaseIdentifiersCheck != null) {
            this.lowerCaseIdentifiersCheck.setChecked(databaseConnection.isForcingIdentifiersToLowerCase());
        }
        if (this.upperCaseIdentifiersCheck != null) {
            this.upperCaseIdentifiersCheck.setChecked(databaseConnection.isForcingIdentifiersToUpperCase());
        }
        if (this.sqlBox != null) {
            this.sqlBox.setValue(databaseConnection.getConnectSql() == null ? "" : databaseConnection.getConnectSql());
        }
        if (this.clusteringCheck != null) {
            this.clusteringCheck.setChecked(databaseConnection.isPartitioned());
        }
        this.setClusterData(databaseConnection.getPartitioningInformation());
        if (this.poolingCheck != null) {
            if (databaseConnection.getId() != null) {
                this.poolingCheck.setChecked(databaseConnection.isUsingConnectionPool());
            } else {
                this.poolingCheck.setChecked(true);
            }
        }
        this.applyPoolProperties();
        if (databaseConnection.isUsingConnectionPool()) {
            if (this.poolSizeBox != null) {
                this.poolSizeBox.setValue(Integer.toString(databaseConnection.getInitialPoolSize()));
            }
            if (this.maxPoolSizeBox != null) {
                this.maxPoolSizeBox.setValue(Integer.toString(databaseConnection.getMaximumPoolSize()));
            }
        }
        this.dialogDeck.setSelectedIndex(0);
        this.deckOptionsBox.setSelectedIndex(0);
        this.setDeckChildIndex();
        this.onPoolingCheck();
        this.onClusterCheck();
    }

    private boolean checkPoolingParameters() {
        ArrayList<String> returnList = new ArrayList<String>();
        if (this.poolParameterTree != null) {
            Object[][] values = this.poolParameterTree.getValues();
            for (int i = 0; i < values.length; ++i) {
                boolean isChecked = false;
                isChecked = values[i][0] instanceof Boolean ? ((Boolean)values[i][0]).booleanValue() : Boolean.valueOf((String)values[i][0]).booleanValue();
                if (!isChecked) continue;
                String parameter = (String)values[i][1];
                String value = (String)values[i][2];
                if (!DataHandler.isBlank(value)) continue;
                returnList.add(parameter);
            }
            if (returnList.size() > 0) {
                String parameters = LINE_SEPARATOR;
                for (String parameter : returnList) {
                    parameters = parameters.concat(parameter).concat(LINE_SEPARATOR);
                }
                String message = this.messages.getString("DataHandler.USER_INVALID_PARAMETERS").concat(parameters);
                this.showMessage(this.messages.getString("DataHandler.ERROR_MESSAGE_TITLE"), message, false);
            }
        }
        return returnList.size() <= 0;
    }

    private void applyPoolProperties() {
        GwtLayoutHandler.deferUpdateUI(this.poolParameterTree, new Command(){

            public void execute() {
                DataHandler.this.restoreDefaults();
                Map poolProperties = DataHandler.this.databaseConnection.getConnectionPoolingProperties();
                if (poolProperties != null && poolProperties.size() > 0) {
                    DataHandler.this.setPoolProperties(poolProperties);
                }
            }
        });
    }

    private void setPoolProperties(Map<String, String> properties) {
        if (this.poolParameterTree != null) {
            Object[][] values = this.poolParameterTree.getValues();
            for (int i = 0; i < values.length; ++i) {
                String parameter = (String)values[i][1];
                boolean isChecked = properties.containsKey(parameter);
                if (!isChecked) continue;
                XulTreeRow row = this.poolParameterTree.getRootChildren().getItem(i).getRow();
                row.addCellText(0, "true");
                String value = properties.get(parameter);
                row.addCellText(2, value);
            }
        }
    }

    @Bindable
    public void restoreDefaults() {
        if (this.poolingParameters != null && this.poolParameterTree != null) {
            for (int i = 0; i < this.poolParameterTree.getRootChildren().getItemCount(); ++i) {
                XulTreeItem item = this.poolParameterTree.getRootChildren().getItem(i);
                String parameterName = item.getRow().getCell(1).getLabel();
                String defaultValue = DatabaseConnectionPoolParameter.findParameter((String)parameterName, (DatabaseConnectionPoolParameter[])this.poolingParameters).getDefaultValue();
                if (DataHandler.isBlank(defaultValue)) {
                    item.getRow().addCellText(2, "");
                }
                item.getRow().addCellText(2, defaultValue);
                item.getRow().addCellText(0, "false");
            }
        }
    }

    private void setDefaultPoolParameters() {
        RequestBuilder poolingParamsBuilder = new RequestBuilder(RequestBuilder.GET, DataHandler.getBaseURL() + "poolingParameters");
        try {
            poolingParamsBuilder.sendRequest(null, new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    DataHandler.this.showMessage(DataHandler.this.messages.getString("DataHandler.ERROR_MESSAGE_TITLE"), exception.getMessage(), exception.getMessage().length() > 300);
                }

                public void onResponseReceived(Request request, Response response) {
                    Boolean success = response.getStatusCode() == 200;
                    if (success.booleanValue()) {
                        AutoBean bean = AutoBeanCodex.decode((AutoBeanFactory)DataHandler.this.connectionAutoBeanFactory, IDatabaseConnectionPoolParameterList.class, (String)response.getText());
                        final IDatabaseConnectionPoolParameterList paramListWrapper = (IDatabaseConnectionPoolParameterList)bean.as();
                        DataHandler.access$602(DataHandler.this, new DatabaseConnectionPoolParameter[paramListWrapper.getDatabaseConnectionPoolParameters().size()]);
                        GwtLayoutHandler.deferUpdateUI(DataHandler.this.poolParameterTree, new Command(){

                            public void execute() {
                                if (DataHandler.this.poolParameterTree != null) {
                                    int i = 0;
                                    for (IDatabaseConnectionPoolParameter parameter : paramListWrapper.getDatabaseConnectionPoolParameters()) {
                                        XulTreeRow row = DataHandler.this.poolParameterTree.getRootChildren().addNewRow();
                                        row.addCellText(0, "false");
                                        row.addCellText(1, parameter.getParameter());
                                        row.addCellText(2, parameter.getDefaultValue());
                                        ((DataHandler)DataHandler.this).poolingParameters[i] = new DatabaseConnectionPoolParameter(parameter.getParameter(), parameter.getDefaultValue(), parameter.getDescription());
                                        ++i;
                                    }
                                    DataHandler.this.poolParameterTree.setRows(DataHandler.this.poolParameterTree.getRows());
                                }
                            }
                        });
                    }
                }
            });
        }
        catch (RequestException e) {
            this.showMessage(this.messages.getString("DataHandler.ERROR_MESSAGE_TITLE"), e.getMessage(), e.getMessage().length() > 300);
        }
    }

    private void clearOptions() {
        Object[][] values = this.optionsParameterTree.getValues();
        for (int i = values.length - 1; i >= 0; --i) {
            this.optionsParameterTree.getRootChildren().removeItem(i);
        }
    }

    private void setOptionsData(final Map<String, String> extraOptions) {
        if (this.optionsParameterTree == null) {
            return;
        }
        GwtLayoutHandler.deferUpdateUI(this.optionsParameterTree, new Command(){

            public void execute() {
                DataHandler.this.clearOptions();
                if (extraOptions != null) {
                    Iterator keys = extraOptions.keySet().iterator();
                    String connection = DataHandler.this.getSelectedString(DataHandler.this.connectionBox);
                    IDatabaseType currentType = null;
                    if (connection != null) {
                        currentType = DataHandler.this.databaseTypeHelper.getDatabaseTypeByName(connection);
                    }
                    while (keys.hasNext()) {
                        String parameter = (String)keys.next();
                        if (DataHandler.isBlank(parameter)) continue;
                        String value = (String)extraOptions.get(parameter);
                        int dotIndex = parameter.indexOf(46);
                        if (dotIndex < 0) continue;
                        String parameterOption = parameter.substring(dotIndex + 1);
                        String databaseTypeString = parameter.substring(0, dotIndex);
                        IDatabaseType databaseType = DataHandler.this.databaseTypeHelper.getDatabaseTypeByShortName(databaseTypeString);
                        if (currentType != databaseType) continue;
                        XulTreeRow row = DataHandler.this.optionsParameterTree.getRootChildren().addNewRow();
                        row.addCellText(0, parameterOption);
                        row.addCellText(1, value);
                    }
                }
                int numToAdd = 5;
                if (extraOptions != null && extraOptions.keySet().size() > 0) {
                    numToAdd = 1;
                }
                while (numToAdd-- > 0) {
                    XulTreeRow row = DataHandler.this.optionsParameterTree.getRootChildren().addNewRow();
                    row.addCellText(0, "");
                    row.addCellText(1, "");
                }
            }
        });
    }

    private void setClusterData(final List<PartitionDatabaseMeta> clusterInformation) {
        if (this.clusterParameterTree == null) {
            return;
        }
        GwtLayoutHandler.deferUpdateUI(this.clusterParameterTree, new Command(){

            public void execute() {
                if (clusterInformation != null && DataHandler.this.clusterParameterTree != null) {
                    for (int i = 0; i < clusterInformation.size(); ++i) {
                        PartitionDatabaseMeta meta = (PartitionDatabaseMeta)clusterInformation.get(i);
                        XulTreeRow row = DataHandler.this.clusterParameterTree.getRootChildren().addNewRow();
                        row.addCellText(0, meta.getPartitionId() == null ? "" : meta.getPartitionId());
                        row.addCellText(1, meta.getHostname() == null ? "" : meta.getHostname());
                        row.addCellText(2, meta.getPort() == null ? "" : meta.getPort());
                        row.addCellText(3, meta.getDatabaseName() == null ? "" : meta.getDatabaseName());
                        row.addCellText(4, meta.getUsername() == null ? "" : meta.getUsername());
                        row.addCellText(5, meta.getPassword() == null ? "" : meta.getPassword());
                    }
                }
                int numToAdd = 5;
                if (clusterInformation != null && clusterInformation.size() > 0) {
                    numToAdd = 1;
                }
                while (numToAdd-- > 0) {
                    XulTreeRow row = DataHandler.this.clusterParameterTree.getRootChildren().addNewRow();
                    row.addCellText(0, "");
                    row.addCellText(1, "");
                    row.addCellText(2, "");
                    row.addCellText(3, "");
                    row.addCellText(4, "");
                    row.addCellText(5, "");
                }
            }
        });
    }

    @Bindable
    public void poolingRowChange(int idx) {
        if (this.poolingParameters != null && idx != -1) {
            if (idx >= this.poolingParameters.length) {
                idx = this.poolingParameters.length - 1;
            }
            if (idx < 0) {
                idx = 0;
            }
            this.poolingDescription.setValue(this.poolingParameters[idx].getDescription());
            XulTreeRow row = this.poolParameterTree.getRootChildren().getItem(idx).getRow();
            if (row.getSelectedColumnIndex() == 2) {
                row.addCellText(0, "true");
            }
        }
    }

    private void copyConnectionSpecificInfo(IDatabaseConnection from, IDatabaseConnection to) {
        if (from.getHostname() != null) {
            to.setHostname(from.getHostname());
        }
        if (from.getDatabaseName() != null) {
            to.setDatabaseName(from.getDatabaseName());
        }
        if (from.getUsername() != null) {
            to.setUsername(from.getUsername());
        }
        if (from.getPassword() != null) {
            to.setPassword(from.getPassword());
        }
        to.setStreamingResults(from.isStreamingResults());
        if (from.getDataTablespace() != null) {
            to.setDataTablespace(from.getDataTablespace());
        }
        if (from.getIndexTablespace() != null) {
            to.setIndexTablespace(from.getIndexTablespace());
        }
        to.setExtraOptions(from.getExtraOptions());
        to.setUsingDoubleDecimalAsSchemaTableSeparator(from.isUsingDoubleDecimalAsSchemaTableSeparator());
        if (from.getAttributes().get("SAPLanguage") != null) {
            to.getAttributes().put("SAPLanguage", from.getAttributes().get("SAPLanguage"));
        }
        if (from.getAttributes().get("SAPSystemNumber") != null) {
            to.getAttributes().put("SAPSystemNumber", from.getAttributes().get("SAPSystemNumber"));
        }
        if (from.getAttributes().get("SAPClient") != null) {
            to.getAttributes().put("SAPClient", from.getAttributes().get("SAPClient"));
        }
        if (from.getAttributes().get("CUSTOM_URL") != null) {
            to.getAttributes().put("CUSTOM_URL", from.getAttributes().get("CUSTOM_URL"));
        }
        if (from.getAttributes().get("CUSTOM_DRIVER_CLASS") != null) {
            to.getAttributes().put("CUSTOM_DRIVER_CLASS", from.getAttributes().get("CUSTOM_DRIVER_CLASS"));
        }
        if (from.getInformixServername() != null) {
            to.setInformixServername(from.getInformixServername());
        }
    }

    private void getConnectionSpecificInfo(IDatabaseConnection meta) {
        String value;
        if (this.hostNameBox != null) {
            meta.setHostname(this.hostNameBox.getValue());
        }
        if (this.databaseNameBox != null) {
            meta.setDatabaseName(this.databaseNameBox.getValue());
        }
        if (this.userNameBox != null) {
            meta.setUsername(this.userNameBox.getValue());
        }
        if (this.passwordBox != null) {
            meta.setPassword(this.passwordBox.getValue());
        }
        if (this.resultStreamingCursorCheck != null) {
            meta.setStreamingResults(this.resultStreamingCursorCheck.isChecked());
        }
        if (this.dataTablespaceBox != null) {
            meta.setDataTablespace(this.dataTablespaceBox.getValue());
        }
        if (this.indexTablespaceBox != null) {
            meta.setIndexTablespace(this.indexTablespaceBox.getValue());
        }
        if (this.serverInstanceBox != null && !DataHandler.isBlank(value = this.serverInstanceBox.getValue())) {
            meta.setSQLServerInstance(this.serverInstanceBox.getValue());
        }
        if (this.doubleDecimalSeparatorCheck != null) {
            meta.setUsingDoubleDecimalAsSchemaTableSeparator(this.doubleDecimalSeparatorCheck.isChecked());
        }
        if (this.useIntegratedSecurityCheck != null) {
            meta.getAttributes().put("MSSQLUseIntegratedSecurity", "" + this.useIntegratedSecurityCheck.isChecked());
        }
        if (this.languageBox != null) {
            meta.getAttributes().put("SAPLanguage", this.languageBox.getValue());
        }
        if (this.systemNumberBox != null) {
            meta.getAttributes().put("SAPSystemNumber", this.systemNumberBox.getValue());
        }
        if (this.clientBox != null) {
            meta.getAttributes().put("SAPClient", this.clientBox.getValue());
        }
        if (this.customUrlBox != null) {
            meta.getAttributes().put("CUSTOM_URL", this.customUrlBox.getValue() != null ? this.customUrlBox.getValue() : "");
        }
        if (this.customDriverClassBox != null) {
            meta.getAttributes().put("CUSTOM_DRIVER_CLASS", this.customDriverClassBox.getValue());
        }
        if (this.serverNameBox != null) {
            meta.setInformixServername(this.serverNameBox.getValue());
        }
    }

    private void setConnectionSpecificInfo(IDatabaseConnection meta) {
        String instance;
        this.getControls();
        if (this.hostNameBox != null) {
            this.hostNameBox.setValue(meta.getHostname());
        }
        if (this.databaseNameBox != null) {
            this.databaseNameBox.setValue(meta.getDatabaseName());
        }
        if (this.userNameBox != null) {
            this.userNameBox.setValue(meta.getUsername());
        }
        if (this.passwordBox != null) {
            this.passwordBox.setValue(meta.getPassword());
        }
        if (this.resultStreamingCursorCheck != null) {
            this.resultStreamingCursorCheck.setChecked(meta.isStreamingResults());
        }
        if (this.dataTablespaceBox != null) {
            this.dataTablespaceBox.setValue(meta.getDataTablespace());
        }
        if (this.indexTablespaceBox != null) {
            this.indexTablespaceBox.setValue(meta.getIndexTablespace());
        }
        if (this.serverInstanceBox != null && !DataHandler.isBlank(instance = meta.getSQLServerInstance())) {
            this.serverInstanceBox.setValue(instance);
        }
        if (this.doubleDecimalSeparatorCheck != null) {
            this.doubleDecimalSeparatorCheck.setChecked(meta.isUsingDoubleDecimalAsSchemaTableSeparator());
        }
        if (this.useIntegratedSecurityCheck != null) {
            this.useIntegratedSecurityCheck.setChecked("true".equals(meta.getAttributes().get("MSSQLUseIntegratedSecurity")));
        }
        if (this.languageBox != null) {
            this.languageBox.setValue((String)meta.getAttributes().get("SAPLanguage"));
        }
        if (this.systemNumberBox != null) {
            this.systemNumberBox.setValue((String)meta.getAttributes().get("SAPSystemNumber"));
        }
        if (this.clientBox != null) {
            this.clientBox.setValue((String)meta.getAttributes().get("SAPClient"));
        }
        if (this.customUrlBox != null) {
            this.customUrlBox.setValue((String)meta.getAttributes().get("CUSTOM_URL"));
        }
        if (this.customDriverClassBox != null) {
            this.customDriverClassBox.setValue((String)meta.getAttributes().get("CUSTOM_DRIVER_CLASS"));
        }
        if (this.serverNameBox != null) {
            this.serverNameBox.setValue(meta.getInformixServername());
        }
    }

    protected void getControls() {
        this.dialogDeck = (XulDeck)this.document.getElementById("dialog-panel-deck");
        this.deckOptionsBox = (XulListbox)this.document.getElementById("deck-options-list");
        this.connectionBox = (XulListbox)this.document.getElementById("connection-type-list");
        this.accessBox = (XulListbox)this.document.getElementById("access-type-list");
        this.connectionNameBox = (XulTextbox)this.document.getElementById("connection-name-text");
        this.hostNameBox = (XulTextbox)this.document.getElementById("server-host-name-text");
        this.databaseNameBox = (XulTextbox)this.document.getElementById("database-name-text");
        this.portNumberBox = (XulTextbox)this.document.getElementById("port-number-text");
        this.userNameBox = (XulTextbox)this.document.getElementById("username-text");
        this.passwordBox = (XulTextbox)this.document.getElementById("password-text");
        this.dataTablespaceBox = (XulTextbox)this.document.getElementById("data-tablespace-text");
        this.indexTablespaceBox = (XulTextbox)this.document.getElementById("index-tablespace-text");
        this.serverInstanceBox = (XulTextbox)this.document.getElementById("instance-text");
        this.serverNameBox = (XulTextbox)this.document.getElementById("server-name-text");
        this.customUrlBox = (XulTextbox)this.document.getElementById("custom-url-text");
        this.customDriverClassBox = (XulTextbox)this.document.getElementById("custom-driver-class-text");
        this.languageBox = (XulTextbox)this.document.getElementById("language-text");
        this.systemNumberBox = (XulTextbox)this.document.getElementById("system-number-text");
        this.clientBox = (XulTextbox)this.document.getElementById("client-text");
        this.doubleDecimalSeparatorCheck = (XulCheckbox)this.document.getElementById("decimal-separator-check");
        this.useIntegratedSecurityCheck = (XulCheckbox)this.document.getElementById("use-integrated-security-check");
        this.resultStreamingCursorCheck = (XulCheckbox)this.document.getElementById("result-streaming-check");
        this.poolingCheck = (XulCheckbox)this.document.getElementById("use-pool-check");
        this.clusteringCheck = (XulCheckbox)this.document.getElementById("use-cluster-check");
        this.clusterParameterDescriptionLabel = (XulLabel)this.document.getElementById("cluster-parameter-description-label");
        this.poolSizeLabel = (XulLabel)this.document.getElementById("pool-size-label");
        this.poolSizeBox = (XulTextbox)this.document.getElementById("pool-size-text");
        this.maxPoolSizeLabel = (XulLabel)this.document.getElementById("max-pool-size-label");
        this.maxPoolSizeBox = (XulTextbox)this.document.getElementById("max-pool-size-text");
        this.poolParameterTree = (XulTree)this.document.getElementById("pool-parameter-tree");
        this.clusterParameterTree = (XulTree)this.document.getElementById("cluster-parameter-tree");
        this.optionsParameterTree = (XulTree)this.document.getElementById("options-parameter-tree");
        this.poolingDescription = (XulTextbox)this.document.getElementById("pooling-description");
        this.poolingParameterDescriptionLabel = (XulLabel)this.document.getElementById("pool-parameter-description-label");
        this.poolingDescriptionLabel = (XulLabel)this.document.getElementById("pooling-description-label");
        this.quoteIdentifiersCheck = (XulCheckbox)this.document.getElementById("quote-identifiers-check");
        this.lowerCaseIdentifiersCheck = (XulCheckbox)this.document.getElementById("force-lower-case-check");
        this.upperCaseIdentifiersCheck = (XulCheckbox)this.document.getElementById("force-upper-case-check");
        this.sqlBox = (XulTextbox)this.document.getElementById("sql-text");
    }

    private void showMessage(String title, String message, boolean scroll) {
        try {
            XulMessageBox box = (XulMessageBox)this.document.createElement("messagebox");
            box.setTitle(title);
            box.setMessage(message);
            box.setModalParent(((XulRoot)this.document.getElementById("general-datasource-window")).getRootObject());
            if (scroll) {
                box.setScrollable(true);
                box.setWidth(500);
                box.setHeight(400);
            }
            box.open();
        }
        catch (XulException e) {
            System.out.println("Error creating messagebox " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void handleUseSecurityCheckbox() {
        if (this.useIntegratedSecurityCheck != null) {
            if (this.useIntegratedSecurityCheck.isChecked()) {
                this.userNameBox.setDisabled(true);
                this.passwordBox.setDisabled(true);
            } else {
                this.userNameBox.setDisabled(false);
                this.passwordBox.setDisabled(false);
            }
        }
    }

    @Bindable
    public void showContextHelp() {
        this.jsni_showContextHelp();
    }

    private native void jsni_showContextHelp();

    public static String getBaseURL() {
        String moduleUrl = GWT.getModuleBaseURL();
        if (moduleUrl.indexOf("content") > -1) {
            String baseUrl = moduleUrl.substring(0, moduleUrl.indexOf("content"));
            return baseUrl + "plugin/data-access/api/connection/";
        }
        return moduleUrl + "plugin/data-access/api/connection/";
    }

    public void setFragmentHandlerDisableRefresh(boolean disableRefresh) {
        if (this.fragmentHandler != null) {
            this.fragmentHandler.setDisableRefresh(disableRefresh);
        }
    }

    private void traverseDomSetReadOnly(XulComponent component, boolean readonly) {
        component.setDisabled(readonly);
        List children = component.getChildNodes();
        if (children != null && children.size() > 0) {
            for (XulComponent child : children) {
                child.setDisabled(readonly);
                this.traverseDomSetReadOnly(child, readonly);
            }
        }
    }

    private static final boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    static /* synthetic */ DatabaseConnectionPoolParameter[] access$602(DataHandler x0, DatabaseConnectionPoolParameter[] x1) {
        x0.poolingParameters = x1;
        return x1;
    }
}

