/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.packager.dependencies;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.packager.dependencies.FileDependency;
import pt.webdetails.cpf.packager.dependencies.JSMin;
import pt.webdetails.cpf.packager.dependencies.PackagedFileDependency;
import pt.webdetails.cpf.packager.origin.PathOrigin;
import pt.webdetails.cpf.repository.api.IRWAccess;

public class JsMinifiedDependency
extends PackagedFileDependency {
    private static Log logger = LogFactory.getLog(JsMinifiedDependency.class);

    public JsMinifiedDependency(PathOrigin origin, String path, IRWAccess writer, Iterable<FileDependency> inputFiles, IUrlProvider urlProvider) {
        super(origin, path, writer, inputFiles, urlProvider);
    }

    @Override
    protected InputStream minifyPackage(Iterable<FileDependency> inputFiles) {
        return new SequenceInputStream(new JsMinificationEnumeration(inputFiles.iterator()));
    }

    public static class JsMinificationEnumeration
    implements Enumeration<InputStream> {
        private Iterator<FileDependency> deps;

        public JsMinificationEnumeration(Iterator<FileDependency> deps) {
            this.deps = deps;
        }

        @Override
        public boolean hasMoreElements() {
            return this.deps.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream nextElement() {
            FileDependency dep = this.deps.next();
            InputStream input = null;
            try {
                input = dep.getFileInputStream();
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                JSMin jsMin = new JSMin(input, bytesOut);
                jsMin.jsmin();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytesOut.toByteArray());
                return byteArrayInputStream;
            }
            catch (ParseException e) {
                logger.error((Object)("Error parsing javascript dependency " + dep + " at offset " + e.getErrorOffset() + ". Skipping.."), (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)("Error getting input stream for dependency " + dep + ". Skipping.."), (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)String.format("Error while processing dependency %s. Skipping..", dep));
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
            return Util.toInputStream("");
        }
    }
}

