/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulTab;
import org.pentaho.ui.xul.components.XulTabpanel;
import org.pentaho.ui.xul.containers.XulTabbox;
import org.pentaho.ui.xul.containers.XulTabpanels;
import org.pentaho.ui.xul.containers.XulTabs;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.AbstractSwtXulContainer;
import org.pentaho.ui.xul.swt.tags.SwtTab;
import org.pentaho.ui.xul.swt.tags.SwtTabpanels;
import org.pentaho.ui.xul.swt.tags.SwtTabs;

public class SwtTabbox
extends AbstractSwtXulContainer
implements XulTabbox {
    private CTabFolder tabFolder;
    private SwtTabpanels panels;
    private SwtTabs tabs;
    private int selectedIndex = -1;
    private boolean closable;
    private String onclose;
    private XulDomContainer domContainer;
    private boolean suppressRemoveEvents;

    public SwtTabbox(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("tabbox");
        int style = 2;
        if (self.getAttributeValue("closable") != null && self.getAttributeValue("closable").equals("true")) {
            style |= 0x40;
        }
        this.domContainer = domContainer;
        this.tabFolder = new CTabFolder((Composite)parent.getManagedObject(), style);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.tabFolder.setSimple(false);
        this.tabFolder.setUnselectedImageVisible(true);
        this.tabFolder.setUnselectedCloseVisible(true);
        this.tabFolder.setBorderVisible(true);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int prevVal = SwtTabbox.this.selectedIndex;
                SwtTabbox.this.selectedIndex = SwtTabbox.this.tabFolder.getSelectionIndex();
                XulTabs tabs = null;
                for (XulComponent c : SwtTabbox.this.getChildNodes()) {
                    if (!(c instanceof XulTabs)) continue;
                    tabs = (XulTabs)c;
                }
                XulTab tab = (XulTab)tabs.getChildNodes().get(SwtTabbox.this.selectedIndex);
                if (StringUtils.isNotBlank((String)tab.getOnclick())) {
                    SwtTabbox.this.invoke(tab.getOnclick());
                }
                SwtTabbox.this.changeSupport.firePropertyChange("selectedIndex", prevVal, SwtTabbox.this.selectedIndex);
            }
        });
        this.tabFolder.addCTabFolder2Listener(new CTabFolder2Listener(){

            public void close(CTabFolderEvent arg0) {
                block6: {
                    if (SwtTabbox.this.onclose != null) {
                        try {
                            Boolean returnVal;
                            int pos = 0;
                            for (int i = 0; i < SwtTabbox.this.tabFolder.getItems().length; ++i) {
                                if (SwtTabbox.this.tabFolder.getItems()[i] != arg0.item) continue;
                                pos = i;
                                break;
                            }
                            if ((returnVal = (Boolean)SwtTabbox.this.domContainer.invoke(SwtTabbox.this.onclose, new Object[]{pos})).booleanValue()) {
                                SwtTabbox.this.remove(pos);
                                break block6;
                            }
                            arg0.doit = false;
                        }
                        catch (XulException e) {
                            e.printStackTrace();
                        }
                    } else {
                        SwtTabbox.this.remove(SwtTabbox.this.tabFolder.getSelectionIndex());
                    }
                }
            }

            public void maximize(CTabFolderEvent arg0) {
            }

            public void minimize(CTabFolderEvent arg0) {
            }

            public void restore(CTabFolderEvent arg0) {
            }

            public void showList(CTabFolderEvent arg0) {
            }
        });
        this.tabFolder.setSelectionBackground(new Color[]{this.tabFolder.getDisplay().getSystemColor(18), this.tabFolder.getDisplay().getSystemColor(19)}, new int[]{55}, true);
        this.setManagedObject(this.tabFolder);
    }

    private void remove(int pos) {
        this.suppressRemoveEvents = true;
        this.tabs.removeChild((Element)this.tabs.getChildNodes().get(pos));
        this.panels.removeChild((Element)this.panels.getChildNodes().get(pos));
        if (this.tabs.getChildNodes().size() == 0) {
            this.setSelectedIndex(-1);
        }
        this.suppressRemoveEvents = false;
    }

    @Override
    public void addChild(Element ele) {
        super.addChild(ele);
        if (ele instanceof SwtTabs) {
            this.tabs = (SwtTabs)ele;
        } else if (ele instanceof SwtTabpanels) {
            this.panels = (SwtTabpanels)ele;
        }
    }

    public int getSelectedIndex() {
        return this.tabFolder.getSelectionIndex();
    }

    public XulTabpanel getSelectedPanel() {
        return this.panels.getTabpanelByIndex(this.getSelectedIndex());
    }

    public XulTabpanels getTabpanels() {
        return this.panels;
    }

    public XulTabs getTabs() {
        return this.tabs;
    }

    public void setSelectedIndex(int index) {
        int prevVal = this.selectedIndex;
        this.selectedIndex = index;
        this.changeSupport.firePropertyChange("selectedIndex", prevVal, this.selectedIndex);
        if (this.initialized) {
            this.tabFolder.setSelection(this.selectedIndex);
            int n = this.tabFolder.getSelectionIndex();
        }
    }

    @Override
    public void layout() {
        int i;
        CTabItem[] t = this.tabFolder.getItems();
        for (i = 0; i < t.length; ++i) {
            t[i].dispose();
        }
        for (i = 0; i < this.tabs.getChildNodes().size(); ++i) {
            SwtTab tab;
            int style = 0;
            int tabIndex = 0;
            if (this.isClosable()) {
                style = 21;
            }
            if (!(tab = (SwtTab)((Object)this.tabs.getChildNodes().get(i))).isVisible()) continue;
            CTabItem item = new CTabItem(this.tabFolder, style);
            item.setText(this.tabs.getTabByIndex(i).getLabel());
            if (this.panels.getChildNodes().size() <= i) break;
            item.setControl((Control)this.panels.getTabpanelByIndex(i).getManagedObject());
            this.tabFolder.getItem(tabIndex++).getControl().setEnabled(!this.tabs.getTabByIndex(i).isDisabled());
        }
        this.initialized = true;
        this.tabFolder.layout(true, true);
        if (this.selectedIndex < 0 && this.tabFolder.getItemCount() > 0) {
            this.selectedIndex = 0;
        }
        this.setSelectedIndex(this.selectedIndex);
    }

    public void setTabDisabledAt(boolean flag, int pos) {
        this.tabFolder.getItem(pos).getControl().setEnabled(!flag);
    }

    public void setTabVisibleAt(boolean flag, int pos) {
        this.tabFolder.getItem(pos).getControl().setVisible(flag);
    }

    public void updateTabState() {
        for (int i = 0; i < this.tabs.getChildNodes().size(); ++i) {
            this.tabFolder.getItem(i).setText("" + this.tabs.getTabByIndex(i).getLabel());
            Control control = this.tabFolder.getItem(i).getControl();
            if (control == null) continue;
            this.tabFolder.getItem(i).getControl().setEnabled(!this.tabs.getTabByIndex(i).isDisabled());
        }
    }

    public void removeTab(int idx) {
        if (this.suppressRemoveEvents) {
            return;
        }
        if (this.tabFolder.getItemCount() >= idx) {
            this.tabFolder.getItem(idx).dispose();
        }
    }

    public void removeTabpanel(int idx) {
        if (this.suppressRemoveEvents) {
            return;
        }
        if (this.tabFolder.getItemCount() > idx) {
            this.tabFolder.getItem(idx).getControl().dispose();
        }
    }

    public void addTab(int idx) {
        int style = 0;
        if (this.isClosable()) {
            style = 21;
        }
        CTabItem item = new CTabItem(this.tabFolder, style);
        String lbl = this.tabs.getTabByIndex(idx).getLabel();
        if (lbl != null) {
            item.setText(lbl);
        }
        if (this.selectedIndex < 0) {
            this.selectedIndex = 0;
        }
        this.setSelectedIndex(this.selectedIndex);
    }

    public void addTabpanel(int idx) {
        if (this.tabFolder.getItemCount() <= idx || this.panels.getChildNodes().size() <= idx) {
            return;
        }
        CTabItem item = this.tabFolder.getItem(idx);
        Control control = (Control)this.panels.getTabpanelByIndex(idx).getManagedObject();
        if (control.getParent() != this.tabFolder) {
            control.setParent((Composite)this.tabFolder);
        }
        item.setControl(control);
        item.getControl().setEnabled(!this.tabs.getTabByIndex(idx).isDisabled());
    }

    public void setClosable(boolean flag) {
        this.closable = flag;
    }

    public boolean isClosable() {
        return this.closable;
    }

    public void setOnclose(String command) {
        this.onclose = command;
    }
}

