/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.script.ScriptEngineFactory;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataFactoryEditorSupport;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui.Messages;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui.QueryEditorPanel;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public abstract class ScriptTemplateAction
extends AbstractAction {
    private static final Log logger = LogFactory.getLog(ScriptTemplateAction.class);
    private static final String TEMPLATE_LOCATION_PATTERN = "/org/pentaho/reporting/engine/classic/core/designtime/datafactory/scripts/%s-template-%s.txt";
    private URL resource;
    private boolean global;

    protected ScriptTemplateAction(boolean global) {
        this.global = global;
        this.putValue("Name", Messages.getString("QueryEditorPanel.InsertTemplate", new Object[0]));
        this.setEnabled(false);
    }

    protected URL getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.resource == null) {
            return;
        }
        if (this.checkOverwriteText()) {
            return;
        }
        try {
            InputStreamReader r = new InputStreamReader(this.resource.openStream(), "UTF-8");
            try {
                StringWriter w = new StringWriter();
                IOUtils.getInstance().copyWriter((Reader)r, (Writer)w);
                this.setText(w.toString());
            }
            finally {
                r.close();
            }
        }
        catch (IOException ex) {
            logger.warn((Object)"Unable to read template.", (Throwable)ex);
        }
    }

    private boolean checkOverwriteText() {
        return !StringUtils.isEmpty((String)this.getText(), (boolean)true) && JOptionPane.showConfirmDialog(this.getParentComponent(), Messages.getString("QueryEditorPanel.OverwriteScript", new Object[0]), Messages.getString("QueryEditorPanel.OverwriteScriptTitle", new Object[0]), 0) != 0;
    }

    protected abstract Component getParentComponent();

    protected abstract void setText(String var1);

    protected abstract String getText();

    public void update(ScriptEngineFactory engine) {
        if (engine == null) {
            this.setEnabled(false);
            this.resource = null;
            return;
        }
        String key = DataFactoryEditorSupport.mapLanguageToSyntaxHighlighting(engine);
        if (key.startsWith("text/")) {
            key = key.substring(5);
        }
        String templateType = this.isGlobal() ? "global" : "query";
        this.resource = QueryEditorPanel.class.getResource(String.format(TEMPLATE_LOCATION_PATTERN, templateType, key));
        if (this.resource == null && logger.isDebugEnabled()) {
            logger.debug((Object)("No template for " + templateType + " script in language " + key));
        }
        this.setEnabled(this.resource != null);
    }

    protected boolean isGlobal() {
        return this.global;
    }
}

