/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.DataFilter;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.filter.FormatSpecification;
import org.pentaho.reporting.engine.classic.core.filter.RawDataSource;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;

public class StringFilter
implements DataFilter,
RawDataSource {
    private DataSource source;
    private String nullvalue;

    public void setNullValue(String nullvalue) {
        this.nullvalue = nullvalue;
    }

    public String getNullValue() {
        return this.nullvalue;
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        DataSource ds = this.getDataSource();
        if (ds == null) {
            return this.getNullValue();
        }
        Object o = ds.getValue(runtime, element);
        if (o == null) {
            return this.getNullValue();
        }
        String retval = ElementTypeUtils.toString(o);
        if (retval == null) {
            return this.getNullValue();
        }
        return retval;
    }

    @Override
    public DataSource getDataSource() {
        return this.source;
    }

    @Override
    public void setDataSource(DataSource ds) {
        if (ds == null) {
            throw new NullPointerException();
        }
        this.source = ds;
    }

    @Override
    public StringFilter clone() throws CloneNotSupportedException {
        StringFilter f = (StringFilter)super.clone();
        if (this.source != null) {
            f.source = this.source.clone();
        }
        return f;
    }

    @Override
    public Object getRawValue(ExpressionRuntime runtime, ReportElement element) {
        if (this.source instanceof RawDataSource) {
            RawDataSource rawDataSource = (RawDataSource)this.source;
            return rawDataSource.getRawValue(runtime, element);
        }
        return this.source.getValue(runtime, element);
    }

    @Override
    public FormatSpecification getFormatString(ExpressionRuntime runtime, ReportElement element, FormatSpecification formatSpecification) {
        if (this.source instanceof RawDataSource) {
            RawDataSource rds = (RawDataSource)this.source;
            return rds.getFormatString(runtime, element, formatSpecification);
        }
        if (formatSpecification == null) {
            formatSpecification = new FormatSpecification();
        }
        formatSpecification.redefine(0, null);
        return formatSpecification;
    }
}

