/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.AggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.util.Sequence;

public class TotalItemCountFunction
extends AbstractFunction
implements AggregationFunction {
    private transient HashMap<ReportStateKey, Sequence<Integer>> results = new HashMap();
    private transient int lastGroupSequenceNumber;
    private String group;
    private transient Sequence<Integer> result;
    private transient ReportStateKey globalStateKey;
    protected transient ReportStateKey currentGroupKey;
    private String crosstabFilterGroup;

    @Override
    public void reportInitialized(ReportEvent event) {
        this.globalStateKey = event.getState().getProcessKey();
        if (this.isPrepareRunLevel(event)) {
            this.result = new Sequence();
            this.results.clear();
            this.results.put(this.globalStateKey, this.result);
            this.lastGroupSequenceNumber = 0;
        } else {
            this.result = this.results.get(this.globalStateKey);
            this.lastGroupSequenceNumber = 0;
        }
    }

    protected boolean isPrepareRunLevel(ReportEvent event) {
        return FunctionUtilities.isDefinedPrepareRunLevel(this, event);
    }

    @Override
    public void groupStarted(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            this.currentGroupKey = event.getState().getProcessKey();
            if (this.isPrepareRunLevel(event)) {
                this.clear();
                this.results.put(this.globalStateKey, this.result);
                this.results.put(this.currentGroupKey, this.result);
            } else {
                this.result = this.results.get(this.currentGroupKey);
            }
        }
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    protected void clear() {
        this.result = new Sequence();
        this.lastGroupSequenceNumber = 0;
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        if (!this.isPrepareRunLevel(event)) {
            return;
        }
        Integer oldValue = this.result.get(this.lastGroupSequenceNumber);
        if (oldValue == null) {
            this.result.set(this.lastGroupSequenceNumber, 1);
        } else {
            this.result.set(this.lastGroupSequenceNumber, oldValue + 1);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TotalItemCountFunction o = (TotalItemCountFunction)super.clone();
        o.results = (HashMap)this.results.clone();
        for (Map.Entry<ReportStateKey, Sequence<Integer>> entry : this.results.entrySet()) {
            if (entry.getKey() == this.globalStateKey || entry.getKey() == this.currentGroupKey) continue;
            o.results.put(entry.getKey(), (Sequence<Integer>)entry.getValue().clone());
        }
        if (this.result != null) {
            o.result = this.result.clone();
            o.results.put(this.globalStateKey, o.result);
            o.results.put(this.currentGroupKey, o.result);
        }
        return o;
    }

    @Override
    public void summaryRowSelection(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public Object getValue() {
        if (this.result == null) {
            return 0;
        }
        Integer value = this.result.get(this.lastGroupSequenceNumber);
        if (value == null) {
            return 0;
        }
        return value;
    }

    @Override
    public Expression getInstance() {
        TotalItemCountFunction function = (TotalItemCountFunction)super.getInstance();
        function.results = new HashMap();
        return function;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.results = new HashMap();
    }

    @Override
    public String getCrosstabFilterGroup() {
        return this.crosstabFilterGroup;
    }

    @Override
    public void setCrosstabFilterGroup(String crosstabFilterGroup) {
        this.crosstabFilterGroup = crosstabFilterGroup;
    }
}

