/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.sys;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.layout.style.DefaultStyleCache;
import org.pentaho.reporting.engine.classic.core.layout.style.StyleCache;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.style.ResolverStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.css.CSSStyleResolver;
import org.pentaho.reporting.engine.classic.core.style.resolver.StyleResolver;
import org.pentaho.reporting.engine.classic.core.util.DoubleKeyedCounter;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class StyleResolvingEvaluator
extends AbstractElementFormatFunction
implements StructureFunction {
    private static final Log logger = LogFactory.getLog(StyleResolvingEvaluator.class);
    private static final StyleResolverCacheEntry INVALID = new StyleResolverCacheEntry(0L, 0L, 0L);
    private transient StyleResolver resolver;
    private transient ResolverStyleSheet styleSheet;
    private transient StyleCache styleCache = new DefaultStyleCache("StyleResolver");
    private DoubleKeyedCounter<String, Long> statisticsHit = new DoubleKeyedCounter();
    private DoubleKeyedCounter<String, Long> statisticsMiss = new DoubleKeyedCounter();

    @Override
    public void reportInitialized(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        ReportDefinition reportDefinition = this.locateMasterReport(event.getState());
        this.resolver = StyleResolvingEvaluator.createStyleResolver(reportDefinition, this.getRuntime().getProcessingContext());
        this.styleSheet = new ResolverStyleSheet();
        super.reportInitialized(event);
    }

    private ReportDefinition locateMasterReport(ReportState state) {
        ReportState parentState;
        if (state.isSubReportEvent() && (parentState = state.getParentState()) != null) {
            return this.locateMasterReport(parentState);
        }
        return state.getReport();
    }

    private static StyleResolver createStyleResolver(ReportDefinition reportDefinition, ProcessingContext pc) {
        ResourceManager resourceManager = pc.getResourceManager();
        ResourceKey contentBase = pc.getContentBase();
        return CSSStyleResolver.createDesignTimeResolver(reportDefinition, resourceManager, contentBase, false);
    }

    @Override
    protected void recordCacheHit(ReportElement e) {
        super.recordCacheHit(e);
        this.statisticsHit.increaseCounter(e.getElementType().getMetaData().getName(), e.getChangeTracker());
    }

    @Override
    protected void recordCacheMiss(ReportElement e) {
        super.recordCacheMiss(e);
        this.statisticsMiss.increaseCounter(e.getElementType().getMetaData().getName(), e.getChangeTracker());
    }

    @Override
    protected void reportCachePerformance() {
        super.reportCachePerformance();
    }

    @Override
    protected boolean evaluateElement(ReportElement e) {
        StyleResolverCacheEntry existingEntry;
        StyleResolverCacheEntry parentEntry = this.get(e.getParentSection());
        StyleResolverCacheEntry currentEntry = new StyleResolverCacheEntry(parentEntry, e);
        if (currentEntry.equals(existingEntry = this.get(e))) {
            return false;
        }
        try {
            e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "style-resolver-change-tracker", currentEntry, false);
            this.resolver.resolve(e, this.styleSheet);
            e.setComputedStyle(this.styleCache.getStyleSheet(this.styleSheet));
            return true;
        }
        catch (Exception ex) {
            throw new InvalidReportStateException("Failed to resolve style.", ex);
        }
    }

    private StyleResolverCacheEntry get(ReportElement element) {
        if (element == null) {
            return null;
        }
        Object attribute = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "style-resolver-change-tracker");
        StyleResolverCacheEntry cacheEntry = attribute instanceof StyleResolverCacheEntry ? (StyleResolverCacheEntry)attribute : null;
        return cacheEntry;
    }

    @Override
    public int getProcessingPriority() {
        return 50000;
    }

    @Override
    public void reportDone(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        super.reportDone(event);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.styleCache = new DefaultStyleCache("StyleResolver");
    }

    @Override
    public StyleResolvingEvaluator getInstance() {
        StyleResolvingEvaluator expression = (StyleResolvingEvaluator)super.getInstance();
        expression.styleCache = new DefaultStyleCache("StyleResolver");
        expression.statisticsHit = new DoubleKeyedCounter();
        expression.statisticsMiss = new DoubleKeyedCounter();
        return expression;
    }

    private static class StyleResolverCacheEntry
    implements Serializable {
        private long elementChangeTracker;
        private long styleChangeHash;
        private long styleModificationCount;

        private StyleResolverCacheEntry(long elementChangeTracker, long styleChangeHash, long styleModificationCount) {
            this.elementChangeTracker = elementChangeTracker;
            this.styleChangeHash = styleChangeHash;
            this.styleModificationCount = styleModificationCount;
        }

        public StyleResolverCacheEntry(StyleResolverCacheEntry parentEntry, ReportElement e) {
            if (parentEntry == null) {
                this.elementChangeTracker = e.getChangeTracker();
                this.styleChangeHash = e.getStyle().getChangeTrackerHash();
                this.styleModificationCount = e.getStyle().getModificationCount();
            } else {
                this.elementChangeTracker = parentEntry.getElementChangeTracker() * 31L + e.getChangeTracker();
                this.styleChangeHash = parentEntry.getStyleChangeHash() * 31L + e.getStyle().getChangeTrackerHash();
                this.styleModificationCount = parentEntry.getStyleModificationCount() * 31L + e.getStyle().getModificationCount();
            }
        }

        public long getElementChangeTracker() {
            return this.elementChangeTracker;
        }

        public long getStyleChangeHash() {
            return this.styleChangeHash;
        }

        public long getStyleModificationCount() {
            return this.styleModificationCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StyleResolverCacheEntry that = (StyleResolverCacheEntry)o;
            if (this.elementChangeTracker != that.elementChangeTracker) {
                return false;
            }
            if (this.styleChangeHash != that.styleChangeHash) {
                return false;
            }
            return this.styleModificationCount == that.styleModificationCount;
        }

        public int hashCode() {
            int result = (int)(this.elementChangeTracker ^ this.elementChangeTracker >>> 32);
            result = 31 * result + (int)(this.styleChangeHash ^ this.styleChangeHash >>> 32);
            result = 31 * result + (int)(this.styleModificationCount ^ this.styleModificationCount >>> 32);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("StyleResolverCacheEntry");
            sb.append("{elementChangeTracker=").append(this.elementChangeTracker);
            sb.append(", styleChangeHash=").append(this.styleChangeHash);
            sb.append(", styleModificationCount=").append(this.styleModificationCount);
            sb.append('}');
            return sb.toString();
        }
    }
}

