/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.text;

import java.awt.Image;
import java.awt.font.ImageGraphicAttribute;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableComplexText;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.text.RichTextImageProducer;
import org.pentaho.reporting.engine.classic.core.layout.process.text.RichTextSpec;
import org.pentaho.reporting.engine.classic.core.layout.process.util.ReplacedContentUtil;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextDirection;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class RichTextSpecProducer {
    private RichTextImageProducer imageProducer;
    private OutputProcessorMetaData metaData;

    public static RichTextSpec compute(RenderBox lineBoxContainer, OutputProcessorMetaData metaData, ResourceManager resourceManager) {
        return new RichTextSpecProducer(metaData, resourceManager).computeText(lineBoxContainer);
    }

    public RichTextSpecProducer(OutputProcessorMetaData metaData, ResourceManager resourceManager) {
        ArgumentNullException.validate((String)"metaData", (Object)metaData);
        ArgumentNullException.validate((String)"resourceManager", (Object)resourceManager);
        this.metaData = metaData;
        this.imageProducer = new RichTextImageProducer(metaData, resourceManager);
    }

    private RichTextSpec computeText(RenderBox lineBoxContainer) {
        List<AttributedStringChunk> attr = new ArrayList<AttributedStringChunk>();
        this.computeText(lineBoxContainer, attr);
        if (attr.isEmpty()) {
            attr.add(new AttributedStringChunk("", this.computeStyle(lineBoxContainer.getStyleSheet()), lineBoxContainer.getAttributes(), lineBoxContainer.getStyleSheet(), new InstanceID(), lineBoxContainer));
        }
        attr = this.processWhitespaceRules(lineBoxContainer, attr);
        StringBuilder text = new StringBuilder();
        for (AttributedStringChunk chunk : attr) {
            text.append(chunk.getText());
        }
        TextDirection direction = (TextDirection)lineBoxContainer.getStyleSheet().getStyleProperty(TextStyleKeys.DIRECTION, TextDirection.LTR);
        return new RichTextSpec(text.toString(), direction, this.convertNodes(attr));
    }

    public RichTextSpec computeText(RenderableComplexText textNode, String textChunk) {
        ArrayList<AttributedStringChunk> attr = new ArrayList<AttributedStringChunk>();
        attr.add(new AttributedStringChunk(textChunk, this.computeStyle(textNode.getStyleSheet()), textNode.getAttributes(), textNode.getStyleSheet(), textNode.getInstanceId(), textNode));
        StringBuilder text = new StringBuilder();
        for (AttributedStringChunk chunk : attr) {
            text.append(chunk.getText());
        }
        TextDirection direction = (TextDirection)textNode.getStyleSheet().getStyleProperty(TextStyleKeys.DIRECTION, TextDirection.LTR);
        return new RichTextSpec(text.toString(), direction, this.convertNodes(attr));
    }

    private List<RichTextSpec.StyledChunk> convertNodes(List<AttributedStringChunk> chunks) {
        ArrayList<RichTextSpec.StyledChunk> result = new ArrayList<RichTextSpec.StyledChunk>(chunks.size());
        int startPosition = 0;
        for (AttributedStringChunk chunk : chunks) {
            int length = chunk.getText().length();
            int endIndex = startPosition + length;
            result.add(new RichTextSpec.StyledChunk(startPosition, endIndex, chunk.getNode(), chunk.getAttributes(), chunk.getOriginalAttributes(), chunk.getStyleSheet(), chunk.getInstanceID(), chunk.getText()));
            startPosition = endIndex;
        }
        return result;
    }

    private List<AttributedStringChunk> processWhitespaceRules(RenderBox lineBoxContainer, List<AttributedStringChunk> attrs) {
        Object ws = lineBoxContainer.getStyleSheet().getStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE);
        if (WhitespaceCollapse.PRESERVE_BREAKS.equals(ws) || WhitespaceCollapse.COLLAPSE.equals(ws) || WhitespaceCollapse.DISCARD.equals(ws)) {
            // empty if block
        }
        return attrs;
    }

    private void computeText(RenderBox box, List<AttributedStringChunk> chunks) {
        for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
            if (node.getNodeType() == 273) {
                RenderableComplexText complexNode = (RenderableComplexText)node;
                chunks.add(new AttributedStringChunk(complexNode.getRawText(), this.computeStyle(node.getStyleSheet()), node.getAttributes(), node.getStyleSheet(), node.getInstanceId(), node));
                continue;
            }
            if (node.getNodeType() == 258) {
                RenderableReplacedContentBox contentBox = (RenderableReplacedContentBox)node;
                long width = ReplacedContentUtil.computeWidth(contentBox);
                long height = ReplacedContentUtil.computeHeight(contentBox, 0L, width);
                contentBox.setCachedWidth(width);
                contentBox.setCachedHeight(height);
                contentBox.setWidth(width);
                contentBox.setHeight(height);
                chunks.add(new AttributedStringChunk("@", this.computeImageStyle(node.getStyleSheet(), contentBox), node.getAttributes(), node.getStyleSheet(), node.getInstanceId(), node));
                continue;
            }
            if (!(node instanceof RenderBox)) continue;
            this.computeText((RenderBox)node, chunks);
        }
    }

    private Map<AttributedCharacterIterator.Attribute, Object> computeImageStyle(StyleSheet layoutContext, RenderableReplacedContentBox content) {
        Image image = this.imageProducer.createImagePlaceholder(content);
        ImageGraphicAttribute iga = new ImageGraphicAttribute(image, -2);
        Map<AttributedCharacterIterator.Attribute, Object> attrs = this.computeStyle(layoutContext);
        attrs.put(TextAttribute.CHAR_REPLACEMENT, iga);
        return attrs;
    }

    private Map<AttributedCharacterIterator.Attribute, Object> computeStyle(StyleSheet layoutContext) {
        HashMap<AttributedCharacterIterator.Attribute, Object> result = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        if (layoutContext.getBooleanStyleProperty(TextStyleKeys.ITALIC)) {
            result.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            result.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        }
        if (layoutContext.getBooleanStyleProperty(TextStyleKeys.BOLD)) {
            result.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            result.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        }
        String fontNameRaw = (String)layoutContext.getStyleProperty(TextStyleKeys.FONT);
        String fontName = this.metaData.getNormalizedFontFamilyName(fontNameRaw);
        result.put(TextAttribute.FAMILY, fontName);
        result.put(TextAttribute.SIZE, layoutContext.getIntStyleProperty(TextStyleKeys.FONTSIZE, 12));
        if (layoutContext.getBooleanStyleProperty(TextStyleKeys.UNDERLINED)) {
            result.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (layoutContext.getBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH)) {
            result.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        result.put(TextAttribute.TRACKING, layoutContext.getDoubleStyleProperty(TextStyleKeys.X_MIN_LETTER_SPACING, 0.0) / 10.0);
        return result;
    }

    private static class AttributedStringChunk {
        private String text;
        private Map<AttributedCharacterIterator.Attribute, Object> attributes;
        private ReportAttributeMap<Object> originalAttributes;
        private StyleSheet styleSheet;
        private InstanceID instanceID;
        private RenderNode node;

        private AttributedStringChunk(String text, Map<AttributedCharacterIterator.Attribute, Object> attributes, ReportAttributeMap<Object> originalAttributes, StyleSheet styleSheet, InstanceID instanceID, RenderNode node) {
            ArgumentNullException.validate((String)"text", (Object)text);
            ArgumentNullException.validate((String)"attributes", attributes);
            ArgumentNullException.validate((String)"node", (Object)node);
            ArgumentNullException.validate((String)"originalAttributes", originalAttributes);
            ArgumentNullException.validate((String)"styleSheet", (Object)styleSheet);
            ArgumentNullException.validate((String)"instanceID", (Object)instanceID);
            this.text = text.length() == 0 ? "\u0200" : text;
            this.instanceID = instanceID;
            this.node = node;
            this.attributes = attributes;
            this.originalAttributes = originalAttributes;
            this.styleSheet = styleSheet;
        }

        public String getText() {
            return this.text;
        }

        public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
            return this.attributes;
        }

        public ReportAttributeMap<Object> getOriginalAttributes() {
            return this.originalAttributes;
        }

        public StyleSheet getStyleSheet() {
            return this.styleSheet;
        }

        public InstanceID getInstanceID() {
            return this.instanceID;
        }

        public RenderNode getNode() {
            return this.node;
        }
    }
}

