/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.text;

import org.pentaho.reporting.engine.classic.core.layout.text.Glyph;
import org.pentaho.reporting.libraries.fonts.text.Spacing;

public final class DefaultGlyph
implements Glyph {
    private static final int[] EMPTY_EXTRA_CHARS = new int[0];
    private int codepoint;
    private int breakWeight;
    private int classification;
    private Spacing spacing;
    private int width;
    private int height;
    private int baseLine;
    private int kerning;
    private int[] extraChars;

    public DefaultGlyph(int codepoint, int breakWeight, int classification, Spacing spacing, int width, int height, int baseLine, int kerning, int[] extraChars) {
        this.spacing = spacing == null ? Spacing.EMPTY_SPACING : spacing;
        this.extraChars = extraChars == null ? EMPTY_EXTRA_CHARS : (extraChars.length == 0 ? EMPTY_EXTRA_CHARS : (int[])extraChars.clone());
        this.baseLine = baseLine;
        this.codepoint = codepoint;
        this.breakWeight = breakWeight;
        this.width = width;
        this.height = height;
        this.classification = classification;
        this.kerning = kerning;
    }

    @Override
    public int getClassification() {
        return this.classification;
    }

    @Override
    public int[] getExtraChars() {
        if (this.extraChars.length == 0) {
            return EMPTY_EXTRA_CHARS;
        }
        return (int[])this.extraChars.clone();
    }

    @Override
    public int getBaseLine() {
        return this.baseLine;
    }

    @Override
    public int getCodepoint() {
        return this.codepoint;
    }

    @Override
    public int getBreakWeight() {
        return this.breakWeight;
    }

    @Override
    public Spacing getSpacing() {
        return this.spacing;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getKerning() {
        return this.kerning;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultGlyph glyph = (DefaultGlyph)o;
        if (this.breakWeight != glyph.breakWeight) {
            return false;
        }
        if (this.codepoint != glyph.codepoint) {
            return false;
        }
        if (this.height != glyph.height) {
            return false;
        }
        if (this.kerning != glyph.kerning) {
            return false;
        }
        if (this.width != glyph.width) {
            return false;
        }
        return this.spacing.equals((Object)glyph.spacing);
    }

    public int hashCode() {
        int result = this.codepoint;
        result = 29 * result + this.breakWeight;
        result = 29 * result + this.spacing.hashCode();
        result = 29 * result + this.width;
        result = 29 * result + this.height;
        result = 29 * result + this.kerning;
        return result;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "={codepoint='" + (char)(this.codepoint & 0xFFFF) + ", extra-chars=" + this.extraChars.length + '}';
    }
}

