/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractMetaDataReadHandler
extends AbstractXmlReadHandler {
    private String name;
    private boolean preferred;
    private boolean expert;
    private boolean hidden;
    private boolean deprecated;
    private String bundle;
    private boolean experimental;
    private int compatibilityLevel;

    protected AbstractMetaDataReadHandler() {
    }

    protected AbstractMetaDataReadHandler(String bundle) {
        this.bundle = bundle;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        String bundleFromAttributes;
        if (!this.isDerivedName()) {
            this.name = attrs.getValue(this.getUri(), "name");
            if (this.name == null) {
                throw new ParseException("Attribute 'name' is undefined", this.getLocator());
            }
        }
        if ((bundleFromAttributes = attrs.getValue(this.getUri(), "bundle-name")) != null) {
            this.bundle = bundleFromAttributes;
        }
        this.experimental = "true".equals(attrs.getValue(this.getUri(), "experimental"));
        this.expert = "true".equals(attrs.getValue(this.getUri(), "expert"));
        this.hidden = "true".equals(attrs.getValue(this.getUri(), "hidden"));
        this.preferred = "true".equals(attrs.getValue(this.getUri(), "preferred"));
        this.deprecated = "true".equals(attrs.getValue(this.getUri(), "deprecated"));
        this.compatibilityLevel = ReportParserUtil.parseVersion(attrs.getValue(this.getUri(), "compatibility-level"));
    }

    protected boolean isDerivedName() {
        return false;
    }

    public int getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String getBundle() {
        return this.bundle;
    }

    public boolean isExperimental() {
        return this.experimental;
    }
}

