/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import org.pentaho.reporting.engine.classic.core.metadata.AttributeCore;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultAttributeCore;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AbstractMetaDataReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AttributeDefinition;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AttributeReadHandler
extends AbstractMetaDataReadHandler {
    private String namespace;
    private String namespacePrefix;
    private boolean mandatory;
    private boolean computed;
    private boolean transientFlag;
    private Class<?> valueType;
    private String valueRole;
    private boolean bulk;
    private String propertyEditor;
    private boolean designTimeValue;
    private AttributeCore attributeCore;

    public AttributeReadHandler(String bundle) {
        super(bundle);
    }

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.namespace = attrs.getValue(this.getUri(), "namespace");
        if (this.namespace == null) {
            throw new ParseException("Attribute 'namespace' is undefined", this.getLocator());
        }
        this.namespacePrefix = attrs.getValue(this.getUri(), "namespace-prefix");
        if (this.namespacePrefix == null) {
            this.namespacePrefix = ElementTypeRegistry.getInstance().getNamespacePrefix(this.namespace);
        }
        this.mandatory = "true".equals(attrs.getValue(this.getUri(), "mandatory"));
        this.computed = "true".equals(attrs.getValue(this.getUri(), "computed"));
        this.transientFlag = "true".equals(attrs.getValue(this.getUri(), "transient"));
        this.bulk = "true".equals(attrs.getValue(this.getUri(), "prefer-bulk"));
        this.designTimeValue = "true".equals(attrs.getValue(this.getUri(), "design-time-value"));
        String valueTypeText = attrs.getValue(this.getUri(), "value-type");
        if (valueTypeText == null) {
            throw new ParseException("Attribute 'value-type' is undefined", this.getLocator());
        }
        try {
            ClassLoader classLoader = ObjectUtilities.getClassLoader(((Object)((Object)this)).getClass());
            this.valueType = Class.forName(valueTypeText, false, classLoader);
        }
        catch (Exception e) {
            throw new ParseException("Attribute 'value-type' is not valid", e, this.getLocator());
        }
        this.valueRole = attrs.getValue(this.getUri(), "value-role");
        if (this.valueRole == null) {
            this.valueRole = "Value";
        }
        this.propertyEditor = attrs.getValue(this.getUri(), "propertyEditor");
        String metaDataCoreClass = attrs.getValue(this.getUri(), "impl");
        if (metaDataCoreClass != null) {
            this.attributeCore = (AttributeCore)ObjectUtilities.loadAndInstantiate((String)metaDataCoreClass, AttributeReadHandler.class, AttributeCore.class);
            if (this.attributeCore == null) {
                throw new ParseException("Attribute 'impl' references a invalid AttributeCore implementation.", this.getLocator());
            }
        } else {
            this.attributeCore = new DefaultAttributeCore();
        }
    }

    public AttributeCore getAttributeCore() {
        return this.attributeCore;
    }

    public String getPropertyEditor() {
        return this.propertyEditor;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isComputed() {
        return this.computed;
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public Class getValueType() {
        return this.valueType;
    }

    public boolean isBulk() {
        return this.bulk;
    }

    public String getValueRole() {
        return this.valueRole;
    }

    public AttributeDefinition getObject() throws SAXException {
        return new AttributeDefinition(this.namespace, this.namespacePrefix, this.getName(), this.isPreferred(), this.mandatory, this.isExpert(), this.isHidden(), this.computed, this.transientFlag, this.valueType, this.valueRole, this.propertyEditor, this.isDeprecated(), this.bulk, this.designTimeValue, this.getBundle(), this.attributeCore, this.isExperimental(), this.getCompatibilityLevel());
    }

    public boolean isDesignTimeValue() {
        return this.designTimeValue;
    }
}

