/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.DataFactoryScriptingSupport;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.SimpleSQLReportDataFactory;

public class SQLReportDataFactory
extends SimpleSQLReportDataFactory {
    private DataFactoryScriptingSupport scriptingSupport = new DataFactoryScriptingSupport();

    public SQLReportDataFactory(Connection connection) {
        super(connection);
    }

    public SQLReportDataFactory(ConnectionProvider connectionProvider) {
        super(connectionProvider);
    }

    @Override
    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.scriptingSupport.containsQuery(query);
    }

    public void setQuery(String name, String queryString) {
        if (queryString == null) {
            this.scriptingSupport.remove(name);
        } else {
            this.scriptingSupport.setQuery(name, queryString, null, null);
        }
    }

    public void setQuery(String name, String queryString, String queryScriptLanguage, String queryScript) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.scriptingSupport.setQuery(name, queryString, queryScriptLanguage, queryScript);
    }

    public void remove(String name) {
        this.scriptingSupport.remove(name);
    }

    public String getGlobalScriptLanguage() {
        return this.scriptingSupport.getGlobalScriptLanguage();
    }

    public void setGlobalScriptLanguage(String scriptLanguage) {
        this.scriptingSupport.setGlobalScriptLanguage(scriptLanguage);
    }

    public String getGlobalScript() {
        return this.scriptingSupport.getGlobalScript();
    }

    public void setGlobalScript(String globalScript) {
        this.scriptingSupport.setGlobalScript(globalScript);
    }

    public String getScriptingLanguage(String name) {
        return this.scriptingSupport.getScriptingLanguage(name);
    }

    public String getScript(String name) {
        return this.scriptingSupport.getScript(name);
    }

    public String getQuery(String name) {
        return this.scriptingSupport.getQuery(name);
    }

    @Override
    public String[] getQueryNames() {
        return this.scriptingSupport.getQueryNames();
    }

    @Override
    public void initialize(DataFactoryContext dataFactoryContext) throws ReportDataFactoryException {
        super.initialize(dataFactoryContext);
        this.scriptingSupport.initialize(this, dataFactoryContext);
    }

    @Override
    public synchronized TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        if (query == null) {
            throw new NullPointerException("Query is null.");
        }
        String realQuery = this.scriptingSupport.computeQuery(query, parameters);
        if (realQuery == null) {
            throw new ReportDataFactoryException("Query '" + query + "' is not recognized.");
        }
        TableModel queryResult = super.queryData(realQuery, parameters);
        TableModel postProcessResult = this.scriptingSupport.postProcessResult(query, parameters, queryResult);
        return postProcessResult;
    }

    @Override
    public String[] getReferencedFields(String query, DataRow parameter) throws ReportDataFactoryException {
        String[] additionalFields = this.scriptingSupport.computeAdditionalQueryFields(query, parameter);
        if (additionalFields == null) {
            return null;
        }
        LinkedHashSet<String> fields = new LinkedHashSet<String>(Arrays.asList(super.getReferencedFields(query, parameter)));
        fields.addAll(Arrays.asList(additionalFields));
        return fields.toArray(new String[fields.size()]);
    }

    @Override
    public ArrayList<Object> getQueryHash(String queryName, DataRow parameter) {
        ArrayList<Object> queryHash = super.getQueryHash(queryName, parameter);
        queryHash.add(this.scriptingSupport.getScriptingLanguage(queryName));
        queryHash.add(this.scriptingSupport.getScript(queryName));
        return queryHash;
    }

    @Override
    public SQLReportDataFactory clone() {
        SQLReportDataFactory dataFactory = (SQLReportDataFactory)super.clone();
        dataFactory.scriptingSupport = (DataFactoryScriptingSupport)this.scriptingSupport.clone();
        return dataFactory;
    }

    @Override
    protected String computedQuery(String queryName, DataRow parameters) throws ReportDataFactoryException {
        return this.scriptingSupport.computeQuery(queryName, parameters);
    }

    @Override
    protected String translateQuery(String query) {
        return this.scriptingSupport.getQuery(query);
    }
}

